/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.InternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.search.SearchMessages;

public class JavaSearchEditorOpener {
    private IEditorReference fReusedEditor;

    public IEditorPart openElement(Object element) throws PartInitException, JavaModelException {
        IWorkbenchPage wbPage = JavaPlugin.getActivePage();
        if (NewSearchUI.reuseEditor()) {
            return this.showWithReuse(element, wbPage);
        }
        return this.showWithoutReuse(element, wbPage);
    }

    public IEditorPart openMatch(Match match) throws PartInitException, JavaModelException {
        Object element = this.getElementToOpen(match);
        return this.openElement(element);
    }

    protected Object getElementToOpen(Match match) {
        return match.getElement();
    }

    private IEditorPart showWithoutReuse(Object element, IWorkbenchPage wbPage) throws PartInitException, JavaModelException {
        return EditorUtility.openInEditor(element, false);
    }

    private IEditorPart showWithReuse(Object element, IWorkbenchPage wbPage) throws JavaModelException, PartInitException {
        IFile file = this.getFile(element);
        if (file != null) {
            String editorID = this.getEditorID(file);
            return this.showInEditor(wbPage, (IEditorInput)new FileEditorInput(file), editorID);
        }
        IClassFile cf = this.getClassFile(element);
        if (cf != null) {
            return this.showInEditor(wbPage, new InternalClassFileEditorInput(cf), "org.eclipse.wst.jsdt.ui.ClassFileEditor");
        }
        return null;
    }

    private IFile getFile(Object element) throws JavaModelException {
        if (element instanceof IFile) {
            return (IFile)element;
        }
        if (element instanceof IJavaElement) {
            IJavaElement jElement = (IJavaElement)element;
            ICompilationUnit cu = (ICompilationUnit)jElement.getAncestor(5);
            if (cu != null) {
                return (IFile)cu.getCorrespondingResource();
            }
            IClassFile cf = (IClassFile)jElement.getAncestor(6);
            if (cf != null) {
                return (IFile)cf.getCorrespondingResource();
            }
        }
        return null;
    }

    private String getEditorID(IFile file) throws PartInitException {
        IEditorDescriptor desc = IDE.getEditorDescriptor((IFile)file);
        if (desc == null) {
            return JavaPlugin.getDefault().getWorkbench().getEditorRegistry().findEditor("org.eclipse.ui.systemExternalEditor").getId();
        }
        return desc.getId();
    }

    private IEditorPart showInEditor(IWorkbenchPage page, IEditorInput input, String editorId) {
        IEditorPart editor = page.findEditor(input);
        if (editor != null) {
            page.bringToTop((IWorkbenchPart)editor);
            return editor;
        }
        IEditorReference reusedEditorRef = this.fReusedEditor;
        if (reusedEditorRef != null) {
            boolean canBeReused;
            boolean isOpen = reusedEditorRef.getEditor(false) != null;
            boolean bl = canBeReused = isOpen && !reusedEditorRef.isDirty() && !reusedEditorRef.isPinned();
            if (canBeReused) {
                boolean showsSameInputType = reusedEditorRef.getId().equals(editorId);
                if (!showsSameInputType) {
                    page.closeEditors(new IEditorReference[]{reusedEditorRef}, false);
                    this.fReusedEditor = null;
                } else {
                    editor = reusedEditorRef.getEditor(true);
                    if (editor instanceof IReusableEditor) {
                        ((IReusableEditor)editor).setInput(input);
                        page.bringToTop((IWorkbenchPart)editor);
                        return editor;
                    }
                }
            }
        }
        try {
            IEditorReference reference;
            editor = page.openEditor(input, editorId, false);
            this.fReusedEditor = editor instanceof IReusableEditor ? (reference = (IEditorReference)page.getReference((IWorkbenchPart)editor)) : null;
            return editor;
        }
        catch (PartInitException partInitException) {
            MessageDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)SearchMessages.Search_Error_openEditor_title, (String)SearchMessages.Search_Error_openEditor_message);
            return null;
        }
    }

    private IClassFile getClassFile(Object element) {
        if (!(element instanceof IJavaElement)) {
            return null;
        }
        if (element instanceof IClassFile) {
            return (IClassFile)element;
        }
        IJavaElement jElement = (IJavaElement)element;
        if (jElement instanceof IMember) {
            return ((IMember)jElement).getClassFile();
        }
        return null;
    }
}

