/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.search.ui.IQueryListener;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaElementDelta;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchResult;

public class SearchResultUpdater
implements IElementChangedListener,
IQueryListener {
    JavaSearchResult fResult;
    private static final int REMOVED_FLAGS = 1185;

    public SearchResultUpdater(JavaSearchResult result) {
        this.fResult = result;
        NewSearchUI.addQueryListener((IQueryListener)this);
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    public void elementChanged(ElementChangedEvent event) {
        IJavaElementDelta delta = event.getDelta();
        HashSet removedElements = new HashSet();
        HashSet potentiallyRemovedElements = new HashSet();
        this.collectRemoved(potentiallyRemovedElements, removedElements, delta);
        if (removedElements.size() > 0) {
            this.handleRemoved(removedElements);
        }
        if (potentiallyRemovedElements.size() > 0) {
            this.handleRemoved(potentiallyRemovedElements);
        }
    }

    private void handleRemoved(Set removedElements) {
        Object[] elements = this.fResult.getElements();
        int i = 0;
        while (i < elements.length) {
            if (this.isContainedInRemoved(removedElements, elements[i])) {
                IResource resource;
                int j;
                Match[] matches;
                if (elements[i] instanceof IJavaElement) {
                    IJavaElement je = (IJavaElement)elements[i];
                    if (!je.exists()) {
                        matches = this.fResult.getMatches(elements[i]);
                        j = 0;
                        while (j < matches.length) {
                            this.fResult.removeMatch(matches[j]);
                            ++j;
                        }
                    }
                } else if (elements[i] instanceof IResource && !(resource = (IResource)elements[i]).exists()) {
                    matches = this.fResult.getMatches(elements[i]);
                    j = 0;
                    while (j < matches.length) {
                        this.fResult.removeMatch(matches[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private boolean isContainedInRemoved(Set removedElements, Object object) {
        Iterator elements = removedElements.iterator();
        while (elements.hasNext()) {
            if (!this.isParentOf(elements.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean isParentOf(Object ancestor, Object descendant) {
        while (descendant != null && !ancestor.equals(descendant)) {
            descendant = this.getParent(descendant);
        }
        return descendant != null;
    }

    private Object getParent(Object object) {
        if (object instanceof IJavaElement) {
            return ((IJavaElement)object).getParent();
        }
        if (object instanceof IResource) {
            return ((IResource)object).getParent();
        }
        return null;
    }

    private void collectRemoved(Set potentiallyRemovedSet, Set removedElements, IJavaElementDelta delta) {
        if (delta.getKind() == 2) {
            removedElements.add(delta.getElement());
        } else if (delta.getKind() == 4) {
            int flags = delta.getFlags();
            if ((flags & 0x4A1) != 0) {
                potentiallyRemovedSet.add(delta.getElement());
            } else {
                IJavaElementDelta[] childDeltas = delta.getAffectedChildren();
                int i = 0;
                while (i < childDeltas.length) {
                    this.collectRemoved(potentiallyRemovedSet, removedElements, childDeltas[i]);
                    ++i;
                }
            }
        }
        IResourceDelta[] resourceDeltas = delta.getResourceDeltas();
        if (resourceDeltas != null) {
            int i = 0;
            while (i < resourceDeltas.length) {
                this.collectRemovals(removedElements, resourceDeltas[i]);
                ++i;
            }
        }
    }

    public void queryAdded(ISearchQuery query) {
    }

    public void queryRemoved(ISearchQuery query) {
        if (((Object)((Object)this.fResult)).equals(query.getSearchResult())) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            NewSearchUI.removeQueryListener((IQueryListener)this);
        }
    }

    private void collectRemovals(Set removals, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            removals.add(delta.getResource());
        } else {
            IResourceDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                this.collectRemovals(removals, children[i]);
                ++i;
            }
        }
    }

    public void queryStarting(ISearchQuery query) {
    }

    public void queryFinished(ISearchQuery query) {
    }
}

