/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.lang.reflect.Modifier;
import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ListRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class AddArgumentCorrectionProposal
extends LinkedCorrectionProposal {
    private int[] fInsertIndexes;
    private ITypeBinding[] fParamTypes;
    private ASTNode fCallerNode;

    public AddArgumentCorrectionProposal(String label, ICompilationUnit cu, ASTNode callerNode, int[] insertIdx, ITypeBinding[] expectedTypes, int relevance) {
        super(label, cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fCallerNode = callerNode;
        this.fInsertIndexes = insertIdx;
        this.fParamTypes = expectedTypes;
    }

    protected ASTRewrite getRewrite() {
        AST ast = this.fCallerNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        ChildListPropertyDescriptor property = this.getProperty();
        int i = 0;
        while (i < this.fInsertIndexes.length) {
            int idx = this.fInsertIndexes[i];
            String key = "newarg_" + i;
            Expression newArg = this.evaluateArgumentExpressions(ast, this.fParamTypes[idx], key);
            ListRewrite listRewriter = rewrite.getListRewrite(this.fCallerNode, property);
            listRewriter.insertAt((ASTNode)newArg, idx, null);
            this.addLinkedPosition(rewrite.track((ASTNode)newArg), i == 0, key);
            ++i;
        }
        return rewrite;
    }

    private ChildListPropertyDescriptor getProperty() {
        List list = this.fCallerNode.structuralPropertiesForType();
        int i = 0;
        while (i < list.size()) {
            StructuralPropertyDescriptor curr = (StructuralPropertyDescriptor)list.get(i);
            if (curr.isChildListProperty() && "arguments".equals(curr.getId())) {
                return (ChildListPropertyDescriptor)curr;
            }
            ++i;
        }
        return null;
    }

    private Expression evaluateArgumentExpressions(AST ast, ITypeBinding requiredType, String key) {
        CompilationUnit root = (CompilationUnit)this.fCallerNode.getRoot();
        int offset = this.fCallerNode.getStartPosition();
        Expression best = null;
        ITypeBinding bestType = null;
        ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
        IBinding[] bindings = analyzer.getDeclarationsInScope(offset, 2);
        int i = 0;
        while (i < bindings.length) {
            IVariableBinding curr = (IVariableBinding)bindings[i];
            ITypeBinding type = curr.getType();
            if (type != null && this.canAssign(type, requiredType) && this.testModifier(curr)) {
                if (best == null || this.isMoreSpecific(bestType, type)) {
                    best = ast.newSimpleName(curr.getName());
                    bestType = type;
                }
                this.addLinkedPositionProposal(key, curr.getName(), null);
            }
            ++i;
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, requiredType);
        if (best == null) {
            best = defaultExpression;
        }
        this.addLinkedPositionProposal(key, ASTNodes.asString((ASTNode)defaultExpression), null);
        return best;
    }

    private boolean isMoreSpecific(ITypeBinding best, ITypeBinding curr) {
        return this.canAssign(best, curr) && !this.canAssign(curr, best);
    }

    private boolean canAssign(ITypeBinding curr, ITypeBinding best) {
        return curr.isAssignmentCompatible(best);
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic(modifiers) || ASTResolving.isInStaticContext(this.fCallerNode);
    }
}

