/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.IMarkerResolutionGenerator2;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;
import org.eclipse.wst.jsdt.core.CorrectionEngine;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTRequestor;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.internal.corext.fix.IFix;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.MultiStateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.fix.ICleanUp;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaMarkerAnnotation;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.wst.jsdt.internal.ui.text.correction.AssistContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.FixCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ProblemLocation;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.text.java.CompletionProposalComparator;
import org.eclipse.wst.jsdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.wst.jsdt.ui.text.java.IProblemLocation;

public class CorrectionMarkerResolutionGenerator
implements IMarkerResolutionGenerator,
IMarkerResolutionGenerator2 {
    private static final IMarkerResolution[] NO_RESOLUTIONS = new IMarkerResolution[0];

    public boolean hasResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalHasResolutions(marker);
    }

    public IMarkerResolution[] getResolutions(IMarker marker) {
        return CorrectionMarkerResolutionGenerator.internalGetResolutions(marker);
    }

    private static boolean internalHasResolutions(IMarker marker) {
        int id = marker.getAttribute("id", -1);
        ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
        return cu != null && JavaCorrectionProcessor.hasCorrections(cu, id, MarkerUtilities.getMarkerType((IMarker)marker));
    }

    private static IMarkerResolution[] internalGetResolutions(IMarker marker) {
        if (!CorrectionMarkerResolutionGenerator.internalHasResolutions(marker)) {
            return NO_RESOLUTIONS;
        }
        try {
            IProblemLocation location;
            IEditorInput input;
            ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
            if (cu != null && (input = EditorUtility.getEditorInput(cu)) != null && (location = CorrectionMarkerResolutionGenerator.findProblemLocation(input, marker)) != null) {
                AssistContext context = new AssistContext(cu, location.getOffset(), location.getLength());
                if (!CorrectionMarkerResolutionGenerator.hasProblem(context.getASTRoot().getProblems(), location)) {
                    return NO_RESOLUTIONS;
                }
                ArrayList proposals = new ArrayList();
                JavaCorrectionProcessor.collectCorrections(context, new IProblemLocation[]{location}, proposals);
                Collections.sort(proposals, new CompletionProposalComparator());
                int nProposals = proposals.size();
                IMarkerResolution[] resolutions = new IMarkerResolution[nProposals];
                int i = 0;
                while (i < nProposals) {
                    resolutions[i] = new CorrectionMarkerResolution(context.getCompilationUnit(), location.getOffset(), location.getLength(), (IJavaCompletionProposal)proposals.get(i), marker);
                    ++i;
                }
                return resolutions;
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return NO_RESOLUTIONS;
    }

    private static boolean hasProblem(IProblem[] problems, IProblemLocation location) {
        int i = 0;
        while (i < problems.length) {
            IProblem problem = problems[i];
            if (problem.getID() == location.getProblemId() && problem.getSourceStart() == location.getOffset()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static ICompilationUnit getCompilationUnit(IMarker marker) {
        IJavaElement element;
        IResource res = marker.getResource();
        if (res instanceof IFile && res.isAccessible() && (element = JavaCore.create((IFile)((IFile)res))) instanceof ICompilationUnit) {
            return (ICompilationUnit)element;
        }
        return null;
    }

    private static IProblemLocation findProblemLocation(IEditorInput input, IMarker marker) {
        IAnnotationModel model = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getAnnotationModel(input);
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                Position pos;
                JavaMarkerAnnotation annot;
                Object curr = iter.next();
                if (!(curr instanceof JavaMarkerAnnotation) || !marker.equals((Object)(annot = (JavaMarkerAnnotation)curr).getMarker()) || (pos = model.getPosition((Annotation)annot)) == null) continue;
                return new ProblemLocation(pos.getOffset(), pos.getLength(), annot);
            }
        } else {
            ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
            return CorrectionMarkerResolutionGenerator.createFromMarker(marker, cu);
        }
        return null;
    }

    private static IProblemLocation createFromMarker(IMarker marker, ICompilationUnit cu) {
        try {
            int id = marker.getAttribute("id", -1);
            int start = marker.getAttribute("charStart", -1);
            int end = marker.getAttribute("charEnd", -1);
            int severity = marker.getAttribute("severity", 0);
            String[] arguments = CorrectionEngine.getProblemArguments((IMarker)marker);
            String markerType = marker.getType();
            if (cu != null && id != -1 && start != -1 && end != -1 && arguments != null) {
                boolean isError = severity == 2;
                return new ProblemLocation(start, end - start, id, arguments, isError, markerType);
            }
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    public static class CorrectionMarkerResolution
    extends WorkbenchMarkerResolution {
        private static final IMarker[] NO_MARKERS = new IMarker[0];
        private static final int BATCH_SIZE = 40;
        private ICompilationUnit fCompilationUnit;
        private int fOffset;
        private int fLength;
        private IJavaCompletionProposal fProposal;
        private final IMarker fMarker;

        public CorrectionMarkerResolution(ICompilationUnit cu, int offset, int length, IJavaCompletionProposal proposal, IMarker marker) {
            this.fCompilationUnit = cu;
            this.fOffset = offset;
            this.fLength = length;
            this.fProposal = proposal;
            this.fMarker = marker;
        }

        public String getLabel() {
            return this.fProposal.getDisplayString();
        }

        public void run(IMarker marker) {
            try {
                IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                if (part == null && (part = JavaUI.openInEditor((IJavaElement)this.fCompilationUnit, true, false)) instanceof ITextEditor) {
                    ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                }
                if (part != null) {
                    IEditorInput input = part.getEditorInput();
                    IDocument doc = JavaPlugin.getDefault().getCompilationUnitDocumentProvider().getDocument(input);
                    this.fProposal.apply(doc);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run(IMarker[] markers, IProgressMonitor monitor) {
            if (markers.length == 1) {
                this.run(markers[0]);
                return;
            }
            IProgressMonitor pm = monitor;
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            try {
                block31: {
                    Object var13_16;
                    CompositeChange allChanges;
                    block34: {
                        block33: {
                            block32: {
                                ICleanUp cleanUp;
                                if (!(this.fProposal instanceof FixCorrectionProposal) || (cleanUp = ((FixCorrectionProposal)this.fProposal).getCleanUp()) == null) break block31;
                                Hashtable problemLocations = new Hashtable();
                                int i = 0;
                                while (i < markers.length) {
                                    IMarker marker = markers[i];
                                    ICompilationUnit cu = CorrectionMarkerResolutionGenerator.getCompilationUnit(marker);
                                    if (cu != null) {
                                        try {
                                            IEditorInput input = EditorUtility.getEditorInput(cu);
                                            IProblemLocation location = CorrectionMarkerResolutionGenerator.findProblemLocation(input, marker);
                                            if (location != null) {
                                                if (!problemLocations.containsKey(cu.getPrimary())) {
                                                    problemLocations.put(cu.getPrimary(), new ArrayList());
                                                }
                                                List l = (List)problemLocations.get(cu.getPrimary());
                                                l.add(location);
                                            }
                                        }
                                        catch (JavaModelException e) {
                                            JavaPlugin.log(e);
                                        }
                                    }
                                    ++i;
                                }
                                if (problemLocations.size() <= 0) break block31;
                                Set cus = problemLocations.keySet();
                                Hashtable projects = new Hashtable();
                                Iterator iter = cus.iterator();
                                while (iter.hasNext()) {
                                    ICompilationUnit cu = (ICompilationUnit)iter.next();
                                    IJavaProject project = cu.getJavaProject();
                                    if (!projects.containsKey(project)) {
                                        projects.put(project, new ArrayList());
                                    }
                                    ((List)projects.get(project)).add(cu);
                                }
                                pm.beginTask("", problemLocations.size() * 2 + 2 + projects.keySet().size());
                                String name = "";
                                String[] descriptions = cleanUp.getDescriptions();
                                if (descriptions != null && descriptions.length == 1) {
                                    name = descriptions[0];
                                }
                                allChanges = new CompositeChange(name);
                                Iterator projectIter = projects.keySet().iterator();
                                while (projectIter.hasNext()) {
                                    Object var16_20;
                                    IJavaProject project = (IJavaProject)projectIter.next();
                                    List compilationUnitsList = (List)projects.get(project);
                                    ICompilationUnit[] compilationUnits = compilationUnitsList.toArray(new ICompilationUnit[compilationUnitsList.size()]);
                                    try {
                                        try {
                                            this.cleanUpProject(project, compilationUnits, cleanUp, problemLocations, allChanges, pm);
                                        }
                                        catch (CoreException e) {
                                            JavaPlugin.log(e);
                                        }
                                        var16_20 = null;
                                    }
                                    catch (Throwable throwable) {
                                        var16_20 = null;
                                        pm.worked(1);
                                        throw throwable;
                                    }
                                    pm.worked(1);
                                }
                                if (!pm.isCanceled()) break block32;
                                break block33;
                            }
                            allChanges.initializeValidationData((IProgressMonitor)new SubProgressMonitor(pm, 1));
                            if (this.validChanges(allChanges)) break block34;
                        }
                        Object var18_22 = null;
                        pm.done();
                        return;
                    }
                    PerformChangeOperation op = new PerformChangeOperation((Change)allChanges);
                    op.setUndoManager(RefactoringCore.getUndoManager(), allChanges.getName());
                    try {
                        try {
                            op.run((IProgressMonitor)new SubProgressMonitor(pm, 1));
                        }
                        catch (CoreException e1) {
                            JavaPlugin.log(e1);
                        }
                        var13_16 = null;
                    }
                    catch (Throwable throwable) {
                        var13_16 = null;
                        pm.worked(1);
                        throw throwable;
                    }
                    pm.worked(1);
                    IEditorPart part = EditorUtility.isOpenInEditor(this.fCompilationUnit);
                    if (part instanceof ITextEditor) {
                        ((ITextEditor)part).selectAndReveal(this.fOffset, this.fLength);
                        part.setFocus();
                    }
                }
                Object var18_24 = null;
            }
            catch (Throwable throwable) {
                Object var18_23 = null;
                pm.done();
                throw throwable;
            }
            pm.done();
        }

        private boolean validChanges(CompositeChange change) {
            RefactoringStatus result = new RefactoringStatus();
            ArrayList files = new ArrayList();
            try {
                this.findFilesToBeModified(change, files);
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
                return false;
            }
            result.merge(Checks.validateModifiesFiles(files.toArray(new IFile[files.size()]), JavaPlugin.getActiveWorkbenchShell().getShell()));
            if (result.hasFatalError()) {
                MultiStatus status;
                RefactoringStatusEntry[] entries = result.getEntries();
                if (entries.length > 1) {
                    status = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, result.getMessageMatchingSeverity(3), null);
                    int i = 0;
                    while (i < entries.length) {
                        status.add((IStatus)new Status(entries[i].getSeverity(), "org.eclipse.wst.jsdt.ui", 0, entries[i].getMessage(), null));
                        ++i;
                    }
                } else {
                    RefactoringStatusEntry entry = entries[0];
                    status = new Status(entry.getSeverity(), "org.eclipse.wst.jsdt.ui", 0, entry.getMessage(), null);
                }
                ErrorDialog.openError((Shell)JavaPlugin.getActiveWorkbenchShell().getShell(), (String)CorrectionMessages.CorrectionMarkerResolutionGenerator__multiFixErrorDialog_Titel, (String)CorrectionMessages.CorrectionMarkerResolutionGenerator_multiFixErrorDialog_description, (IStatus)status);
                return false;
            }
            return true;
        }

        private void findFilesToBeModified(CompositeChange change, List result) throws JavaModelException {
            Change[] children = change.getChildren();
            int i = 0;
            while (i < children.length) {
                Change child = children[i];
                if (child instanceof CompositeChange) {
                    this.findFilesToBeModified((CompositeChange)child, result);
                } else if (child instanceof MultiStateCompilationUnitChange) {
                    result.add(((MultiStateCompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
                } else if (child instanceof CompilationUnitChange) {
                    result.add(((CompilationUnitChange)child).getCompilationUnit().getCorrespondingResource());
                }
                ++i;
            }
        }

        private void cleanUpProject(IJavaProject project, ICompilationUnit[] compilationUnits, ICleanUp cleanUp, Hashtable problemLocations, CompositeChange result, IProgressMonitor monitor) throws CoreException {
            cleanUp.checkPreConditions(project, compilationUnits, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            int i = 0;
            while (i < compilationUnits.length) {
                ICompilationUnit cu = compilationUnits[i];
                CompilationUnit root = CorrectionMarkerResolution.getASTRoot(cu, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                List locationList = (List)problemLocations.get(cu);
                IProblemLocation[] locations = locationList.toArray(new IProblemLocation[locationList.size()]);
                IFix fix = cleanUp.createFix(root, locations);
                if (monitor.isCanceled()) {
                    return;
                }
                if (fix != null) {
                    TextChange change = fix.createChange();
                    if (monitor.isCanceled()) {
                        return;
                    }
                    result.add((Change)change);
                    monitor.worked(1);
                }
                ++i;
            }
            cleanUp.checkPostConditions(null);
        }

        public String getDescription() {
            return this.fProposal.getAdditionalProposalInfo();
        }

        public Image getImage() {
            return this.fProposal.getImage();
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            if (!(this.fProposal instanceof FixCorrectionProposal)) {
                return NO_MARKERS;
            }
            FixCorrectionProposal fix = (FixCorrectionProposal)this.fProposal;
            ICleanUp cleanUp = fix.getCleanUp();
            if (cleanUp == null) {
                return NO_MARKERS;
            }
            Hashtable fileMarkerTable = this.getMarkersForFiles(markers);
            if (fileMarkerTable.isEmpty()) {
                return NO_MARKERS;
            }
            Hashtable projectICUTable = this.getCompilationUnitsForProjects(fileMarkerTable);
            if (projectICUTable.size() == 0) {
                return NO_MARKERS;
            }
            ArrayList result = new ArrayList();
            Iterator iter = projectICUTable.keySet().iterator();
            while (iter.hasNext()) {
                IJavaProject project = (IJavaProject)iter.next();
                List cus = (List)projectICUTable.get(project);
                ASTParser parser = CorrectionMarkerResolution.getParser(project);
                int start = 0;
                int end = 0;
                while (end < cus.size()) {
                    end = Math.min(start + 40, cus.size());
                    List toParse = cus.subList(start, end);
                    ICompilationUnit[] units = toParse.toArray(new ICompilationUnit[toParse.size()]);
                    parser.createASTs(units, new String[0], new ASTRequestor(this, fileMarkerTable, cleanUp, result){
                        final /* synthetic */ CorrectionMarkerResolution this$1;
                        private final /* synthetic */ Hashtable val$fileMarkerTable;
                        private final /* synthetic */ ICleanUp val$cleanUp;
                        private final /* synthetic */ List val$result;
                        {
                            this.this$1 = correctionMarkerResolution;
                            this.val$fileMarkerTable = hashtable;
                            this.val$cleanUp = iCleanUp;
                            this.val$result = list;
                        }

                        public void acceptAST(ICompilationUnit cu, CompilationUnit root) {
                            try {
                                IEditorInput input = EditorUtility.getEditorInput(cu);
                                List fileMarkers = (List)this.val$fileMarkerTable.get(cu.getResource());
                                Iterator<E> iterator = fileMarkers.iterator();
                                while (iterator.hasNext()) {
                                    IMarker marker = (IMarker)iterator.next();
                                    IProblemLocation location = CorrectionMarkerResolutionGenerator.access$1(input, marker);
                                    if (location == null || !this.val$cleanUp.canFix(root, location)) continue;
                                    this.val$result.add(marker);
                                }
                            }
                            catch (CoreException e) {
                                JavaPlugin.log(e);
                            }
                        }
                    }, (IProgressMonitor)new NullProgressMonitor());
                    start = end;
                }
            }
            if (result.size() == 0) {
                return NO_MARKERS;
            }
            return result.toArray(new IMarker[result.size()]);
        }

        private Hashtable getMarkersForFiles(IMarker[] markers) {
            String markerType;
            Hashtable<IResource, ArrayList<IMarker>> result = new Hashtable<IResource, ArrayList<IMarker>>();
            try {
                markerType = this.fMarker.getType();
            }
            catch (CoreException e1) {
                JavaPlugin.log(e1);
                return result;
            }
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                if (!marker.equals((Object)this.fMarker)) {
                    IResource res;
                    String currMarkerType = null;
                    try {
                        currMarkerType = marker.getType();
                    }
                    catch (CoreException e1) {
                        JavaPlugin.log(e1);
                    }
                    if (currMarkerType != null && currMarkerType.equals(markerType) && (res = marker.getResource()) instanceof IFile && res.isAccessible()) {
                        ArrayList<IMarker> markerList = (ArrayList<IMarker>)result.get(res);
                        if (markerList == null) {
                            markerList = new ArrayList<IMarker>();
                            result.put(res, markerList);
                        }
                        markerList.add(marker);
                    }
                }
                ++i;
            }
            return result;
        }

        private Hashtable getCompilationUnitsForProjects(Hashtable fileMarkerTable) {
            Hashtable<IJavaProject, ArrayList<ICompilationUnit>> result = new Hashtable<IJavaProject, ArrayList<ICompilationUnit>>();
            Iterator iter = fileMarkerTable.keySet().iterator();
            while (iter.hasNext()) {
                IFile res = (IFile)iter.next();
                IJavaElement element = JavaCore.create((IFile)res);
                if (!(element instanceof ICompilationUnit)) continue;
                ICompilationUnit cu = (ICompilationUnit)element;
                ArrayList<ICompilationUnit> cus = (ArrayList<ICompilationUnit>)result.get(cu.getJavaProject());
                if (cus == null) {
                    cus = new ArrayList<ICompilationUnit>();
                    result.put(cu.getJavaProject(), cus);
                }
                cus.add(cu);
            }
            return result;
        }

        private static ASTParser getParser(IJavaProject javaProject) {
            ASTParser parser = ASTParser.newParser((int)3);
            parser.setResolveBindings(true);
            parser.setProject(javaProject);
            return parser;
        }

        private static CompilationUnit getASTRoot(ICompilationUnit compilationUnit, IProgressMonitor monitor) {
            CompilationUnit result = ASTProvider.getASTProvider().getAST((IJavaElement)compilationUnit, ASTProvider.WAIT_YES, monitor);
            if (result == null) {
                result = ASTResolving.createQuickFixAST(compilationUnit, monitor);
            }
            return result;
        }
    }
}

