/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.List;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.MethodDeclaration;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.ReturnStatement;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.ScopeAnalyzer;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedCorrectionProposal;

public class MissingReturnTypeCorrectionProposal
extends LinkedCorrectionProposal {
    private static final String RETURN_EXPRESSION_KEY = "value";
    private MethodDeclaration fMethodDecl;
    private ReturnStatement fExistingReturn;

    public MissingReturnTypeCorrectionProposal(ICompilationUnit cu, MethodDeclaration decl, ReturnStatement existingReturn, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, JavaPluginImages.get("org.eclipse.wst.jsdt.ui.correction_change.gif"));
        this.fMethodDecl = decl;
        this.fExistingReturn = existingReturn;
    }

    public String getDisplayString() {
        if (this.fExistingReturn != null) {
            return CorrectionMessages.MissingReturnTypeCorrectionProposal_changereturnstatement_description;
        }
        return CorrectionMessages.MissingReturnTypeCorrectionProposal_addreturnstatement_description;
    }

    protected ASTRewrite getRewrite() {
        Expression expression;
        ITypeBinding binding;
        AST ast = this.fMethodDecl.getAST();
        ITypeBinding returnBinding = this.getReturnTypeBinding();
        if (this.fExistingReturn != null) {
            ASTRewrite rewrite = ASTRewrite.create((AST)ast);
            Expression expression2 = this.evaluateReturnExpressions(ast, returnBinding, this.fExistingReturn.getStartPosition());
            if (expression2 != null) {
                rewrite.set((ASTNode)this.fExistingReturn, (StructuralPropertyDescriptor)ReturnStatement.EXPRESSION_PROPERTY, (Object)expression2, null);
                this.addLinkedPosition(rewrite.track((ASTNode)expression2), true, RETURN_EXPRESSION_KEY);
            }
            return rewrite;
        }
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Block block = this.fMethodDecl.getBody();
        List statements = block.statements();
        int nStatements = statements.size();
        ASTNode lastStatement = null;
        if (nStatements > 0) {
            lastStatement = (ASTNode)statements.get(nStatements - 1);
        }
        if (returnBinding != null && lastStatement instanceof ExpressionStatement && lastStatement.getNodeType() != 7 && (binding = (expression = ((ExpressionStatement)lastStatement).getExpression()).resolveTypeBinding()) != null && binding.isAssignmentCompatible(returnBinding)) {
            Expression placeHolder = (Expression)rewrite.createMoveTarget((ASTNode)expression);
            ReturnStatement returnStatement = ast.newReturnStatement();
            returnStatement.setExpression(placeHolder);
            rewrite.replace(lastStatement, (ASTNode)returnStatement, null);
            return rewrite;
        }
        int offset = lastStatement == null ? block.getStartPosition() + 1 : lastStatement.getStartPosition() + lastStatement.getLength();
        ReturnStatement returnStatement = ast.newReturnStatement();
        Expression expression3 = this.evaluateReturnExpressions(ast, returnBinding, offset);
        returnStatement.setExpression(expression3);
        rewrite.getListRewrite((ASTNode)block, Block.STATEMENTS_PROPERTY).insertLast((ASTNode)returnStatement, null);
        this.addLinkedPosition(rewrite.track((ASTNode)returnStatement.getExpression()), true, RETURN_EXPRESSION_KEY);
        return rewrite;
    }

    private ITypeBinding getReturnTypeBinding() {
        IMethodBinding methodBinding = this.fMethodDecl.resolveBinding();
        if (methodBinding != null && methodBinding.getReturnType() != null) {
            return methodBinding.getReturnType();
        }
        return null;
    }

    private Expression evaluateReturnExpressions(AST ast, ITypeBinding returnBinding, int returnOffset) {
        CompilationUnit root = (CompilationUnit)this.fMethodDecl.getRoot();
        SimpleName result = null;
        if (returnBinding != null) {
            ScopeAnalyzer analyzer = new ScopeAnalyzer(root);
            IBinding[] bindings = analyzer.getDeclarationsInScope(returnOffset, 18);
            int i = 0;
            while (i < bindings.length) {
                IVariableBinding curr = (IVariableBinding)bindings[i];
                ITypeBinding type = curr.getType();
                if (type != null && type.isAssignmentCompatible(returnBinding) && this.testModifier(curr)) {
                    if (result == null) {
                        result = ast.newSimpleName(curr.getName());
                    }
                    this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, curr.getName(), null);
                }
                ++i;
            }
        }
        Expression defaultExpression = ASTNodeFactory.newDefaultExpression(ast, this.fMethodDecl.getReturnType2(), this.fMethodDecl.getExtraDimensions());
        this.addLinkedPositionProposal(RETURN_EXPRESSION_KEY, ASTNodes.asString((ASTNode)defaultExpression), null);
        if (result == null) {
            return defaultExpression;
        }
        return result;
    }

    private boolean testModifier(IVariableBinding curr) {
        int staticFinal;
        int modifiers = curr.getModifiers();
        if ((modifiers & (staticFinal = 24)) == staticFinal) {
            return false;
        }
        return !Modifier.isStatic((int)modifiers) || Modifier.isStatic((int)this.fMethodDecl.getModifiers());
    }
}

