/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.ParameterizedType;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.fix.AbstractSerialVersionOperation;
import org.eclipse.wst.jsdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.launching.IRuntimeClasspathEntry;
import org.eclipse.wst.jsdt.launching.JavaRuntime;

public final class SerialVersionHashOperation
extends AbstractSerialVersionOperation {
    private final ICompilationUnit fCompilationUnit;

    public static String[] computeUserAndBootClasspath(IJavaProject project) throws CoreException {
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)project);
        ArrayList<String> resolved = new ArrayList<String>(unresolved.length);
        int index = 0;
        while (index < unresolved.length) {
            IRuntimeClasspathEntry entry = unresolved[index];
            int property = entry.getClasspathProperty();
            if (property == 3 || property == 2) {
                IRuntimeClasspathEntry[] entries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)entry, (IJavaProject)project);
                int offset = 0;
                while (offset < entries.length) {
                    String location = entries[offset].getLocation();
                    if (location != null) {
                        resolved.add(location);
                    }
                    ++offset;
                }
            }
            ++index;
        }
        return resolved.toArray(new String[resolved.size()]);
    }

    public static long[] calculateSerialVersionIds(String[] qualifiedNames, IJavaProject project, IProgressMonitor monitor) throws CoreException, IOException {
        return null;
    }

    private static void displayErrorMessage(final String message) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        MessageDialog.openError((Shell)shell, (String)CorrectionMessages.SerialVersionHashProposal_dialog_error_caption, (String)Messages.format(CorrectionMessages.SerialVersionHashProposal_dialog_error_message, message));
                    }
                }
            });
        }
    }

    private static void displayErrorMessage(Throwable throwable) {
        SerialVersionHashOperation.displayErrorMessage(throwable.getLocalizedMessage());
    }

    private static boolean displayYesNoMessage(final String title, final String message) {
        final boolean[] result = new boolean[]{true};
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.syncExec(new Runnable(){

                public final void run() {
                    Shell shell;
                    if (!display.isDisposed() && (shell = display.getActiveShell()) != null && !shell.isDisposed()) {
                        result[0] = MessageDialog.openQuestion((Shell)shell, (String)title, (String)message);
                    }
                }
            });
        }
        return result[0];
    }

    public SerialVersionHashOperation(ICompilationUnit unit, ASTNode[] nodes) {
        super(unit, nodes);
        this.fCompilationUnit = unit;
    }

    protected boolean addInitializer(final VariableDeclarationFragment fragment, final ASTNode declarationNode) throws CoreException {
        Assert.isNotNull((Object)fragment);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public final void run(IProgressMonitor monitor) throws InterruptedException {
                    Assert.isNotNull((Object)monitor);
                    String id = SerialVersionHashOperation.this.computeId(declarationNode, monitor);
                    fragment.setInitializer((Expression)fragment.getAST().newNumberLiteral(id));
                }
            });
        }
        catch (InvocationTargetException exception) {
            JavaPlugin.log(exception);
        }
        catch (InterruptedException interruptedException) {}
        return true;
    }

    protected void addLinkedPositions(ASTRewrite rewrite, VariableDeclarationFragment fragment, LinkedProposalModel positionGroups) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String computeId(ASTNode declarationNode, IProgressMonitor monitor) throws InterruptedException {
        Assert.isNotNull((Object)monitor);
        long serialVersionID = 1L;
        try {
            try {
                monitor.beginTask(CorrectionMessages.SerialVersionHashProposal_computing_id, 200);
                IJavaProject project = this.fCompilationUnit.getJavaProject();
                IPath path = this.fCompilationUnit.getResource().getFullPath();
                try {
                    FileBuffers.getTextFileBufferManager().connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                    ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(path, LocationKind.IFILE);
                    if (buffer.isDirty() && buffer.isStateValidated() && buffer.isCommitable() && SerialVersionHashOperation.displayYesNoMessage(CorrectionMessages.SerialVersionHashProposal_save_caption, CorrectionMessages.SerialVersionHashProposal_save_message)) {
                        buffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 20), true);
                    } else {
                        monitor.worked(20);
                    }
                    if (monitor.isCanceled()) {
                        throw new InterruptedException();
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                    throw throwable;
                }
                {
                    Object var8_11 = null;
                }
                FileBuffers.getTextFileBufferManager().disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                project.getProject().build(10, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
                if (monitor.isCanceled()) {
                    throw new InterruptedException();
                }
                long[] ids = SerialVersionHashOperation.calculateSerialVersionIds(new String[]{this.getQualifiedName(declarationNode)}, project, (IProgressMonitor)new SubProgressMonitor(monitor, 100));
                if (ids.length == 1) {
                    serialVersionID = ids[0];
                }
            }
            catch (CoreException exception) {
                SerialVersionHashOperation.displayErrorMessage(exception);
            }
            catch (IOException exception) {
                SerialVersionHashOperation.displayErrorMessage(exception);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var10_14 = null;
        }
        monitor.done();
        return String.valueOf(serialVersionID) + "L";
    }

    private String getQualifiedName(ASTNode parent) {
        ITypeBinding binding = null;
        if (parent instanceof AbstractTypeDeclaration) {
            AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)parent;
            binding = declaration.resolveBinding();
        } else if (parent instanceof AnonymousClassDeclaration) {
            AnonymousClassDeclaration declaration = (AnonymousClassDeclaration)parent;
            ClassInstanceCreation creation = (ClassInstanceCreation)declaration.getParent();
            binding = creation.resolveTypeBinding();
        } else if (parent instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)parent;
            binding = type.resolveBinding();
        }
        if (binding != null) {
            return binding.getBinaryName();
        }
        return null;
    }
}

