/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.text.java.LazyJavaCompletionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalContextInformation;
import org.eclipse.wst.jsdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.wst.jsdt.internal.ui.text.java.TypeProposalInfo;
import org.eclipse.wst.jsdt.ui.text.java.JavaContentAssistInvocationContext;

public class LazyJavaTypeCompletionProposal
extends LazyJavaCompletionProposal {
    protected static final char[] TYPE_TRIGGERS = new char[]{'.', '\t', '[', '(', ' '};
    protected static final char[] JDOC_TYPE_TRIGGERS = new char[]{'#', '}', ' ', '.'};
    protected final ICompilationUnit fCompilationUnit;
    private String fQualifiedName;
    private String fSimpleName;
    private ImportRewrite fImportRewrite;

    public LazyJavaTypeCompletionProposal(CompletionProposal proposal, JavaContentAssistInvocationContext context) {
        super(proposal, context);
        this.fCompilationUnit = context.getCompilationUnit();
        this.fQualifiedName = null;
    }

    public final String getQualifiedTypeName() {
        if (this.fQualifiedName == null) {
            this.fQualifiedName = String.valueOf(Signature.toCharArray((char[])Signature.getTypeErasure((char[])this.fProposal.getSignature())));
        }
        return this.fQualifiedName;
    }

    protected final String getSimpleTypeName() {
        if (this.fSimpleName == null) {
            this.fSimpleName = Signature.getSimpleName((String)this.getQualifiedTypeName());
        }
        return this.fSimpleName;
    }

    protected String computeReplacementString() {
        String replacement = super.computeReplacementString();
        return replacement;
    }

    protected final boolean isImportCompletion() {
        char[] completion = this.fProposal.getCompletion();
        if (completion.length == 0) {
            return false;
        }
        char last = completion[completion.length - 1];
        return last == ';' || last == '.';
    }

    public void apply(IDocument document, char trigger, int offset) {
        try {
            boolean insertClosingParenthesis;
            boolean bl = insertClosingParenthesis = trigger == '(' && this.autocloseBrackets();
            if (insertClosingParenthesis) {
                StringBuffer replacement = new StringBuffer(this.getReplacementString());
                this.updateReplacementWithParentheses(replacement);
                this.setReplacementString(replacement.toString());
                trigger = '\u0000';
            }
            super.apply(document, trigger, offset);
            if (this.fImportRewrite != null && this.fImportRewrite.hasRecordedChanges()) {
                int oldLen = document.getLength();
                this.fImportRewrite.rewriteImports((IProgressMonitor)new NullProgressMonitor()).apply(document, 2);
                this.setReplacementOffset(this.getReplacementOffset() + document.getLength() - oldLen);
            }
            if (insertClosingParenthesis) {
                this.setUpLinkedMode(document, ')');
            }
            this.rememberSelection();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    protected void updateReplacementWithParentheses(StringBuffer replacement) {
        LazyJavaCompletionProposal.FormatterPrefs prefs = this.getFormatterPrefs();
        if (prefs.beforeOpeningParen) {
            replacement.append(" ");
        }
        replacement.append("(");
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        this.setCursorPosition(replacement.length());
        if (prefs.afterOpeningParen) {
            replacement.append(" ");
        }
        replacement.append(")");
    }

    protected final void rememberSelection() throws JavaModelException {
        IType lhs = this.fInvocationContext.getExpectedType();
        IType rhs = (IType)this.getJavaElement();
        if (lhs != null && rhs != null) {
            JavaPlugin.getDefault().getContentAssistHistory().remember(lhs, rhs);
        }
        QualifiedTypeNameHistory.remember(this.getQualifiedTypeName());
    }

    protected boolean allowAddingImports() {
        if (this.isInJavadoc()) {
            if (this.fProposal.getKind() == 9 && this.fInvocationContext.getCoreContext().isInJavadocText()) {
                return false;
            }
            if (!this.isJavadocProcessingEnabled()) {
                return false;
            }
        }
        IPreferenceStore preferenceStore = JavaPlugin.getDefault().getPreferenceStore();
        return preferenceStore.getBoolean("content_assist_add_import");
    }

    private boolean isJavadocProcessingEnabled() {
        IJavaProject project = this.fCompilationUnit.getJavaProject();
        boolean processJavadoc = project == null ? "enabled".equals(JavaCore.getOption((String)"org.eclipse.wst.jsdt.core.compiler.doc.comment.support")) : "enabled".equals(project.getOption("org.eclipse.wst.jsdt.core.compiler.doc.comment.support", true));
        return processJavadoc;
    }

    protected boolean isValidPrefix(String prefix) {
        return this.isPrefix(prefix, this.getSimpleTypeName()) || this.isPrefix(prefix, this.getQualifiedTypeName());
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String prefix = this.getPrefix(document, completionOffset);
        String completion = prefix.indexOf(46) != -1 ? this.getQualifiedTypeName() : this.getSimpleTypeName();
        if (this.isCamelCaseMatching()) {
            return this.getCamelCaseCompound(prefix, completion);
        }
        return completion;
    }

    protected char[] computeTriggerCharacters() {
        return this.isInJavadoc() ? JDOC_TYPE_TRIGGERS : TYPE_TRIGGERS;
    }

    protected ProposalInfo computeProposalInfo() {
        IJavaProject project;
        if (this.fCompilationUnit != null && (project = this.fCompilationUnit.getJavaProject()) != null) {
            return new TypeProposalInfo(project, this.fProposal);
        }
        return super.computeProposalInfo();
    }

    protected String computeSortString() {
        return String.valueOf(this.getSimpleTypeName()) + '\u0000' + this.getQualifiedTypeName();
    }

    protected int computeRelevance() {
        float rhsHistoryRank = this.fInvocationContext.getHistoryRelevance(this.getQualifiedTypeName());
        float typeHistoryRank = QualifiedTypeNameHistory.getDefault().getNormalizedPosition(this.getQualifiedTypeName());
        int recencyBoost = Math.round((rhsHistoryRank + typeHistoryRank) * 5.0f);
        int rhsBoost = rhsHistoryRank > 0.0f ? 50 : 0;
        int baseRelevance = super.computeRelevance();
        return baseRelevance + rhsBoost + recencyBoost;
    }

    protected IContextInformation computeContextInformation() {
        char[] signature = this.fProposal.getSignature();
        char[][] typeParameters = Signature.getTypeArguments((char[])signature);
        if (typeParameters.length == 0) {
            return super.computeContextInformation();
        }
        ProposalContextInformation contextInformation = new ProposalContextInformation(this.fProposal);
        if (this.fContextInformationPosition != 0 && this.fProposal.getCompletion().length == 0) {
            contextInformation.setContextInformationPosition(this.fContextInformationPosition);
        }
        return contextInformation;
    }
}

