/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.spelling;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.spelling.ISpellingEngine;
import org.eclipse.ui.texteditor.spelling.ISpellingProblemCollector;
import org.eclipse.ui.texteditor.spelling.SpellingContext;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.JavaSpellingEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.PropertiesFileSpellingEngine;
import org.eclipse.wst.jsdt.internal.ui.text.spelling.TextSpellingEngine;

public class DefaultSpellingEngine
implements ISpellingEngine {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private static final IContentType JAVA_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.jsSource");
    private static final IContentType PROPERTIES_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.wst.jsdt.core.javaProperties");
    private Map fEngines = new HashMap();

    public DefaultSpellingEngine() {
        if (JAVA_CONTENT_TYPE != null) {
            this.fEngines.put(JAVA_CONTENT_TYPE, new JavaSpellingEngine());
        }
        if (PROPERTIES_CONTENT_TYPE != null) {
            this.fEngines.put(PROPERTIES_CONTENT_TYPE, new PropertiesFileSpellingEngine());
        }
        if (TEXT_CONTENT_TYPE != null) {
            this.fEngines.put(TEXT_CONTENT_TYPE, new TextSpellingEngine());
        }
    }

    public void check(IDocument document, IRegion[] regions, SpellingContext context, ISpellingProblemCollector collector, IProgressMonitor monitor) {
        ISpellingEngine engine = this.getEngine(context.getContentType());
        if (engine == null) {
            engine = this.getEngine(TEXT_CONTENT_TYPE);
        }
        if (engine != null) {
            engine.check(document, regions, context, collector, monitor);
        }
    }

    private ISpellingEngine getEngine(IContentType contentType) {
        if (contentType == null) {
            return null;
        }
        if (this.fEngines.containsKey(contentType)) {
            return (ISpellingEngine)this.fEngines.get(contentType);
        }
        return this.getEngine(contentType.getBaseType());
    }
}

