/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.TypeHierarchyLifeCycle;
import org.eclipse.wst.jsdt.ui.IWorkingCopyProvider;

public class MethodsContentProvider
implements IStructuredContentProvider,
IWorkingCopyProvider {
    private static final Object[] NO_ELEMENTS = new Object[0];
    private boolean fShowInheritedMethods;
    private TypeHierarchyLifeCycle fHierarchyLifeCycle;
    private TableViewer fViewer;

    public MethodsContentProvider(TypeHierarchyLifeCycle lifecycle) {
        this.fHierarchyLifeCycle = lifecycle;
        this.fShowInheritedMethods = false;
        this.fViewer = null;
    }

    public void showInheritedMethods(boolean show) {
        if (show != this.fShowInheritedMethods) {
            this.fShowInheritedMethods = show;
            if (this.fViewer != null) {
                this.fViewer.refresh();
            }
        }
    }

    public boolean providesWorkingCopies() {
        return true;
    }

    public boolean isShowInheritedMethods() {
        return this.fShowInheritedMethods;
    }

    private void addAll(Object[] arr, List res) {
        if (arr != null) {
            int j = 0;
            while (j < arr.length) {
                res.add(arr[j]);
                ++j;
            }
        }
    }

    public Object[] getElements(Object element) {
        if (element instanceof IType) {
            IType type = (IType)element;
            ArrayList res = new ArrayList();
            try {
                ITypeHierarchy hierarchy = this.fHierarchyLifeCycle.getHierarchy();
                if (this.fShowInheritedMethods && hierarchy != null) {
                    IType[] allSupertypes = hierarchy.getAllSupertypes(type);
                    int i = allSupertypes.length - 1;
                    while (i >= 0) {
                        IType superType = allSupertypes[i];
                        if (superType.exists()) {
                            this.addAll(superType.getMethods(), res);
                            this.addAll(superType.getInitializers(), res);
                            this.addAll(superType.getFields(), res);
                        }
                        --i;
                    }
                }
                if (type.exists()) {
                    this.addAll(type.getMethods(), res);
                    this.addAll(type.getInitializers(), res);
                    this.addAll(type.getFields(), res);
                }
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            return res.toArray();
        }
        return NO_ELEMENTS;
    }

    public void inputChanged(Viewer input, Object oldInput, Object newInput) {
        Assert.isTrue((boolean)(input instanceof TableViewer));
        this.fViewer = (TableViewer)input;
    }

    public void dispose() {
    }
}

