/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.search.IJavaSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.SearchUtils;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;

public class MainMethodSearchEngine {
    public IType[] searchMainMethods(IProgressMonitor pm, IJavaSearchScope scope, int style) throws CoreException {
        ArrayList typesFound = new ArrayList(200);
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        MethodCollector requestor = new MethodCollector(typesFound, style);
        new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), scope, (SearchRequestor)requestor, pm);
        return typesFound.toArray(new IType[typesFound.size()]);
    }

    public IType[] searchMainMethods(IRunnableContext context, final IJavaSearchScope scope, final int style) throws InvocationTargetException, InterruptedException {
        int allFlags = 24;
        Assert.isTrue(((style | allFlags) == allFlags ? 1 : 0) != 0);
        final IType[][] res = new IType[1][];
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    res[0] = MainMethodSearchEngine.this.searchMainMethods(pm, scope, style);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        context.run(true, true, runnable);
        return res[0];
    }

    private static class MethodCollector
    extends SearchRequestor {
        private List fResult;
        private int fStyle;

        public MethodCollector(List result, int style) {
            Assert.isNotNull((Object)result);
            this.fResult = result;
            this.fStyle = style;
        }

        private boolean considerExternalJars() {
            return (this.fStyle & 0x10) != 0;
        }

        private boolean considerBinaries() {
            return (this.fStyle & 8) != 0;
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            Object enclosingElement = match.getElement();
            if (enclosingElement instanceof IMethod) {
                try {
                    IMethod curr = (IMethod)enclosingElement;
                    if (curr.isMainMethod()) {
                        IPackageFragmentRoot root;
                        if (!this.considerExternalJars() && ((root = JavaModelUtil.getPackageFragmentRoot((IJavaElement)curr)) == null || root.isArchive())) {
                            return;
                        }
                        if (!this.considerBinaries() && curr.isBinary()) {
                            return;
                        }
                        this.fResult.add(curr.getDeclaringType());
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e.getStatus());
                }
            }
        }
    }
}

