/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.ImageDisposer;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathOrderingWorkbookPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.LibrariesWorkbookPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ProjectsWorkbookPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.SourceContainerWorkbookPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.NewSourceContainerWorkbookPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;

public class BuildPathsBlock {
    private CheckedListDialogField fClassPathList;
    private StatusInfo fClassPathStatus;
    private StatusInfo fOutputFolderStatus;
    private StatusInfo fBuildPathStatus;
    private IJavaProject fCurrJProject;
    private IStatusChangeListener fContext;
    private Control fSWTWidget;
    private TabFolder fTabFolder;
    private int fPageIndex;
    private BuildPathBasePage fSourceContainerPage;
    private ProjectsWorkbookPage fProjectsPage;
    private LibrariesWorkbookPage fLibrariesPage;
    private BuildPathBasePage fCurrPage;
    private String fUserSettingsTimeStamp;
    private long fFileTimeStamp;
    private IRunnableContext fRunnableContext;
    private boolean fUseNewPage;
    private ClasspathOrderingWorkbookPage ordpage;
    private final IWorkbenchPreferenceContainer fPageContainer;
    private static final int IDX_UP = 0;
    private static final int IDX_DOWN = 1;
    private static final int IDX_TOP = 3;
    private static final int IDX_BOTTOM = 4;
    private static final int IDX_SELECT_ALL = 6;
    private static final int IDX_UNSELECT_ALL = 7;

    public BuildPathsBlock(IRunnableContext runnableContext, IStatusChangeListener context, int pageToShow, boolean useNewPage, IWorkbenchPreferenceContainer pageContainer) {
        this.fPageContainer = pageContainer;
        this.fContext = context;
        this.fUseNewPage = useNewPage;
        this.fPageIndex = pageToShow;
        this.fSourceContainerPage = null;
        this.fLibrariesPage = null;
        this.fProjectsPage = null;
        this.fCurrPage = null;
        this.fRunnableContext = runnableContext;
        BuildPathAdapter adapter = new BuildPathAdapter();
        String[] stringArray = new String[8];
        stringArray[0] = NewWizardMessages.BuildPathsBlock_classpath_up_button;
        stringArray[1] = NewWizardMessages.BuildPathsBlock_classpath_down_button;
        stringArray[3] = NewWizardMessages.BuildPathsBlock_classpath_top_button;
        stringArray[4] = NewWizardMessages.BuildPathsBlock_classpath_bottom_button;
        stringArray[6] = NewWizardMessages.BuildPathsBlock_classpath_checkall_button;
        stringArray[7] = NewWizardMessages.BuildPathsBlock_classpath_uncheckall_button;
        String[] buttonLabels = stringArray;
        this.fClassPathList = new CheckedListDialogField(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fClassPathList.setDialogFieldListener(adapter);
        this.fClassPathList.setLabelText(NewWizardMessages.BuildPathsBlock_classpath_label);
        this.fClassPathList.setUpButtonIndex(0);
        this.fClassPathList.setDownButtonIndex(1);
        this.fClassPathList.setCheckAllButtonIndex(6);
        this.fClassPathList.setUncheckAllButtonIndex(7);
        this.fBuildPathStatus = new StatusInfo();
        this.fClassPathStatus = new StatusInfo();
        this.fOutputFolderStatus = new StatusInfo();
        this.fCurrJProject = null;
    }

    public Control createControl(Composite parent) {
        this.fSWTWidget = parent;
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        TabFolder folder = new TabFolder(composite, 0);
        folder.setLayoutData((Object)new GridData(1808));
        folder.setFont(composite.getFont());
        TabItem item = new TabItem(folder, 0);
        this.fLibrariesPage = new LibrariesWorkbookPage(this.fClassPathList, this.fPageContainer);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_scriptimport);
        item.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.library_obj.gif"));
        item.setData((Object)this.fLibrariesPage);
        item.setControl(this.fLibrariesPage.getControl((Composite)folder));
        Image cpoImage = JavaPluginImages.DESC_TOOL_CLASSPATH_ORDER.createImage();
        composite.addDisposeListener((DisposeListener)new ImageDisposer(cpoImage));
        this.ordpage = new ClasspathOrderingWorkbookPage(this.fClassPathList);
        this.ordpage.getSuperField().setValue(BuildPathsBlock.getProjectSuperType(this.fCurrJProject));
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_GlobalOrder);
        item.setImage(cpoImage);
        item.setData((Object)this.ordpage);
        item.setControl(this.ordpage.getControl((Composite)folder));
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_source);
        item.setImage(JavaPluginImages.get("org.eclipse.wst.jsdt.ui.packagefolder_obj.gif"));
        this.fSourceContainerPage = this.fUseNewPage ? new NewSourceContainerWorkbookPage(this.fClassPathList, null, this.fRunnableContext, this) : new SourceContainerWorkbookPage(this.fClassPathList);
        item.setData((Object)this.fSourceContainerPage);
        item.setControl(this.fSourceContainerPage.getControl((Composite)folder));
        IWorkbench workbench = JavaPlugin.getDefault().getWorkbench();
        Image projectImage = workbench.getSharedImages().getImage("IMG_OBJ_PROJECT");
        this.fProjectsPage = new ProjectsWorkbookPage(this.fClassPathList, this.fPageContainer);
        item = new TabItem(folder, 0);
        item.setText(NewWizardMessages.BuildPathsBlock_tab_projects);
        item.setImage(projectImage);
        item.setData((Object)this.fProjectsPage);
        item.setControl(this.fProjectsPage.getControl((Composite)folder));
        if (this.fCurrJProject != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
            this.ordpage.init(this.fCurrJProject);
        }
        folder.setSelection(this.fPageIndex);
        this.fCurrPage = (BuildPathBasePage)folder.getItem(this.fPageIndex).getData();
        folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BuildPathsBlock.this.tabChanged(e.item);
            }
        });
        this.fTabFolder = folder;
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IJavaProject jproject, IClasspathEntry[] classpathEntries) {
        this.fCurrJProject = jproject;
        boolean projectExists = false;
        List newClassPath = null;
        IProject project = this.fCurrJProject.getProject();
        boolean bl = projectExists = project.exists() && jproject.getJSDTScopeFile().exists();
        if (projectExists && classpathEntries == null) {
            classpathEntries = this.fCurrJProject.readRawClasspath();
        }
        if (classpathEntries != null) {
            newClassPath = this.getExistingEntries(classpathEntries);
        }
        if (newClassPath == null) {
            newClassPath = this.getDefaultClassPath(jproject);
        }
        ArrayList<CPListElement> exportedEntries = new ArrayList<CPListElement>();
        int i = 0;
        while (i < newClassPath.size()) {
            CPListElement curr = (CPListElement)newClassPath.get(i);
            if (curr.isExported() || curr.getEntryKind() == 3) {
                exportedEntries.add(curr);
            }
            ++i;
        }
        this.fClassPathList.setElements(newClassPath);
        this.fClassPathList.setCheckedElements(exportedEntries);
        this.fClassPathList.selectFirstElement();
        if (this.fSourceContainerPage != null) {
            this.fSourceContainerPage.init(this.fCurrJProject);
            this.fProjectsPage.init(this.fCurrJProject);
            this.fLibrariesPage.init(this.fCurrJProject);
        }
        this.initializeTimeStamps();
        this.updateUI();
    }

    protected void updateUI() {
        if (this.fSWTWidget == null || this.fSWTWidget.isDisposed()) {
            return;
        }
        if (Display.getCurrent() != null) {
            this.doUpdateUI();
        } else {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (BuildPathsBlock.this.fSWTWidget == null || BuildPathsBlock.this.fSWTWidget.isDisposed()) {
                        return;
                    }
                    BuildPathsBlock.this.doUpdateUI();
                }
            });
        }
    }

    protected void doUpdateUI() {
        this.fClassPathList.refresh();
        this.doStatusLineUpdate();
    }

    private String getEncodedSettings() {
        StringBuffer buf = new StringBuffer();
        int nElements = this.fClassPathList.getSize();
        buf.append('[').append(nElements).append(']');
        int i = 0;
        while (i < nElements) {
            CPListElement elem = (CPListElement)this.fClassPathList.getElement(i);
            elem.appendEncodedSettings(buf);
            ++i;
        }
        return buf.toString();
    }

    public boolean hasChangesInSuper() {
        LibrarySuperType savedSuperType = BuildPathsBlock.getProjectSuperType(this.fCurrJProject);
        Object o = this.ordpage.getSuperField().getValue();
        return o != null && !o.equals(savedSuperType);
    }

    public boolean hasChangesInDialog() {
        String currSettings = this.getEncodedSettings();
        return !currSettings.equals(this.fUserSettingsTimeStamp);
    }

    public void aboutToDispose() {
        if (this.fCurrPage != null) {
            this.fCurrPage.aboutToDispose();
        }
    }

    public void aboutToShow() {
        if (this.fCurrPage != null) {
            this.fCurrPage.aboutToShow();
        }
    }

    public boolean hasChangesInClasspathFile() {
        IFile file = this.fCurrJProject.getJSDTScopeFile();
        return this.fFileTimeStamp != file.getModificationStamp();
    }

    public boolean isClassfileMissing() {
        return !this.fCurrJProject.getJSDTScopeFile().exists();
    }

    public void initializeTimeStamps() {
        IFile file = this.fCurrJProject.getJSDTScopeFile();
        this.fFileTimeStamp = file.getModificationStamp();
        this.fUserSettingsTimeStamp = this.getEncodedSettings();
    }

    private ArrayList getExistingEntries(IClasspathEntry[] classpathEntries) {
        ArrayList<CPListElement> newClassPath = new ArrayList<CPListElement>();
        int i = 0;
        while (i < classpathEntries.length) {
            IClasspathEntry curr = classpathEntries[i];
            newClassPath.add(CPListElement.createFromExisting(curr, this.fCurrJProject));
            ++i;
        }
        return newClassPath;
    }

    public IJavaProject getJavaProject() {
        return this.fCurrJProject;
    }

    public IPath getOutputLocation() {
        return new Path("");
    }

    public IClasspathEntry[] getRawClassPath() {
        List elements = this.fClassPathList.getElements();
        int nElements = elements.size();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = 0;
        while (i < nElements) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            ++i;
        }
        return entries;
    }

    public int getPageIndex() {
        return this.fPageIndex;
    }

    private List getDefaultClassPath(IJavaProject jproj) {
        ArrayList<CPListElement> list = new ArrayList<CPListElement>();
        IPreferenceStore store = PreferenceConstants.getPreferenceStore();
        String sourceFolderName = store.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName");
        Object srcFolder = store.getBoolean("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersInNewProjects") && sourceFolderName.length() > 0 ? jproj.getProject().getFolder(sourceFolderName) : jproj.getProject();
        list.add(new CPListElement(jproj, 3, srcFolder.getFullPath(), (IResource)srcFolder));
        IClasspathEntry[] jreEntries = PreferenceConstants.getDefaultJRELibrary();
        list.addAll(this.getExistingEntries(jreEntries));
        return list;
    }

    public static LibrarySuperType getProjectSuperType(IJavaProject jproj) {
        if (jproj == null) {
            return BuildPathsBlock.getDefaultSuperType(jproj);
        }
        JavaProject javaProject = (JavaProject)jproj;
        LibrarySuperType projectSuperType = null;
        projectSuperType = javaProject.getCommonSuperType();
        if (projectSuperType == null) {
            LibrarySuperType defaultSt = BuildPathsBlock.getDefaultSuperType(jproj);
            BuildPathsBlock.setProjectSuperType(jproj, defaultSt);
            return defaultSt;
        }
        return projectSuperType;
    }

    public static LibrarySuperType getDefaultSuperType(IJavaProject jproj) {
        Path JREPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
        String superTypeName = "Global";
        return new LibrarySuperType((IPath)JREPath, jproj, superTypeName);
    }

    public static void setProjectSuperType(IJavaProject jproj, LibrarySuperType superType) {
        JavaProject javaProject = (JavaProject)jproj;
        javaProject.setCommonSuperType(superType);
    }

    public void disableButtons() {
        this.fClassPathList.enableButton(4, false);
        this.fClassPathList.enableButton(3, false);
        this.fClassPathList.enableButton(0, false);
        this.fClassPathList.enableButton(1, false);
    }

    public void enableButtons() {
        this.fClassPathList.enableButton(4, this.fClassPathList.canMoveDown());
        this.fClassPathList.enableButton(3, this.fClassPathList.canMoveUp());
        this.fClassPathList.enableButton(0, true);
        this.fClassPathList.enableButton(1, true);
    }

    private void buildPathChangeControlPressed(DialogField field) {
    }

    public void updateTopButtonEnablement() {
        this.fClassPathList.enableButton(4, this.fClassPathList.canMoveDown());
        this.fClassPathList.enableButton(3, this.fClassPathList.canMoveUp());
    }

    public void buildPathCustomButtonPressed(ListDialogField field, int index) {
        List elems = field.getSelectedElements();
        field.removeElements(elems);
        if (index == 4) {
            field.addElements(elems);
        } else if (index == 3) {
            field.addElements(elems, 0);
        }
    }

    private void buildPathDialogFieldChanged(DialogField field) {
        if (field == this.fClassPathList) {
            this.updateClassPathStatus();
            this.updateTopButtonEnablement();
        }
        this.doStatusLineUpdate();
    }

    private void doStatusLineUpdate() {
        if (Display.getCurrent() != null) {
            IStatus res = this.findMostSevereStatus();
            this.fContext.statusChanged(res);
        }
    }

    private IStatus findMostSevereStatus() {
        return StatusUtil.getMostSevere(new IStatus[]{this.fClassPathStatus, this.fOutputFolderStatus, this.fBuildPathStatus});
    }

    public void updateClassPathStatus() {
        this.fClassPathStatus.setOK();
        List elements = this.fClassPathList.getElements();
        CPListElement entryMissing = null;
        CPListElement entryDeprecated = null;
        int nEntriesMissing = 0;
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            boolean isChecked = this.fClassPathList.isChecked(currElement);
            if (currElement.getEntryKind() == 3) {
                if (!isChecked) {
                    this.fClassPathList.setCheckedWithoutUpdate(currElement, true);
                }
                if (!this.fClassPathList.isGrayed(currElement)) {
                    this.fClassPathList.setGrayedWithoutUpdate(currElement, true);
                }
            } else {
                currElement.setExported(isChecked);
            }
            entries[i] = currElement.getClasspathEntry();
            if (currElement.isMissing()) {
                ++nEntriesMissing;
                if (entryMissing == null) {
                    entryMissing = currElement;
                }
            }
            if (entryDeprecated == null & currElement.isDeprecated()) {
                entryDeprecated = currElement;
            }
            --i;
        }
        if (nEntriesMissing > 0) {
            if (nEntriesMissing == 1) {
                this.fClassPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntryMissing, entryMissing.getPath().toString()));
            } else {
                this.fClassPathStatus.setWarning(Messages.format(NewWizardMessages.BuildPathsBlock_warning_EntriesMissing, String.valueOf(nEntriesMissing)));
            }
        } else if (entryDeprecated != null) {
            this.fClassPathStatus.setInfo(entryDeprecated.getDeprecationMessage());
        }
        this.updateBuildPathStatus();
    }

    private void updateBuildPathStatus() {
        List elements = this.fClassPathList.getElements();
        IClasspathEntry[] entries = new IClasspathEntry[elements.size()];
        int i = elements.size() - 1;
        while (i >= 0) {
            CPListElement currElement = (CPListElement)elements.get(i);
            entries[i] = currElement.getClasspathEntry();
            --i;
        }
        this.fBuildPathStatus.setOK();
    }

    /*
     * Exception decompiling
     */
    public static void createProject(IProject project, URI locationURI, IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 136->140)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void addJavaNature(IProject project, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!project.hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            IProjectDescription description = project.getDescription();
            String[] prevNatures = description.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.wst.jsdt.core.jsNature";
            description.setNatureIds(newNatures);
            project.setDescription(description, monitor);
        } else if (monitor != null) {
            monitor.worked(1);
        }
    }

    public void configureJavaProject(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        this.aboutToDispose();
        BuildPathsBlock.flush(this.fClassPathList.getElements(), this.getJavaProject(), this.getSuperType(), monitor);
        this.initializeTimeStamps();
        this.updateUI();
    }

    public LibrarySuperType getSuperType() {
        Object o = this.ordpage.getSuperField().getValue();
        return (LibrarySuperType)o;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void flush(List classPathEntries, IJavaProject javaProject, LibrarySuperType superType, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (superType == null) {
            System.out.println("---------------------------------- NULL SUPER TYPE -------------------------");
        }
        BuildPathsBlock.setProjectSuperType(javaProject, superType);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(NewWizardMessages.BuildPathsBlock_operationdesc_java);
        monitor.beginTask("", classPathEntries.size() * 4 + 4);
        try {
            IClasspathEntry[] classpath;
            IPath projPath;
            block24: {
                IProject project = javaProject.getProject();
                projPath = project.getFullPath();
                monitor.worked(1);
                IWorkspaceRoot fWorkspaceRoot = JavaPlugin.getWorkspace().getRoot();
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                classpath = new IClasspathEntry[classPathEntries.size()];
                int i = 0;
                Iterator iter = classPathEntries.iterator();
                while (true) {
                    block25: {
                        block27: {
                            IFolder orginalFolder;
                            IFolder folder;
                            CPListElement entry;
                            block29: {
                                IPath orginalPath;
                                block28: {
                                    if (!iter.hasNext()) break block24;
                                    entry = (CPListElement)iter.next();
                                    classpath[i] = entry.getClasspathEntry();
                                    ++i;
                                    IResource res = entry.getResource();
                                    if (res instanceof IFolder && entry.getLinkTarget() == null && !res.exists()) {
                                        CoreUtility.createFolder((IFolder)res, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                    if (entry.getEntryKind() != 3) break block27;
                                    IPath folderOutput = (IPath)entry.getAttribute("output");
                                    if (folderOutput != null && folderOutput.segmentCount() > 1) {
                                        IFolder folder2 = fWorkspaceRoot.getFolder(folderOutput);
                                        CoreUtility.createDerivedFolder(folder2, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    } else {
                                        monitor.worked(1);
                                    }
                                    IPath path = entry.getPath();
                                    if (projPath.equals((Object)path)) {
                                        monitor.worked(2);
                                        continue;
                                    }
                                    if (projPath.isPrefixOf(path)) {
                                        path = path.removeFirstSegments(projPath.segmentCount());
                                    }
                                    folder = project.getFolder(path);
                                    orginalPath = entry.getOrginalPath();
                                    if (orginalPath != null) break block28;
                                    if (!folder.exists()) {
                                        if (entry.getLinkTarget() == null) {
                                            CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                            break block25;
                                        } else {
                                            folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                                        }
                                    }
                                    break block25;
                                }
                                if (projPath.isPrefixOf(orginalPath)) {
                                    orginalPath = orginalPath.removeFirstSegments(projPath.segmentCount());
                                }
                                orginalFolder = project.getFolder(orginalPath);
                                if (entry.getLinkTarget() != null) break block29;
                                if (!folder.exists()) {
                                    IPath parentPath = entry.getPath().removeLastSegments(1);
                                    if (projPath.isPrefixOf(parentPath)) {
                                        parentPath = parentPath.removeFirstSegments(projPath.segmentCount());
                                    }
                                    if (parentPath.segmentCount() > 0) {
                                        IFolder parentFolder = project.getFolder(parentPath);
                                        if (!parentFolder.exists()) {
                                            CoreUtility.createFolder(parentFolder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                        } else {
                                            monitor.worked(1);
                                        }
                                    } else {
                                        monitor.worked(1);
                                    }
                                    orginalFolder.move(entry.getPath(), true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                }
                                break block25;
                            }
                            if (!folder.exists() || !entry.getLinkTarget().equals((Object)entry.getOrginalLinkTarget())) {
                                orginalFolder.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                folder.createLink(entry.getLinkTarget(), 16, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            }
                            break block25;
                        }
                        monitor.worked(3);
                    }
                    if (monitor.isCanceled()) break;
                }
                throw new OperationCanceledException();
            }
            javaProject.setRawClasspath(classpath, projPath, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var19_21 = null;
        }
        monitor.done();
    }

    public static boolean hasClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            return true;
        }
        if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                if (BuildPathsBlock.hasClassfiles(members[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static void removeOldClassfiles(IResource resource) throws CoreException {
        if (resource.isDerived()) {
            resource.delete(false, null);
        } else if (resource instanceof IContainer) {
            IResource[] members = ((IContainer)resource).members();
            int i = 0;
            while (i < members.length) {
                BuildPathsBlock.removeOldClassfiles(members[i]);
                ++i;
            }
        }
    }

    public static IRemoveOldBinariesQuery getRemoveOldBinariesQuery(final Shell shell) {
        return new IRemoveOldBinariesQuery(){

            public boolean doQuery(boolean removeFolder, IPath oldOutputLocation) throws OperationCanceledException {
                int[] res = new int[]{1};
                Display.getDefault().syncExec(new Runnable(this, shell, removeFolder, oldOutputLocation, res){
                    final /* synthetic */ 3 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ boolean val$removeFolder;
                    private final /* synthetic */ IPath val$oldOutputLocation;
                    private final /* synthetic */ int[] val$res;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$removeFolder = bl;
                        this.val$oldOutputLocation = iPath;
                        this.val$res = nArray;
                    }

                    public void run() {
                        Shell sh = this.val$shell != null ? this.val$shell : JavaPlugin.getActiveWorkbenchShell();
                        String title = NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_title;
                        String message = this.val$removeFolder ? Messages.format(NewWizardMessages.BuildPathsBlock_RemoveOldOutputFolder_description, this.val$oldOutputLocation.makeRelative().toOSString()) : Messages.format(NewWizardMessages.BuildPathsBlock_RemoveBinariesDialog_description, this.val$oldOutputLocation.makeRelative().toOSString());
                        MessageDialog dialog = new MessageDialog(sh, title, null, message, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                        this.val$res[0] = dialog.open();
                    }
                });
                if (res[0] == 0) {
                    return true;
                }
                if (res[0] == 1) {
                    return false;
                }
                throw new OperationCanceledException();
            }
        };
    }

    private void tabChanged(Widget widget) {
        if (widget instanceof TabItem) {
            TabItem tabItem = (TabItem)widget;
            BuildPathBasePage newPage = (BuildPathBasePage)tabItem.getData();
            if (this.fCurrPage != null) {
                List selection = this.fCurrPage.getSelection();
                if (!selection.isEmpty()) {
                    newPage.setSelection(selection, false);
                }
                this.fCurrPage.aboutToDispose();
                newPage.aboutToShow();
            }
            this.fCurrPage = newPage;
            this.fPageIndex = tabItem.getParent().getSelectionIndex();
        }
    }

    private int getPageIndex(int entryKind) {
        switch (entryKind) {
            case 1: 
            case 4: 
            case 5: {
                return 2;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 0;
            }
        }
        return 0;
    }

    private CPListElement findElement(IClasspathEntry entry) {
        int i = 0;
        int len = this.fClassPathList.getSize();
        while (i < len) {
            CPListElement curr = (CPListElement)this.fClassPathList.getElement(i);
            if (curr.getEntryKind() == entry.getEntryKind() && curr.getPath().equals((Object)entry.getPath())) {
                return curr;
            }
            ++i;
        }
        return null;
    }

    public void setElementToReveal(IClasspathEntry entry, String attributeKey) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            CPListElement element = this.findElement(entry);
            if (element != null) {
                CPListElementAttribute attrib;
                Object elementToSelect = element;
                if (attributeKey != null && (attrib = element.findAttributeElement(attributeKey)) != null) {
                    elementToSelect = attrib;
                }
                BuildPathBasePage page = (BuildPathBasePage)this.fTabFolder.getItem(pageIndex).getData();
                ArrayList<Object> selection = new ArrayList<Object>(1);
                selection.add(elementToSelect);
                page.setSelection(selection, true);
            }
        }
    }

    public void addElement(IClasspathEntry entry) {
        int pageIndex = this.getPageIndex(entry.getEntryKind());
        if (this.fTabFolder == null) {
            this.fPageIndex = pageIndex;
        } else {
            this.fTabFolder.setSelection(pageIndex);
            Object page = this.fTabFolder.getItem(pageIndex).getData();
            if (page instanceof LibrariesWorkbookPage) {
                CPListElement element = CPListElement.createFromExisting(entry, this.fCurrJProject);
                ((LibrariesWorkbookPage)page).addElement(element);
            }
        }
    }

    public void dispose() {
        if (this.fSourceContainerPage instanceof NewSourceContainerWorkbookPage) {
            ((NewSourceContainerWorkbookPage)this.fSourceContainerPage).dispose();
            this.fSourceContainerPage = null;
        }
    }

    public boolean isOKStatus() {
        return this.findMostSevereStatus().isOK();
    }

    public void setFocus() {
        this.fSourceContainerPage.setFocus();
    }

    private class BuildPathAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        private BuildPathAdapter() {
        }

        public void changeControlPressed(DialogField field) {
            BuildPathsBlock.this.buildPathChangeControlPressed(field);
        }

        public void dialogFieldChanged(DialogField field) {
            BuildPathsBlock.this.buildPathDialogFieldChanged(field);
        }

        public void customButtonPressed(ListDialogField field, int index) {
            BuildPathsBlock.this.buildPathCustomButtonPressed(field, index);
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void selectionChanged(ListDialogField field) {
            List selected = field.getSelectedElements();
            if (selected == null) {
                BuildPathsBlock.this.enableButtons();
                return;
            }
            if (selected.size() != 1) {
                BuildPathsBlock.this.disableButtons();
                return;
            }
            Object selection = selected.get(0);
            int selctedIndext = field.getIndexOfElement(selection);
            if (selctedIndext == 0) {
                BuildPathsBlock.this.disableButtons();
                return;
            }
            BuildPathsBlock.this.enableButtons();
            BuildPathsBlock.this.updateTopButtonEnablement();
        }
    }

    public static interface IRemoveOldBinariesQuery {
        public boolean doQuery(boolean var1, IPath var2) throws OperationCanceledException;
    }
}

