/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathSupport;

public class CPVariableElement {
    private String fName;
    private IPath fPath;

    public CPVariableElement(String name, IPath path) {
        Assert.isNotNull((Object)name);
        Assert.isNotNull((Object)path);
        this.fName = name;
        this.fPath = path;
    }

    public IPath getPath() {
        return this.fPath;
    }

    public void setPath(IPath path) {
        Assert.isNotNull((Object)path);
        this.fPath = path;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        Assert.isNotNull((Object)name);
        this.fName = name;
    }

    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            CPVariableElement elem = (CPVariableElement)other;
            return this.fName.equals(elem.fName);
        }
        return false;
    }

    public int hashCode() {
        return this.fName.hashCode();
    }

    public boolean isReadOnly() {
        return JavaCore.isClasspathVariableReadOnly((String)this.fName);
    }

    public boolean isDeprecated() {
        return JavaCore.getClasspathVariableDeprecationMessage((String)this.fName) != null;
    }

    public String getDeprecationMessage() {
        return BuildPathSupport.getDeprecationMessage(this.fName);
    }
}

