/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPVariableElement;

public class CPVariableElementLabelProvider
extends LabelProvider
implements IColorProvider {
    private Image fJARImage;
    private Image fFolderImage;
    private Color fResolvedBackground;
    private Image fDeprecatedJARImage;
    private Image fDeprecatedFolderImage;
    private boolean fHighlightReadOnly;

    public CPVariableElementLabelProvider(boolean highlightReadOnly) {
        ImageRegistry reg = JavaPlugin.getDefault().getImageRegistry();
        this.fJARImage = reg.get("org.eclipse.wst.jsdt.ui.jar_l_obj.gif");
        this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        this.fDeprecatedJARImage = new DecorationOverlayIcon(this.fJARImage, JavaPluginImages.DESC_OVR_DEPRECATED, 0).createImage();
        this.fDeprecatedFolderImage = new DecorationOverlayIcon(this.fFolderImage, JavaPluginImages.DESC_OVR_DEPRECATED, 0).createImage();
        this.fHighlightReadOnly = highlightReadOnly;
        this.fResolvedBackground = null;
    }

    public Image getImage(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            IPath path = curr.getPath();
            if (path.toFile().isFile()) {
                return curr.isDeprecated() ? this.fDeprecatedJARImage : this.fJARImage;
            }
            return curr.isDeprecated() ? this.fDeprecatedFolderImage : this.fFolderImage;
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            String name = curr.getName();
            IPath path = curr.getPath();
            String result = name;
            ArrayList<String> restrictions = new ArrayList<String>(2);
            if (curr.isReadOnly() && this.fHighlightReadOnly) {
                restrictions.add(NewWizardMessages.CPVariableElementLabelProvider_read_only);
            }
            if (curr.isDeprecated()) {
                restrictions.add(NewWizardMessages.CPVariableElementLabelProvider_deprecated);
            }
            if (restrictions.size() == 1) {
                result = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_one_restriction, new Object[]{result, restrictions.get(0)});
            } else if (restrictions.size() == 2) {
                result = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_two_restrictions, new Object[]{result, restrictions.get(0), restrictions.get(1)});
            }
            if (path != null) {
                String appendix = !path.isEmpty() ? path.toOSString() : NewWizardMessages.CPVariableElementLabelProvider_empty;
                result = Messages.format(NewWizardMessages.CPVariableElementLabelProvider_appendix, new Object[]{result, appendix});
            }
            return result;
        }
        return super.getText(element);
    }

    public Color getForeground(Object element) {
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof CPVariableElement) {
            CPVariableElement curr = (CPVariableElement)element;
            if (this.fHighlightReadOnly && curr.isReadOnly()) {
                if (this.fResolvedBackground == null) {
                    Display display = Display.getCurrent();
                    this.fResolvedBackground = display.getSystemColor(29);
                }
                return this.fResolvedBackground;
            }
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        this.fDeprecatedFolderImage.dispose();
        this.fDeprecatedJARImage.dispose();
    }
}

