/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.ui.wizards.IClasspathContainerPage;

public class ClasspathContainerDescriptor {
    private IConfigurationElement fConfigElement;
    private IClasspathContainerPage fPage;
    private static final String ATT_EXTENSION = "classpathContainerPage";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_PAGE_CLASS = "class";
    static /* synthetic */ Class class$0;

    public ClasspathContainerDescriptor(IConfigurationElement configElement) throws CoreException {
        this.fConfigElement = configElement;
        this.fPage = null;
        String id = this.fConfigElement.getAttribute(ATT_ID);
        String name = configElement.getAttribute(ATT_NAME);
        String pageClassName = configElement.getAttribute(ATT_PAGE_CLASS);
        if (name == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing name): " + id, null));
        }
        if (pageClassName == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (missing page class name): " + id, null));
        }
    }

    public IClasspathContainerPage createPage() throws CoreException {
        if (this.fPage == null) {
            Object elem = CoreUtility.createExtension(this.fConfigElement, ATT_PAGE_CLASS);
            if (elem instanceof IClasspathContainerPage) {
                this.fPage = (IClasspathContainerPage)elem;
            } else {
                String id = this.fConfigElement.getAttribute(ATT_ID);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", 0, "Invalid extension (page not of type IClasspathContainerPage): " + id, null));
            }
        }
        return this.fPage;
    }

    public IClasspathContainerPage getPage() {
        return this.fPage;
    }

    public void setPage(IClasspathContainerPage page) {
        this.fPage = page;
    }

    public void dispose() {
        if (this.fPage != null) {
            this.fPage.dispose();
            this.fPage = null;
        }
    }

    public String getName() {
        return this.fConfigElement.getAttribute(ATT_NAME);
    }

    public String getPageClass() {
        return this.fConfigElement.getAttribute(ATT_PAGE_CLASS);
    }

    public boolean canEdit(IClasspathEntry entry) {
        String id = this.fConfigElement.getAttribute(ATT_ID);
        if (entry.getEntryKind() == 5) {
            String type = entry.getPath().segment(0);
            return id.equals(type);
        }
        return false;
    }

    public static ClasspathContainerDescriptor[] getDescriptors() {
        ArrayList<ClasspathContainerDescriptor> containers = new ArrayList<ClasspathContainerDescriptor>();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.wst.jsdt.ui", ATT_EXTENSION);
        if (extensionPoint != null) {
            ClasspathContainerDescriptor defaultPage = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathContainerDefaultPage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String defaultPageName = clazz.getName();
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                try {
                    ClasspathContainerDescriptor curr = new ClasspathContainerDescriptor(elements[i]);
                    if (defaultPageName.equals(curr.getPageClass())) {
                        defaultPage = curr;
                    } else {
                        containers.add(curr);
                    }
                }
                catch (CoreException e) {
                    JavaPlugin.log(e);
                }
                ++i;
            }
            if (defaultPageName != null && containers.isEmpty()) {
                containers.add(defaultPage);
            }
        }
        return containers.toArray(new ClasspathContainerDescriptor[containers.size()]);
    }
}

