/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths;

import java.util.Arrays;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.util.SelectionUtil;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.ClasspathContainerDescriptor;

public class ClasspathContainerSelectionPage
extends WizardPage {
    private static final String DIALOGSTORE_SECTION = "ClasspathContainerSelectionPage";
    private static final String DIALOGSTORE_CONTAINER_IDX = "index";
    private ListViewer fListViewer;
    private ClasspathContainerDescriptor[] fContainers;
    private IDialogSettings fDialogSettings;

    protected ClasspathContainerSelectionPage(ClasspathContainerDescriptor[] containerPages) {
        super("ClasspathContainerWizardPage");
        this.setTitle(NewWizardMessages.ClasspathContainerSelectionPage_title);
        this.setDescription(NewWizardMessages.ClasspathContainerSelectionPage_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainers = containerPages;
        IDialogSettings settings = JavaPlugin.getDefault().getDialogSettings();
        this.fDialogSettings = settings.getSection(DIALOGSTORE_SECTION);
        if (this.fDialogSettings == null) {
            this.fDialogSettings = settings.addNewSection(DIALOGSTORE_SECTION);
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, 0);
        }
        this.validatePage();
    }

    public void createControl(Composite parent) {
        this.fListViewer = new ListViewer(parent, 2052);
        this.fListViewer.setLabelProvider((IBaseLabelProvider)new ClasspathContainerLabelProvider());
        this.fListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.fListViewer.setComparator(new ViewerComparator());
        this.fListViewer.setInput(Arrays.asList(this.fContainers));
        this.fListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ClasspathContainerSelectionPage.this.validatePage();
            }
        });
        this.fListViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ClasspathContainerSelectionPage.this.doDoubleClick();
            }
        });
        int selectionIndex = this.fDialogSettings.getInt(DIALOGSTORE_CONTAINER_IDX);
        if (selectionIndex >= this.fContainers.length) {
            selectionIndex = 0;
        }
        this.fListViewer.getList().select(selectionIndex);
        this.validatePage();
        this.setControl((Control)this.fListViewer.getList());
        Dialog.applyDialogFont((Control)this.fListViewer.getList());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.wst.jsdt.ui.bp_select_classpath_container");
    }

    private void validatePage() {
        this.setPageComplete(this.getSelected() != null);
    }

    public ClasspathContainerDescriptor getSelected() {
        if (this.fListViewer != null) {
            ISelection selection = this.fListViewer.getSelection();
            return (ClasspathContainerDescriptor)SelectionUtil.getSingleElement(selection);
        }
        return null;
    }

    public ClasspathContainerDescriptor[] getContainers() {
        return this.fContainers;
    }

    protected void doDoubleClick() {
        if (this.canFlipToNextPage()) {
            this.getContainer().showPage(this.getNextPage());
        }
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    public void setVisible(boolean visible) {
        if (!visible && this.fListViewer != null) {
            this.fDialogSettings.put(DIALOGSTORE_CONTAINER_IDX, this.fListViewer.getList().getSelectionIndex());
        }
        super.setVisible(visible);
    }

    private static class ClasspathContainerLabelProvider
    extends LabelProvider {
        private ClasspathContainerLabelProvider() {
        }

        public String getText(Object element) {
            return ((ClasspathContainerDescriptor)element).getName();
        }
    }
}

