/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaCore;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.OutputLocationDialog;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class EditOutputFolderAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;
    private boolean fShowOutputFolders;

    public EditOutputFolderAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.fShowOutputFolders = true;
    }

    public EditOutputFolderAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private EditOutputFolderAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 7);
        this.fContext = context;
        this.fShowOutputFolders = false;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_CONFIGURE_OUTPUT_FOLDER);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_EditOutput_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_CONFIGURE_OUTPUT_FOLDER);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_EditOutputFolder;
    }

    public void showOutputFolders(boolean showOutputFolders) {
        this.fShowOutputFolders = showOutputFolders;
    }

    public void run() {
        try {
            Object folderToDelete;
            IJavaProject javaProject;
            Shell shell = this.getShell();
            CPListElement cpElement = null;
            Object firstElement = this.getSelectedElements().get(0);
            if (firstElement instanceof IJavaProject) {
                javaProject = (IJavaProject)firstElement;
                IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(javaProject.getPath(), javaProject, 3);
                cpElement = CPListElement.createFromExisting(entry, javaProject);
            } else if (firstElement instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)firstElement;
                javaProject = root.getJavaProject();
                IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(root.getPath(), javaProject, 3);
                cpElement = CPListElement.createFromExisting(entry, javaProject);
            } else if (firstElement instanceof CPListElementAttribute) {
                CPListElementAttribute attribute = (CPListElementAttribute)firstElement;
                cpElement = attribute.getParent();
                javaProject = cpElement.getJavaProject();
            } else {
                return;
            }
            List classpathEntries = ClasspathModifier.getExistingEntries(javaProject);
            CPListElement element = ClasspathModifier.getClasspathEntry(classpathEntries, cpElement);
            OutputLocationDialog dialog = new OutputLocationDialog(shell, element, classpathEntries, javaProject.getOutputLocation(), false);
            if (dialog.open() != 0) {
                return;
            }
            CPJavaProject cpProject = CPJavaProject.createFromExisting(javaProject);
            BuildpathDelta delta = ClasspathModifier.setOutputLocation(cpProject.getCPElement(element), dialog.getOutputLocation(), false, cpProject);
            IFolder oldOutputFolder = this.getOldOutputFolder(delta);
            if (oldOutputFolder != null) {
                String message = Messages.format(NewWizardMessages.EditOutputFolderAction_DeleteOldOutputFolderQuestion, oldOutputFolder.getLocation().toString());
                folderToDelete = MessageDialog.openQuestion((Shell)this.getShell(), (String)NewWizardMessages.OutputLocationDialog_title, (String)message) ? oldOutputFolder : null;
            } else {
                folderToDelete = null;
            }
            try {
                IRunnableWithProgress runnable = new IRunnableWithProgress((IFolder)folderToDelete, cpProject, delta, element){
                    private final /* synthetic */ IFolder val$folderToDelete;
                    private final /* synthetic */ CPJavaProject val$cpProject;
                    private final /* synthetic */ BuildpathDelta val$delta;
                    private final /* synthetic */ CPListElement val$element;
                    {
                        this.val$folderToDelete = iFolder;
                        this.val$cpProject = cPJavaProject;
                        this.val$delta = buildpathDelta;
                        this.val$element = cPListElement;
                    }

                    /*
                     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
                     * Enabled aggressive block sorting
                     * Enabled unnecessary exception pruning
                     * Enabled aggressive exception aggregation
                     */
                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            try {
                                monitor.beginTask(NewWizardMessages.EditOutputFolderAction_ProgressMonitorDescription, 50 + (this.val$folderToDelete == null ? 0 : 10));
                                ClasspathModifier.commitClassPath(this.val$cpProject, (IProgressMonitor)new SubProgressMonitor(monitor, 50));
                                if (this.val$folderToDelete != null) {
                                    this.val$folderToDelete.delete(true, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                                }
                                EditOutputFolderAction.this.informListeners(this.val$delta);
                                EditOutputFolderAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)JavaCore.create((IResource)this.val$element.getResource())));
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_4 = null;
                            monitor.done();
                            throw throwable;
                        }
                        {
                            Object var3_5 = null;
                        }
                        monitor.done();
                    }
                };
                this.fContext.run(false, false, runnable);
            }
            catch (InvocationTargetException e) {
                JavaPlugin.log(e);
            }
            catch (InterruptedException interruptedException) {}
        }
        catch (CoreException e) {
            this.showExceptionDialog(e, NewWizardMessages.EditOutputFolderAction_ErrorDescription);
        }
    }

    private IFolder getOldOutputFolder(BuildpathDelta delta) {
        IResource[] deletedResources = delta.getDeletedResources();
        ArrayList<IResource> existingFolders = new ArrayList<IResource>();
        int i = 0;
        while (i < deletedResources.length) {
            if (deletedResources[i] instanceof IFolder && deletedResources[i].exists()) {
                existingFolders.add(deletedResources[i]);
            }
            ++i;
        }
        if (existingFolders.size() > 0) {
            if (existingFolders.size() > 1) {
                String message = "Found more then one existing folders:";
                Iterator iterator = existingFolders.iterator();
                while (iterator.hasNext()) {
                    IFolder folder = (IFolder)iterator.next();
                    message = String.valueOf(message) + "\n" + folder.toString();
                }
                Assert.isTrue((boolean)false, (String)message);
            }
            return (IFolder)existingFolders.get(0);
        }
        return null;
    }

    protected boolean canHandle(IStructuredSelection elements) {
        Object element;
        block12: {
            block9: {
                IJavaProject javaProject;
                IPackageFragmentRoot root;
                block11: {
                    block10: {
                        if (!this.fShowOutputFolders) {
                            return false;
                        }
                        if (elements.size() != 1) {
                            return false;
                        }
                        element = elements.getFirstElement();
                        try {
                            if (!(element instanceof IPackageFragmentRoot)) break block9;
                            root = (IPackageFragmentRoot)element;
                            if (root.getKind() == 1) break block10;
                            return false;
                        }
                        catch (JavaModelException javaModelException) {
                            return false;
                        }
                    }
                    javaProject = root.getJavaProject();
                    if (javaProject != null) break block11;
                    return false;
                }
                IClasspathEntry entry = ClasspathModifier.getClasspathEntryFor(root.getPath(), javaProject, 3);
                return entry != null;
            }
            if (!(element instanceof IJavaProject)) break block12;
            IJavaProject project = (IJavaProject)element;
            return ClasspathModifier.isSourceFolder(project);
        }
        if (element instanceof CPListElementAttribute) {
            CPListElementAttribute attribute = (CPListElementAttribute)element;
            return attribute.getKey() == "output";
        }
        return false;
    }
}

