/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class ExcludeFromBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public ExcludeFromBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public ExcludeFromBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private ExcludeFromBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 2);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_EXCLUDE_FROM_BUILDPATH);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Exclude_tooltip);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_EXCLUDE_FROM_BUILDPATH);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_Exclude;
        }
        IJavaElement elem = (IJavaElement)this.getSelectedElements().get(0);
        String name = ClasspathModifier.escapeSpecialChars(elem.getElementName());
        if (elem instanceof IPackageFragment) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludePackage, name);
        }
        if (elem instanceof ICompilationUnit) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ExcludeFile, name);
        }
        return null;
    }

    public void run() {
        Object object = this.getSelectedElements().get(0);
        final IJavaProject project = object instanceof ICompilationUnit ? ((ICompilationUnit)object).getJavaProject() : ((IPackageFragment)object).getJavaProject();
        try {
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = ExcludeFromBuildpathAction.this.exclude(ExcludeFromBuildpathAction.this.getSelectedElements(), project, monitor);
                        ExcludeFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.ExcludeFromBuildathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List exclude(List javaElements, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<IResource> arrayList;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Excluding, javaElements.size() + 4);
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<IResource> resources = new ArrayList<IResource>();
            int i = 0;
            while (i < javaElements.size()) {
                IPackageFragmentRoot root;
                CPListElement entry;
                IJavaElement javaElement = (IJavaElement)javaElements.get(i);
                IResource resource = ClasspathModifier.exclude(javaElement, entry = ClasspathModifier.getClasspathEntry(existingEntries, root = (IPackageFragmentRoot)javaElement.getAncestor(3)), project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (resource != null) {
                    resources.add(resource);
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
            this.informListeners(delta);
            arrayList = resources;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }

    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        Iterator iter = elements.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof IPackageFragment) {
                IPackageFragment fragment = (IPackageFragment)element;
                if (ClasspathModifier.isDefaultFragment(fragment)) {
                    return false;
                }
                if (!((IPackageFragmentRoot)fragment.getAncestor(3)).isArchive()) continue;
                return false;
            }
            if (element instanceof ICompilationUnit) continue;
            return false;
        }
        return true;
    }
}

