/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IClasspathEntry;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class ResetAllOutputFoldersAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;
    private final IJavaProject fJavaProject;

    public ResetAllOutputFoldersAction(IRunnableContext context, IJavaProject project, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context, project);
    }

    public ResetAllOutputFoldersAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context, IJavaProject javaProject) {
        super(site, selectionTarget, 17);
        this.fContext = context;
        this.fJavaProject = javaProject;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_Reset_tooltip);
    }

    public String getDetailedDescription() {
        return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_ResetAllOutputFolders;
    }

    public void run() {
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    ResetAllOutputFoldersAction.this.resetOutputFolders(ResetAllOutputFoldersAction.this.fJavaProject, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
            } else {
                JavaPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private List resetOutputFolders(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        List list;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_ResetOutputFolder, roots.length + 10);
            ArrayList<CPListElementAttribute> entries = new ArrayList<CPListElementAttribute>();
            int i = 0;
            while (i < roots.length) {
                monitor.worked(1);
                if (!roots[i].isArchive()) {
                    IClasspathEntry entry = roots[i].getRawClasspathEntry();
                    CPListElement element = CPListElement.createFromExisting(entry, project);
                    CPListElementAttribute outputFolder = new CPListElementAttribute(element, "output", element.getAttribute("output"), true);
                    entries.add(outputFolder);
                }
                ++i;
            }
            list = this.reset(entries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return list;
    }

    private List reset(List selection, IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        ArrayList<Object> arrayList;
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_Resetting, selection.size());
            List entries = ClasspathModifier.getExistingEntries(project);
            ArrayList<Object> result = new ArrayList<Object>();
            int i = 0;
            while (i < selection.size()) {
                Object element = selection.get(i);
                if (element instanceof IJavaElement) {
                    IJavaElement javaElement = (IJavaElement)element;
                    IPackageFragmentRoot root = element instanceof IJavaProject ? project.getPackageFragmentRoot(project.getResource()) : (IPackageFragmentRoot)element;
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, root);
                    ClasspathModifier.resetFilters(javaElement, entry, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    result.add(javaElement);
                } else {
                    CPListElement selElement = ((CPListElementAttribute)element).getParent();
                    CPListElement entry = ClasspathModifier.getClasspathEntry(entries, selElement);
                    CPListElementAttribute outputFolder = ClasspathModifier.resetOutputFolder(entry, project);
                    result.add(outputFolder);
                }
                ++i;
            }
            ClasspathModifier.commitClassPath(entries, project, null);
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            delta.setNewEntries(entries.toArray(new CPListElement[entries.size()]));
            this.informListeners(delta);
            arrayList = result;
            Object var11_13 = null;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
        return arrayList;
    }

    protected boolean canHandle(IStructuredSelection elements) {
        return true;
    }
}

