/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.javadoc.JavaDocCommentReader;
import org.eclipse.wst.jsdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.wst.jsdt.internal.ui.text.javadoc.JavaDoc2HTMLTextReader;

public class JavadocContentAccess {
    private JavadocContentAccess() {
    }

    public static Reader getContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        JavaDocCommentReader reader;
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange != null && !JavadocContentAccess.containsOnlyInheritDoc(reader = new JavaDocCommentReader(buf, javadocRange.getOffset(), javadocRange.getOffset() + javadocRange.getLength() - 1), javadocRange.getLength())) {
            reader.reset();
            return reader;
        }
        if (allowInherited && member.getElementType() == 9) {
            return JavadocContentAccess.findDocInHierarchy((IMethod)member);
        }
        return null;
    }

    private static boolean containsOnlyInheritDoc(Reader reader, int length) {
        char[] content = new char[length];
        try {
            reader.read(content, 0, length);
        }
        catch (IOException iOException) {
            return false;
        }
        return new String(content).trim().equals("{@inheritDoc}");
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited, boolean useAttachedJavadoc) throws JavaModelException {
        String s;
        Reader contentReader = JavadocContentAccess.getContentReader(member, allowInherited);
        if (contentReader != null) {
            return new JavaDoc2HTMLTextReader(contentReader);
        }
        if (useAttachedJavadoc && member.getOpenable().getBuffer() == null && (s = member.getAttachedJavadoc(null)) != null) {
            return new StringReader(s);
        }
        return null;
    }

    public static Reader getHTMLContentReader(IMember member, boolean allowInherited) throws JavaModelException {
        return JavadocContentAccess.getHTMLContentReader(member, allowInherited, false);
    }

    private static Reader findDocInHierarchy(IMethod method) throws JavaModelException {
        IType type = method.getDeclaringType();
        if (type == null) {
            return null;
        }
        ITypeHierarchy hierarchy = type.newSupertypeHierarchy(null);
        MethodOverrideTester tester = new MethodOverrideTester(type, hierarchy);
        IType[] superTypes = hierarchy.getAllSupertypes(type);
        int i = 0;
        while (i < superTypes.length) {
            Reader reader;
            IType curr = superTypes[i];
            IMethod overridden = tester.findOverriddenMethodInType(curr, method);
            if (overridden != null && (reader = JavadocContentAccess.getContentReader((IMember)overridden, false)) != null) {
                return reader;
            }
            ++i;
        }
        return null;
    }
}

