/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.dom.IMethodBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.AddUnimplementedConstructorsOperation;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.SourceActionDialog;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.wst.jsdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaElementComparator;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class AddUnimplementedConstructorsAction
extends SelectionDispatchAction {
    private static final String DIALOG_TITLE = ActionMessages.AddUnimplementedConstructorsAction_error_title;
    private CompilationUnitEditor fEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public AddUnimplementedConstructorsAction(CompilationUnitEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(this.checkEnabledEditor());
    }

    public AddUnimplementedConstructorsAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.AddUnimplementedConstructorsAction_label);
        this.setDescription(ActionMessages.AddUnimplementedConstructorsAction_description);
        this.setToolTipText(ActionMessages.AddUnimplementedConstructorsAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.add_unimplemented_constructors_action_context");
    }

    private boolean canEnable(IStructuredSelection selection) throws JavaModelException {
        if (selection.size() == 1 && selection.getFirstElement() instanceof IType) {
            IType type = (IType)selection.getFirstElement();
            return type.getCompilationUnit() != null && !type.isInterface() && !type.isEnum();
        }
        return selection.size() == 1 && selection.getFirstElement() instanceof ICompilationUnit;
    }

    private boolean checkEnabledEditor() {
        return this.fEditor != null && SelectionConverter.canOperateOn(this.fEditor);
    }

    private String getDialogTitle() {
        return DIALOG_TITLE;
    }

    private IType getSelectedType(IStructuredSelection selection) throws JavaModelException {
        ICompilationUnit cu;
        IType type;
        Object[] elements = selection.toArray();
        if (elements.length == 1 && elements[0] instanceof IType) {
            IType type2 = (IType)elements[0];
            if (type2.getCompilationUnit() != null && !type2.isInterface() && !type2.isEnum()) {
                return type2;
            }
        } else if (elements[0] instanceof ICompilationUnit && (type = (cu = (ICompilationUnit)elements[0]).findPrimaryType()) != null && !type.isInterface() && !type.isEnum()) {
            return type;
        }
        return null;
    }

    public void run(IStructuredSelection selection) {
        Shell shell = this.getShell();
        try {
            IType type = this.getSelectedType(selection);
            if (type == null) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_not_applicable);
                return;
            }
            if (type.isAnnotation()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_annotation_not_applicable);
                return;
            }
            if (type.isInterface()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_interface_not_applicable);
                return;
            }
            if (type.isEnum()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_enum_not_applicable);
                return;
            }
            this.run(shell, type, false);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        try {
            Shell shell = this.getShell();
            IType type = SelectionConverter.getTypeAtOffset(this.fEditor);
            if (type != null) {
                this.run(shell, type, true);
            } else {
                MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_not_applicable);
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), this.getShell(), this.getDialogTitle(), null);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), this.getDialogTitle(), null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(Shell shell, IType type, boolean activatedFromEditor) throws CoreException {
        int dialogResult;
        block24: {
            if (!ElementValidator.check((IJavaElement)type, this.getShell(), this.getDialogTitle(), activatedFromEditor)) {
                this.notifyResult(false);
                return;
            }
            if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)type)) {
                this.notifyResult(false);
                return;
            }
            AddUnimplementedConstructorsContentProvider provider = new AddUnimplementedConstructorsContentProvider(type);
            Object[] constructors = provider.getElements(null);
            if (constructors.length == 0) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_error_nothing_found);
                this.notifyResult(false);
                return;
            }
            AddUnimplementedConstructorsDialog dialog = new AddUnimplementedConstructorsDialog(shell, (ILabelProvider)new BindingLabelProvider(), provider, this.fEditor, type);
            dialog.setCommentString(ActionMessages.SourceActionDialog_createConstructorComment);
            dialog.setTitle(ActionMessages.AddUnimplementedConstructorsAction_dialog_title);
            dialog.setInitialSelections(constructors);
            dialog.setContainerMode(true);
            dialog.setComparator(new JavaElementComparator());
            dialog.setSize(60, 18);
            dialog.setInput(new Object());
            dialog.setMessage(ActionMessages.AddUnimplementedConstructorsAction_dialog_label);
            dialog.setValidator(new AddUnimplementedConstructorsValidator(constructors.length));
            dialogResult = dialog.open();
            if (dialogResult == 0) {
                IRewriteTarget target;
                IRewriteTarget iRewriteTarget;
                Object[] elements = dialog.getResult();
                if (elements == null) {
                    this.notifyResult(false);
                    return;
                }
                ArrayList<Object> result = new ArrayList<Object>();
                int i = 0;
                while (i < elements.length) {
                    Object elem = elements[i];
                    if (elem instanceof IMethodBinding) {
                        result.add(elem);
                    }
                    ++i;
                }
                IMethodBinding[] selected = result.toArray(new IMethodBinding[result.size()]);
                CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(type.getJavaProject());
                settings.createComments = dialog.getGenerateComment();
                IEditorPart editor = JavaUI.openInEditor((IJavaElement)type, true, false);
                if (editor != null) {
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    iRewriteTarget = (IRewriteTarget)editor.getAdapter((Class)clazz);
                } else {
                    iRewriteTarget = target = null;
                }
                if (target != null) {
                    target.beginCompoundChange();
                }
                try {
                    try {
                        CompilationUnit astRoot = provider.getCompilationUnit();
                        ITypeBinding typeBinding = ASTNodes.getTypeBinding(astRoot, type);
                        int insertPos = dialog.getInsertOffset();
                        AddUnimplementedConstructorsOperation operation = (AddUnimplementedConstructorsOperation)AddUnimplementedConstructorsAction.createRunnable(astRoot, typeBinding, selected, insertPos, dialog.getGenerateComment(), dialog.getVisibilityModifier(), dialog.isOmitSuper());
                        Object context = JavaPlugin.getActiveWorkbenchWindow();
                        if (context == null) {
                            context = new BusyIndicatorRunnableContext();
                        }
                        PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(operation, operation.getSchedulingRule()), operation.getSchedulingRule());
                        String[] created = operation.getCreatedConstructors();
                        if (created == null || created.length == 0) {
                            MessageDialog.openInformation((Shell)shell, (String)this.getDialogTitle(), (String)ActionMessages.AddUnimplementedConstructorsAction_error_nothing_found);
                        }
                    }
                    catch (InvocationTargetException e) {
                        ExceptionHandler.handle(e, shell, this.getDialogTitle(), null);
                    }
                    catch (InterruptedException interruptedException) {}
                    Object var20_24 = null;
                    if (target == null) break block24;
                }
                catch (Throwable throwable) {
                    Object var20_23 = null;
                    if (target != null) {
                        target.endCompoundChange();
                    }
                    throw throwable;
                }
                target.endCompoundChange();
            }
        }
        this.notifyResult(dialogResult == 0);
    }

    public static IWorkspaceRunnable createRunnable(CompilationUnit astRoot, ITypeBinding type, IMethodBinding[] constructorsToOverride, int insertPos, boolean createComments, int visibility, boolean omitSuper) {
        AddUnimplementedConstructorsOperation operation = new AddUnimplementedConstructorsOperation(astRoot, type, constructorsToOverride, insertPos, true, true, false);
        operation.setCreateComments(createComments);
        operation.setOmitSuper(omitSuper);
        operation.setVisibility(visibility);
        return operation;
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.canEnable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void selectionChanged(ITextSelection selection) {
    }

    private static class AddUnimplementedConstructorsContentProvider
    implements ITreeContentProvider {
        private static final Object[] EMPTY = new Object[0];
        private IMethodBinding[] fMethodsList = new IMethodBinding[0];
        private final CompilationUnit fUnit;

        public AddUnimplementedConstructorsContentProvider(IType type) throws JavaModelException {
            ITypeBinding binding;
            AbstractTypeDeclaration declaration;
            RefactoringASTParser parser = new RefactoringASTParser(3);
            this.fUnit = parser.parse((ITypeRoot)type.getCompilationUnit(), true);
            ASTNode aSTNode = NodeFinder.perform((ASTNode)this.fUnit, type.getNameRange());
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((declaration = (AbstractTypeDeclaration)ASTNodes.getParent(aSTNode, clazz)) != null && (binding = declaration.resolveBinding()) != null) {
                this.fMethodsList = StubUtility2.getVisibleConstructors(binding, true, false);
            }
        }

        public CompilationUnit getCompilationUnit() {
            return this.fUnit;
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            return EMPTY;
        }

        public Object[] getElements(Object inputElement) {
            return this.fMethodsList;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private static class AddUnimplementedConstructorsDialog
    extends SourceActionDialog {
        private IDialogSettings fAddConstructorsSettings;
        private int fHeight = 18;
        private boolean fOmitSuper;
        private int fWidth = 60;
        private final String OMIT_SUPER = "OmitCallToSuper";
        private final String SETTINGS_SECTION = "AddUnimplementedConstructorsDialog";

        public AddUnimplementedConstructorsDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type) throws JavaModelException {
            super(parent, labelProvider, contentProvider, editor, type, true);
            IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
            this.fAddConstructorsSettings = dialogSettings.getSection("AddUnimplementedConstructorsDialog");
            if (this.fAddConstructorsSettings == null) {
                this.fAddConstructorsSettings = dialogSettings.addNewSection("AddUnimplementedConstructorsDialog");
                this.fAddConstructorsSettings.put("OmitCallToSuper", false);
            }
            this.fOmitSuper = this.fAddConstructorsSettings.getBoolean("OmitCallToSuper");
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.wst.jsdt.ui.add_unimplemented_constructors_dialog_context");
        }

        protected Control createDialogArea(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            GridData gd = null;
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            composite.setLayout((Layout)layout);
            Label messageLabel = this.createMessageArea(composite);
            if (messageLabel != null) {
                gd = new GridData(256);
                gd.horizontalSpan = 2;
                messageLabel.setLayoutData((Object)gd);
            }
            Composite inner = new Composite(composite, 0);
            GridLayout innerLayout = new GridLayout();
            innerLayout.numColumns = 2;
            innerLayout.marginHeight = 0;
            innerLayout.marginWidth = 0;
            inner.setLayout((Layout)innerLayout);
            inner.setFont(parent.getFont());
            CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
            gd = new GridData(1808);
            gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
            gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
            treeViewer.getControl().setLayoutData((Object)gd);
            Composite buttonComposite = this.createSelectionButtons(inner);
            gd = new GridData(272);
            buttonComposite.setLayoutData((Object)gd);
            gd = new GridData(1808);
            inner.setLayoutData((Object)gd);
            Composite entryComposite = this.createInsertPositionCombo(composite);
            entryComposite.setLayoutData((Object)new GridData(768));
            Composite commentComposite = this.createCommentSelection(composite);
            commentComposite.setLayoutData((Object)new GridData(768));
            Composite overrideSuperComposite = this.createOmitSuper(composite);
            overrideSuperComposite.setLayoutData((Object)new GridData(768));
            Control linkControl = this.createLinkControl(composite);
            if (linkControl != null) {
                linkControl.setLayoutData((Object)new GridData(768));
            }
            gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            AddUnimplementedConstructorsDialog.applyDialogFont((Control)composite);
            return composite;
        }

        protected Composite createInsertPositionCombo(Composite composite) {
            Composite entryComposite = super.createInsertPositionCombo(composite);
            this.addVisibilityAndModifiersChoices(entryComposite);
            return entryComposite;
        }

        protected Control createLinkControl(Composite composite) {
            Link link = new Link(composite, 64);
            link.setText(ActionMessages.AddUnimplementedConstructorsAction_template_link_message);
            link.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ AddUnimplementedConstructorsDialog this$1;
                {
                    this.this$1 = addUnimplementedConstructorsDialog;
                }

                public void widgetSelected(SelectionEvent e) {
                    AddUnimplementedConstructorsDialog.access$0(this.this$1, "org.eclipse.wst.jsdt.ui.text.codetemplates.constructorcomment");
                }
            });
            link.setToolTipText(ActionMessages.AddUnimplementedConstructorsAction_template_link_tooltip);
            GridData gridData = new GridData(4, 1, true, false);
            gridData.widthHint = this.convertWidthInCharsToPixels(40);
            link.setLayoutData((Object)gridData);
            return link;
        }

        private Composite createOmitSuper(Composite composite) {
            Composite omitSuperComposite = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            omitSuperComposite.setLayout((Layout)layout);
            omitSuperComposite.setFont(composite.getFont());
            Button omitSuperButton = new Button(omitSuperComposite, 32);
            omitSuperButton.setText(ActionMessages.AddUnimplementedConstructorsDialog_omit_super);
            omitSuperButton.setLayoutData((Object)new GridData(256));
            omitSuperButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AddUnimplementedConstructorsDialog this$1;
                {
                    this.this$1 = addUnimplementedConstructorsDialog;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean isSelected = ((Button)e.widget).getSelection();
                    this.this$1.setOmitSuper(isSelected);
                }
            });
            omitSuperButton.setSelection(this.isOmitSuper());
            GridData gd = new GridData(256);
            gd.horizontalSpan = 2;
            omitSuperButton.setLayoutData((Object)gd);
            return omitSuperComposite;
        }

        protected Composite createVisibilityControlAndModifiers(Composite parent, IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
            Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
            return visibilityComposite;
        }

        public boolean isOmitSuper() {
            return this.fOmitSuper;
        }

        public void setOmitSuper(boolean omitSuper) {
            if (this.fOmitSuper != omitSuper) {
                this.fOmitSuper = omitSuper;
                this.fAddConstructorsSettings.put("OmitCallToSuper", omitSuper);
            }
        }

        static /* synthetic */ void access$0(AddUnimplementedConstructorsDialog addUnimplementedConstructorsDialog, String string) {
            addUnimplementedConstructorsDialog.openCodeTempatePage(string);
        }
    }

    private static class AddUnimplementedConstructorsValidator
    implements ISelectionStatusValidator {
        private static int fEntries;

        AddUnimplementedConstructorsValidator(int entries) {
            fEntries = entries;
        }

        private int countSelectedMethods(Object[] selection) {
            int count = 0;
            int i = 0;
            while (i < selection.length) {
                if (selection[i] instanceof IMethodBinding) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        public IStatus validate(Object[] selection) {
            int count = this.countSelectedMethods(selection);
            if (count == 0) {
                return new StatusInfo(4, "");
            }
            String message = Messages.format(ActionMessages.AddUnimplementedConstructorsAction_methods_selected, new Object[]{String.valueOf(count), String.valueOf(fEntries)});
            return new StatusInfo(1, message);
        }
    }
}

