/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ConvertAnonymousToNestedAction
extends SelectionDispatchAction {
    private final JavaEditor fEditor;

    public ConvertAnonymousToNestedAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.setText(RefactoringMessages.ConvertAnonymousToNestedAction_Convert_Anonymous);
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.convert_anonymous_to_nested_action");
    }

    public ConvertAnonymousToNestedAction(IWorkbenchSite site) {
        super(site);
        this.fEditor = null;
        this.setText(RefactoringMessages.ConvertAnonymousToNestedAction_Convert_Anonymous);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.convert_anonymous_to_nested_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isConvertAnonymousAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        IType type = this.getElement(selection);
        if (type == null) {
            return;
        }
        try {
            ISourceRange range = type.getNameRange();
            this.run(type.getCompilationUnit(), range.getOffset(), range.getLength());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }

    private IType getElement(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (!(element instanceof IType)) {
            return null;
        }
        IType type = (IType)element;
        try {
            if (type.isAnonymous()) {
                return type;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public void run(ITextSelection selection) {
        try {
            this.run(SelectionConverter.getInputAsCompilationUnit(this.fEditor), selection.getOffset(), selection.getLength());
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.ConvertAnonymousToNestedAction_dialog_title, RefactoringMessages.NewTextRefactoringAction_exception);
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(this.fEditor != null && SelectionConverter.getInputAsCompilationUnit(this.fEditor) != null);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isConvertAnonymousAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    private void run(ICompilationUnit unit, int offset, int length) throws JavaModelException {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)unit)) {
            return;
        }
        RefactoringExecutionStarter.startConvertAnonymousRefactoring(unit, offset, length, this.getShell());
    }
}

