/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.search.ExceptionOccurrencesFinder;
import org.eclipse.wst.jsdt.internal.ui.search.FindOccurrencesEngine;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindExceptionOccurrencesAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;
    static /* synthetic */ Class class$0;

    public FindExceptionOccurrencesAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(FindExceptionOccurrencesAction.getEditorInput(editor) != null);
    }

    public FindExceptionOccurrencesAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindExceptionOccurrences_text);
        this.setToolTipText(ActionMessages.FindExceptionOccurrences_toolTip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_exception_occurrences");
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.getMember(selection) != null);
    }

    public final void run(ITextSelection ts) {
        IJavaElement input = FindExceptionOccurrencesAction.getEditorInput(this.fEditor);
        if (!ActionUtil.isProcessable(this.getShell(), input)) {
            return;
        }
        FindOccurrencesEngine engine = FindOccurrencesEngine.create(input, new ExceptionOccurrencesFinder());
        try {
            String result = engine.run(ts.getOffset(), ts.getLength());
            if (result != null) {
                FindExceptionOccurrencesAction.showMessage(this.getShell(), this.fEditor, result);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
    }

    private static IJavaElement getEditorInput(JavaEditor editor) {
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private static void showMessage(Shell shell, JavaEditor editor, String msg) {
        IEditorStatusLine statusLine;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)editor.getAdapter(clazz)) != null) {
            statusLine.setMessage(true, msg, null);
        }
        shell.getDisplay().beep();
    }

    private IMember getMember(IStructuredSelection selection) {
        return null;
    }
}

