/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSLine;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSScanner;
import org.eclipse.wst.jsdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.ListDialog;
import org.eclipse.wst.jsdt.internal.ui.refactoring.actions.RefactoringStarter;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.ExternalizeWizard;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaElementLabelProvider;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FindStringsToExternalizeAction
extends SelectionDispatchAction {
    private NonNLSElement[] fElements;

    public FindStringsToExternalizeAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FindStringsToExternalizeAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.find_strings_to_externalize_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(this.computeEnablementState(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    private boolean computeEnablementState(IStructuredSelection selection) throws JavaModelException {
        if (selection.isEmpty()) {
            return false;
        }
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IPackageFragmentRoot root;
            Object element = iter.next();
            if (!(element instanceof IJavaElement)) {
                return false;
            }
            IJavaElement javaElement = (IJavaElement)element;
            if (!javaElement.exists() || javaElement.isReadOnly()) {
                return false;
            }
            int elementType = javaElement.getElementType();
            if (elementType != 4 && elementType != 3 && elementType != 2) {
                return false;
            }
            if (elementType != 3 || !(root = (IPackageFragmentRoot)javaElement).isExternal() && !ReorgUtils.isClassFolder((IJavaElement)root)) continue;
            return false;
        }
        return true;
    }

    public void run(IStructuredSelection selection) {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, this.createRunnable(selection));
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.FindStringsToExternalizeAction_dialog_title, ActionMessages.FindStringsToExternalizeAction_error_message);
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        this.showResults();
    }

    private IRunnableWithProgress createRunnable(final IStructuredSelection selection) {
        return new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) throws InvocationTargetException {
                try {
                    FindStringsToExternalizeAction.this.fElements = FindStringsToExternalizeAction.this.doRun(selection, pm);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
    }

    private NonNLSElement[] doRun(IStructuredSelection selection, IProgressMonitor pm) throws CoreException {
        NonNLSElement[] nonNLSElementArray;
        List elements = FindStringsToExternalizeAction.getSelectedElementList(selection);
        if (elements == null || elements.isEmpty()) {
            return new NonNLSElement[0];
        }
        pm.beginTask(ActionMessages.FindStringsToExternalizeAction_find_strings, elements.size());
        try {
            ArrayList l = new ArrayList();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                IJavaElement element = (IJavaElement)iter.next();
                if (element.getElementType() == 4) {
                    l.addAll(this.analyze((IPackageFragment)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else if (element.getElementType() == 3) {
                    l.addAll(this.analyze((IPackageFragmentRoot)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                }
                if (element.getElementType() != 2) continue;
                l.addAll(this.analyze((IJavaProject)element, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
            }
            nonNLSElementArray = l.toArray(new NonNLSElement[l.size()]);
            Object var7_8 = null;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return nonNLSElementArray;
    }

    private void showResults() {
        if (this.noStrings()) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)this.getDialogTitle(), (String)ActionMessages.FindStringsToExternalizeAction_noStrings);
        } else {
            new NonNLSListDialog(this.getShell(), this.fElements, this.countStrings()).open();
        }
    }

    private boolean noStrings() {
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                if (this.fElements[i].count != 0) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    private List analyze(IPackageFragment pack, IProgressMonitor pm) throws CoreException {
        ArrayList<NonNLSElement> arrayList;
        block6: {
            if (pack != null) break block6;
            ArrayList arrayList2 = new ArrayList(0);
            Object var7_5 = null;
            pm.done();
            return arrayList2;
        }
        try {
            ICompilationUnit[] cus = pack.getCompilationUnits();
            pm.beginTask("", cus.length);
            pm.setTaskName(pack.getElementName());
            ArrayList<NonNLSElement> l = new ArrayList<NonNLSElement>(cus.length);
            int i = 0;
            while (i < cus.length) {
                pm.subTask(cus[i].getElementName());
                NonNLSElement element = this.analyze(cus[i]);
                if (element != null) {
                    l.add(element);
                }
                pm.worked(1);
                if (pm.isCanceled()) {
                    throw new OperationCanceledException();
                }
                ++i;
            }
            arrayList = l;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return arrayList;
    }

    private List analyze(IPackageFragmentRoot sourceFolder, IProgressMonitor pm) throws CoreException {
        ArrayList arrayList;
        try {
            IJavaElement[] children = sourceFolder.getChildren();
            pm.beginTask("", children.length);
            pm.setTaskName(sourceFolder.getElementName());
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < children.length) {
                IJavaElement iJavaElement = children[i];
                if (iJavaElement.getElementType() == 4) {
                    IPackageFragment pack = (IPackageFragment)iJavaElement;
                    if (!pack.isReadOnly()) {
                        result.addAll(this.analyze(pack, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                    } else {
                        pm.worked(1);
                    }
                } else {
                    pm.worked(1);
                }
                ++i;
            }
            arrayList = result;
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return arrayList;
    }

    private List analyze(IJavaProject project, IProgressMonitor pm) throws CoreException {
        ArrayList arrayList;
        try {
            IPackageFragment[] packs = project.getPackageFragments();
            pm.beginTask("", packs.length);
            ArrayList result = new ArrayList();
            int i = 0;
            while (i < packs.length) {
                if (!packs[i].isReadOnly()) {
                    result.addAll(this.analyze(packs[i], (IProgressMonitor)new SubProgressMonitor(pm, 1)));
                } else {
                    pm.worked(1);
                }
                ++i;
            }
            arrayList = result;
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return arrayList;
    }

    private int countStrings() {
        int found = 0;
        if (this.fElements != null) {
            int i = 0;
            while (i < this.fElements.length) {
                found += this.fElements[i].count;
                ++i;
            }
        }
        return found;
    }

    private NonNLSElement analyze(ICompilationUnit cu) throws CoreException {
        int count = this.countNonExternalizedStrings(cu);
        if (count == 0) {
            return null;
        }
        return new NonNLSElement(cu, count);
    }

    private int countNonExternalizedStrings(ICompilationUnit cu) throws CoreException {
        try {
            NLSLine[] lines = NLSScanner.scan(cu);
            int result = 0;
            int i = 0;
            while (i < lines.length) {
                result += this.countNonExternalizedStrings(lines[i]);
                ++i;
            }
            return result;
        }
        catch (InvalidInputException e) {
            throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 4, Messages.format(ActionMessages.FindStringsToExternalizeAction_error_cannotBeParsed, cu.getElementName()), (Throwable)e));
        }
    }

    private int countNonExternalizedStrings(NLSLine line) {
        int result = 0;
        NLSElement[] elements = line.getElements();
        int i = 0;
        while (i < elements.length) {
            if (!elements[i].hasTag()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    private static List getSelectedElementList(IStructuredSelection selection) {
        if (selection == null) {
            return null;
        }
        return selection.toList();
    }

    private String getDialogTitle() {
        return ActionMessages.FindStringsToExternalizeAction_dialog_title;
    }

    private static class NonNLSElement {
        ICompilationUnit cu;
        int count;

        NonNLSElement(ICompilationUnit cu, int count) {
            this.cu = cu;
            this.count = count;
        }
    }

    private static class NonNLSListDialog
    extends ListDialog {
        private static final int OPEN_BUTTON_ID = 1025;
        private Button fOpenButton;

        NonNLSListDialog(Shell parent, NonNLSElement[] input, int count) {
            super(parent);
            this.setInput(Arrays.asList(input));
            this.setTitle(ActionMessages.FindStringsToExternalizeAction_dialog_title);
            this.setMessage(Messages.format(ActionMessages.FindStringsToExternalizeAction_non_externalized, new Object[]{new Integer(count)}));
            this.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            this.setLabelProvider((ILabelProvider)NonNLSListDialog.createLabelProvider());
        }

        public void create() {
            this.setShellStyle(2288);
            super.create();
        }

        protected Point getInitialSize() {
            return this.getShell().computeSize(-1, -1, true);
        }

        protected Control createDialogArea(Composite parent) {
            Composite result = (Composite)super.createDialogArea(parent);
            this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(this){
                final /* synthetic */ NonNLSListDialog this$1;
                {
                    this.this$1 = nonNLSListDialog;
                }

                public void selectionChanged(SelectionChangedEvent event) {
                    if (NonNLSListDialog.access$0(this.this$1) != null) {
                        NonNLSListDialog.access$0(this.this$1).setEnabled(!this.this$1.getTableViewer().getSelection().isEmpty());
                    }
                }
            });
            this.getTableViewer().getTable().addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ NonNLSListDialog this$1;
                {
                    this.this$1 = nonNLSListDialog;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    NonNLSElement element = (NonNLSElement)e.item.getData();
                    NonNLSListDialog.access$1(this.this$1, element.cu);
                }
            });
            this.getTableViewer().getTable().setFocus();
            NonNLSListDialog.applyDialogFont((Control)result);
            return result;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.fOpenButton = this.createButton(parent, 1025, ActionMessages.FindStringsToExternalizeAction_button_label, true);
            this.fOpenButton.setEnabled(false);
            this.createButton(parent, 1, IDialogConstants.CLOSE_LABEL, false);
        }

        protected void buttonPressed(int buttonId) {
            IStructuredSelection ss;
            if (buttonId != 1025) {
                super.buttonPressed(buttonId);
                return;
            }
            ISelection s = this.getTableViewer().getSelection();
            if (s instanceof IStructuredSelection && (ss = (IStructuredSelection)s).getFirstElement() instanceof NonNLSElement) {
                this.openWizard(((NonNLSElement)ss.getFirstElement()).cu);
            }
        }

        private void openWizard(ICompilationUnit unit) {
            try {
                NLSRefactoring refactoring;
                if (unit != null && unit.exists() && (refactoring = NLSRefactoring.create(unit)) != null) {
                    new RefactoringStarter().activate(refactoring, new ExternalizeWizard(refactoring), this.getShell(), ActionMessages.ExternalizeStringsAction_dialog_title, 3);
                }
            }
            catch (JavaModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), ActionMessages.FindStringsToExternalizeAction_dialog_title, ActionMessages.FindStringsToExternalizeAction_error_message);
            }
        }

        private static LabelProvider createLabelProvider() {
            return new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT){

                public String getText(Object element) {
                    NonNLSElement nlsel = (NonNLSElement)element;
                    String elementName = nlsel.cu.getResource().getFullPath().toString();
                    return Messages.format(ActionMessages.FindStringsToExternalizeAction_foundStrings, new Object[]{new Integer(nlsel.count), elementName});
                }

                public Image getImage(Object element) {
                    return super.getImage(((NonNLSElement)element).cu);
                }
            };
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)newShell, "org.eclipse.wst.jsdt.ui.nonnls_dialog_context");
        }

        static /* synthetic */ Button access$0(NonNLSListDialog nonNLSListDialog) {
            return nonNLSListDialog.fOpenButton;
        }

        static /* synthetic */ void access$1(NonNLSListDialog nonNLSListDialog, ICompilationUnit iCompilationUnit) {
            nonNLSListDialog.openWizard(iCompilationUnit);
        }
    }
}

