/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.formatter.IFormattingStrategy;
import org.eclipse.jface.text.formatter.MultiPassContentFormatter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IJavaProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Resources;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.browsing.LogicalPackage;
import org.eclipse.wst.jsdt.internal.ui.dialogs.OptionalMessageDialog;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.text.java.JavaFormattingStrategy;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class FormatAllAction
extends SelectionDispatchAction {
    private DocumentRewriteSession fRewriteSession;

    public FormatAllAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.FormatAllAction_label);
        this.setToolTipText(ActionMessages.FormatAllAction_tooltip);
        this.setDescription(ActionMessages.FormatAllAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.format_all_action");
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(this.isEnabled(selection));
    }

    private ICompilationUnit[] getCompilationUnits(IStructuredSelection selection) {
        HashSet<IJavaElement> result = new HashSet<IJavaElement>();
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block16: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (!elem.exists()) break block16;
                        switch (elem.getElementType()) {
                            case 7: {
                                if (elem.getParent().getElementType() == 5) {
                                    result.add(elem.getParent());
                                    break;
                                }
                                break block16;
                            }
                            case 5: {
                                result.add(elem);
                                break;
                            }
                            case 4: {
                                this.collectCompilationUnits((IPackageFragment)elem, result);
                                break;
                            }
                            case 3: {
                                this.collectCompilationUnits((IPackageFragmentRoot)elem, result);
                                break;
                            }
                            case 2: {
                                IPackageFragmentRoot[] roots = ((IJavaProject)elem).getPackageFragmentRoots();
                                int k = 0;
                                while (k < roots.length) {
                                    this.collectCompilationUnits(roots[k], result);
                                    ++k;
                                }
                                break block1;
                            }
                        }
                        break block16;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        IPackageFragment[] packageFragments = ((LogicalPackage)((Object)selected[i])).getFragments();
                        int k = 0;
                        while (k < packageFragments.length) {
                            IPackageFragment pack = packageFragments[k];
                            if (pack.exists()) {
                                this.collectCompilationUnits(pack, result);
                            }
                            ++k;
                        }
                    }
                }
                catch (JavaModelException e) {
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return result.toArray(new ICompilationUnit[result.size()]);
    }

    private void collectCompilationUnits(IPackageFragment pack, Collection result) throws JavaModelException {
        result.addAll(Arrays.asList(pack.getCompilationUnits()));
    }

    private void collectCompilationUnits(IPackageFragmentRoot root, Collection result) throws JavaModelException {
        if (root.getKind() == 1) {
            IJavaElement[] children = root.getChildren();
            int i = 0;
            while (i < children.length) {
                this.collectCompilationUnits((IPackageFragment)children[i], result);
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isEnabled(IStructuredSelection selection) {
        Object[] selected = selection.toArray();
        int i = 0;
        while (i < selected.length) {
            block12: {
                try {
                    if (selected[i] instanceof IJavaElement) {
                        IJavaElement elem = (IJavaElement)selected[i];
                        if (elem.exists()) {
                            switch (elem.getElementType()) {
                                case 7: {
                                    return elem.getParent().getElementType() == 5;
                                }
                                case 5: {
                                    return true;
                                }
                                case 3: 
                                case 4: {
                                    IPackageFragmentRoot root = (IPackageFragmentRoot)elem.getAncestor(3);
                                    return root.getKind() == 1;
                                }
                                case 2: {
                                    return true;
                                }
                            }
                        }
                        break block12;
                    }
                    if (selected[i] instanceof LogicalPackage) {
                        return true;
                    }
                }
                catch (JavaModelException e) {
                    if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block12;
                    JavaPlugin.log(e);
                }
            }
            ++i;
        }
        return false;
    }

    public void run(ITextSelection selection) {
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.FormatAllAction_EmptySelection_title, (String)ActionMessages.FormatAllAction_EmptySelection_description);
            return;
        }
        try {
            if (cus.length == 1) {
                JavaUI.openInEditor((IJavaElement)cus[0]);
            } else {
                int returnCode = OptionalMessageDialog.open("FormatAll", this.getShell(), ActionMessages.FormatAllAction_noundo_title, null, ActionMessages.FormatAllAction_noundo_message, 4, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
                if (returnCode != 1025 && returnCode != 0) {
                    return;
                }
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
        this.runOnMultiple(cus);
    }

    private IResource[] getResources(ICompilationUnit[] cus) {
        IResource[] res = new IResource[cus.length];
        int i = 0;
        while (i < res.length) {
            res[i] = cus[i].getResource();
            ++i;
        }
        return res;
    }

    public void runOnMultiple(final ICompilationUnit[] cus) {
        try {
            final MultiStatus status = new MultiStatus("org.eclipse.wst.jsdt.ui", 0, ActionMessages.FormatAllAction_status_description, null);
            IStatus valEditStatus = Resources.makeCommittable(this.getResources(cus), (Object)this.getShell());
            if (valEditStatus.matches(8)) {
                return;
            }
            status.merge(valEditStatus);
            if (!status.matches(4)) {
                PlatformUI.getWorkbench().getProgressService().run(true, true, (IRunnableWithProgress)new WorkbenchRunnableAdapter(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor monitor) {
                        FormatAllAction.this.doRunOnMultiple(cus, status, monitor);
                    }
                }));
            }
            if (!status.isOK()) {
                String title = ActionMessages.FormatAllAction_multi_status_title;
                ErrorDialog.openError((Shell)this.getShell(), (String)title, null, (IStatus)status);
            }
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.FormatAllAction_error_title, ActionMessages.FormatAllAction_error_message);
        }
        catch (InterruptedException interruptedException) {}
    }

    private static Map getFomatterSettings(IJavaProject project) {
        return new HashMap(project.getOptions(true));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doFormat(IDocument document, Map options) {
        CommentFormattingContext context = new CommentFormattingContext();
        try {
            context.setProperty("formatting.context.preferences", options);
            context.setProperty("formatting.context.document", true);
            MultiPassContentFormatter formatter = new MultiPassContentFormatter("___java_partitioning", "__dftl_partition_content_type");
            formatter.setMasterStrategy((IFormattingStrategy)new JavaFormattingStrategy());
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_javadoc");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_singleline_comment");
            formatter.setSlaveStrategy((IFormattingStrategy)new CommentFormattingStrategy(), "__java_multiline_comment");
            try {
                this.startSequentialRewriteMode(document);
                formatter.format(document, (IFormattingContext)context);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.stopSequentialRewriteMode(document);
                throw throwable;
            }
            {
                Object var5_7 = null;
                this.stopSequentialRewriteMode(document);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            context.dispose();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        context.dispose();
    }

    private void startSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            this.fRewriteSession = extension.startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.startSequentialRewrite(false);
        }
    }

    private void stopSequentialRewriteMode(IDocument document) {
        if (document instanceof IDocumentExtension4) {
            IDocumentExtension4 extension = (IDocumentExtension4)document;
            extension.stopRewriteSession(this.fRewriteSession);
        } else if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.stopSequentialRewrite();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRunOnMultiple(ICompilationUnit[] cus, MultiStatus status, IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.setTaskName(ActionMessages.FormatAllAction_operation_description);
        monitor.beginTask("", cus.length * 4);
        try {
            Map lastOptions = null;
            IJavaProject lastProject = null;
            int i = 0;
            while (i < cus.length) {
                block15: {
                    IPath path;
                    block14: {
                        ICompilationUnit cu = cus[i];
                        path = cu.getPath();
                        if (lastProject == null || !lastProject.equals(cu.getJavaProject())) {
                            lastProject = cu.getJavaProject();
                            lastOptions = FormatAllAction.getFomatterSettings(lastProject);
                        }
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (!cu.getResource().getResourceAttributes().isReadOnly()) break block14;
                        String message = Messages.format(ActionMessages.FormatAllAction_read_only_skipped, path.toString());
                        status.add((IStatus)new Status(2, "org.eclipse.wst.jsdt.ui", 2, message, null));
                        break block15;
                    }
                    ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                    try {
                        Object var11_12;
                        try {
                            manager.connect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            monitor.subTask(path.makeRelative().toString());
                            ITextFileBuffer fileBuffer = manager.getTextFileBuffer(path, LocationKind.IFILE);
                            this.formatCompilationUnit(fileBuffer, lastOptions);
                            if (fileBuffer.isDirty() && !fileBuffer.isShared()) {
                                fileBuffer.commit((IProgressMonitor)new SubProgressMonitor(monitor, 2), false);
                            } else {
                                monitor.worked(2);
                            }
                        }
                        catch (Throwable throwable) {
                            var11_12 = null;
                            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                            throw throwable;
                        }
                        {
                            var11_12 = null;
                            manager.disconnect(path, LocationKind.IFILE, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        String message = Messages.format(ActionMessages.FormatAllAction_problem_accessing, new String[]{path.toString(), e.getLocalizedMessage()});
                        status.add((IStatus)new Status(2, "org.eclipse.wst.jsdt.ui", 2, message, (Throwable)e));
                    }
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var13_16 = null;
        }
        monitor.done();
    }

    private void formatCompilationUnit(final ITextFileBuffer fileBuffer, final Map options) {
        if (fileBuffer.isShared()) {
            this.getShell().getDisplay().syncExec(new Runnable(){

                public void run() {
                    FormatAllAction.this.doFormat(fileBuffer.getDocument(), options);
                }
            });
        } else {
            this.doFormat(fileBuffer.getDocument(), options);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private FormatAllAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new FormatAllAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }
}

