/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.IRewriteTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.wst.jsdt.core.ICompilationUnit;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.compiler.IProblem;
import org.eclipse.wst.jsdt.core.dom.CompilationUnit;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.wst.jsdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.wst.jsdt.internal.ui.dialogs.MultiElementListSelectionDialog;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.util.ElementValidator;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.TypeNameMatchLabelProvider;
import org.eclipse.wst.jsdt.ui.JavaUI;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class OrganizeImportsAction
extends SelectionDispatchAction {
    private static final OrganizeImportComparator ORGANIZE_IMPORT_COMPARATOR = new OrganizeImportComparator();
    private JavaEditor fEditor;
    private boolean fIsQueryShowing = false;
    private final MultiOrganizeImportAction fCleanUpDelegate;
    static /* synthetic */ Class class$0;

    public OrganizeImportsAction(IWorkbenchSite site) {
        super(site);
        this.fCleanUpDelegate = new MultiOrganizeImportAction(site);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.organize_imports_action_context");
    }

    public OrganizeImportsAction(JavaEditor editor) {
        super((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.fCleanUpDelegate = new MultiOrganizeImportAction(editor);
        this.setText(ActionMessages.OrganizeImportsAction_label);
        this.setToolTipText(ActionMessages.OrganizeImportsAction_tooltip);
        this.setDescription(ActionMessages.OrganizeImportsAction_description);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.organize_imports_action_context");
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void selectionChanged(ITextSelection selection) {
        this.fCleanUpDelegate.selectionChanged(selection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.fCleanUpDelegate.selectionChanged(selection);
        this.setEnabled(this.fCleanUpDelegate.isEnabled());
    }

    public void run(ITextSelection selection) {
        ICompilationUnit cu = OrganizeImportsAction.getCompilationUnit(this.fEditor);
        if (cu != null) {
            this.run(cu);
        }
    }

    private static ICompilationUnit getCompilationUnit(JavaEditor editor) {
        IJavaElement element = JavaUI.getEditorInputJavaElement(editor.getEditorInput());
        if (!(element instanceof ICompilationUnit)) {
            return null;
        }
        return (ICompilationUnit)element;
    }

    public void run(IStructuredSelection selection) {
        ICompilationUnit[] cus = this.fCleanUpDelegate.getCompilationUnits(selection);
        if (cus.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_EmptySelection_title, (String)ActionMessages.OrganizeImportsAction_EmptySelection_description);
        } else if (cus.length == 1) {
            this.run(cus[0]);
        } else {
            this.fCleanUpDelegate.run(selection);
        }
    }

    public void runOnMultiple(ICompilationUnit[] cus) {
        if (cus.length == 0) {
            return;
        }
        this.fCleanUpDelegate.run((IStructuredSelection)new StructuredSelection((Object[])cus));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(ICompilationUnit cu) {
        if (!ElementValidator.check((IJavaElement)cu, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, this.fEditor != null)) {
            return;
        }
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)cu)) {
            return;
        }
        IEditingSupport helper = this.createViewerHelper();
        try {
            IEditorPart editor;
            CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(cu.getJavaProject());
            if (this.fEditor == null && EditorUtility.isOpenInEditor(cu) == null && (editor = JavaUI.openInEditor((IJavaElement)cu)) instanceof JavaEditor) {
                this.fEditor = (JavaEditor)editor;
            }
            CompilationUnit astRoot = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)cu, ASTProvider.WAIT_ACTIVE_ONLY, null);
            OrganizeImportsOperation op = new OrganizeImportsOperation(cu, astRoot, settings.importIgnoreLowercase, !cu.isWorkingCopy(), true, this.createChooseImportQuery());
            IRewriteTarget target = null;
            if (this.fEditor != null) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.jface.text.IRewriteTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                if ((target = (IRewriteTarget)this.fEditor.getAdapter(clazz)) != null) {
                    target.beginCompoundChange();
                }
            }
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            IWorkbenchWindow context = this.getSite().getWorkbenchWindow();
            if (context == null) {
                context = progressService;
            }
            try {
                try {
                    this.registerHelper(helper);
                    progressService.runInUI((IRunnableContext)context, (IRunnableWithProgress)new WorkbenchRunnableAdapter(op, op.getScheduleRule()), op.getScheduleRule());
                    IProblem parseError = op.getParseError();
                    if (parseError != null) {
                        String message = Messages.format(ActionMessages.OrganizeImportsAction_single_error_parse, parseError.getMessage());
                        MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.OrganizeImportsAction_error_title, (String)message);
                        if (this.fEditor != null && parseError.getSourceStart() != -1) {
                            this.fEditor.selectAndReveal(parseError.getSourceStart(), parseError.getSourceEnd() - parseError.getSourceStart() + 1);
                        }
                    } else if (this.fEditor != null) {
                        this.setStatusBarMessage(this.getOrganizeInfo(op));
                    }
                }
                catch (InvocationTargetException e) {
                    ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                this.deregisterHelper(helper);
                if (target == null) throw throwable;
                target.endCompoundChange();
                throw throwable;
            }
            {
                Object var11_15 = null;
                this.deregisterHelper(helper);
                if (target == null) return;
                target.endCompoundChange();
                return;
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, this.getShell(), ActionMessages.OrganizeImportsAction_error_title, ActionMessages.OrganizeImportsAction_error_message);
        }
    }

    private String getOrganizeInfo(OrganizeImportsOperation op) {
        int nImportsAdded = op.getNumberOfImportsAdded();
        if (nImportsAdded >= 0) {
            return Messages.format(ActionMessages.OrganizeImportsAction_summary_added, String.valueOf(nImportsAdded));
        }
        return Messages.format(ActionMessages.OrganizeImportsAction_summary_removed, String.valueOf(-nImportsAdded));
    }

    private OrganizeImportsOperation.IChooseImportQuery createChooseImportQuery() {
        return new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                return OrganizeImportsAction.this.doChooseImports(openChoices, ranges);
            }
        };
    }

    private TypeNameMatch[] doChooseImports(TypeNameMatch[][] openChoices, final ISourceRange[] ranges) {
        ISelection sel = this.fEditor != null ? this.fEditor.getSelectionProvider().getSelection() : null;
        TypeNameMatch[] result = null;
        TypeNameMatchLabelProvider labelProvider = new TypeNameMatchLabelProvider(1);
        MultiElementListSelectionDialog dialog = new MultiElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider){

            protected void handleSelectionChanged() {
                super.handleSelectionChanged();
                OrganizeImportsAction.this.doListSelectionChanged(this.getCurrentPage(), ranges);
            }
        };
        this.fIsQueryShowing = true;
        dialog.setTitle(ActionMessages.OrganizeImportsAction_selectiondialog_title);
        dialog.setMessage(ActionMessages.OrganizeImportsAction_selectiondialog_message);
        dialog.setElements(openChoices);
        dialog.setComparator(ORGANIZE_IMPORT_COMPARATOR);
        if (dialog.open() == 0) {
            Object[] res = dialog.getResult();
            result = new TypeNameMatch[res.length];
            int i = 0;
            while (i < res.length) {
                Object[] array = (Object[])res[i];
                if (array.length > 0) {
                    result[i] = (TypeNameMatch)array[0];
                    QualifiedTypeNameHistory.remember(result[i].getFullyQualifiedName());
                }
                ++i;
            }
        }
        if (sel instanceof ITextSelection) {
            ITextSelection textSelection = (ITextSelection)sel;
            this.fEditor.selectAndReveal(textSelection.getOffset(), textSelection.getLength());
        }
        this.fIsQueryShowing = false;
        return result;
    }

    private void doListSelectionChanged(int page, ISourceRange[] ranges) {
        if (this.fEditor != null && ranges != null && page >= 0 && page < ranges.length) {
            ISourceRange range = ranges[page];
            this.fEditor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    private void setStatusBarMessage(String message) {
        IStatusLineManager manager = this.fEditor.getEditorSite().getActionBars().getStatusLineManager();
        manager.setMessage(message);
    }

    private IEditingSupport createViewerHelper() {
        return new IEditingSupport(){

            public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
                return true;
            }

            public boolean ownsFocusShell() {
                return OrganizeImportsAction.this.fIsQueryShowing;
            }
        };
    }

    private void registerHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.register(helper);
        }
    }

    private void deregisterHelper(IEditingSupport helper) {
        if (this.fEditor == null) {
            return;
        }
        ISourceViewer viewer = this.fEditor.getViewer();
        if (viewer instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister(helper);
        }
    }

    public static class ObjectDelegate
    implements IObjectActionDelegate {
        private OrganizeImportsAction fAction;

        public void setActivePart(IAction action, IWorkbenchPart targetPart) {
            this.fAction = new OrganizeImportsAction((IWorkbenchSite)targetPart.getSite());
        }

        public void run(IAction action) {
            this.fAction.run();
        }

        public void selectionChanged(IAction action, ISelection selection) {
            if (this.fAction == null) {
                action.setEnabled(false);
            }
        }
    }

    private static final class OrganizeImportComparator
    implements Comparator {
        private OrganizeImportComparator() {
        }

        public int compare(Object o1, Object o2) {
            int pos2;
            if (((String)o1).equals(o2)) {
                return 0;
            }
            QualifiedTypeNameHistory history = QualifiedTypeNameHistory.getDefault();
            int pos1 = history.getPosition(o1);
            if (pos1 == (pos2 = history.getPosition(o2))) {
                return Collator.getInstance().compare(o1, o2);
            }
            if (pos1 > pos2) {
                return -1;
            }
            return 1;
        }
    }
}

