/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.IMethod;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class ReplaceInvocationsAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public ReplaceInvocationsAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(true);
    }

    public ReplaceInvocationsAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.ReplaceInvocationsAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.replace_invocations_action");
    }

    public void selectionChanged(IStructuredSelection selection) {
        block2: {
            try {
                this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            }
            catch (JavaModelException e) {
                if (!JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) break block2;
                JavaPlugin.log(e);
            }
        }
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
        }
        catch (JavaModelException javaModelException) {
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            Assert.isTrue((boolean)RefactoringAvailabilityTester.isReplaceInvocationsAvailable(selection));
            Object first = selection.getFirstElement();
            Assert.isTrue((boolean)(first instanceof IMethod));
            IMethod method = (IMethod)first;
            if (ActionUtil.isProcessable(this.getShell(), (IJavaElement)method)) {
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(method, this.getShell());
            }
        }
        catch (CoreException e) {
            this.handleException(e);
        }
    }

    private void handleException(CoreException e) {
        ExceptionHandler.handle(e, RefactoringMessages.ReplaceInvocationsAction_dialog_title, RefactoringMessages.ReplaceInvocationsAction_unavailable);
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement editorInput = SelectionConverter.getInput(this.fEditor);
            if (editorInput instanceof ITypeRoot && ActionUtil.isProcessable(this.getShell(), editorInput)) {
                ITypeRoot typeRoot = (ITypeRoot)editorInput;
                RefactoringExecutionStarter.startReplaceInvocationsRefactoring(typeRoot, selection.getOffset(), selection.getLength(), this.getShell());
            }
        }
        catch (JavaModelException e) {
            this.handleException((CoreException)((Object)e));
        }
    }
}

