/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaElement;
import org.eclipse.wst.jsdt.core.JavaModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringAvailabilityTester;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringExecutionStarter;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionMessages;
import org.eclipse.wst.jsdt.internal.ui.actions.ActionUtil;
import org.eclipse.wst.jsdt.internal.ui.actions.SelectionConverter;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.ui.actions.SelectionDispatchAction;

public class SelfEncapsulateFieldAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public SelfEncapsulateFieldAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.SelfEncapsulateFieldAction_label);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.self_encapsulate_action");
    }

    public SelfEncapsulateFieldAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
        this.setEnabled(true);
    }

    public void selectionChanged(JavaTextSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(ITextSelection selection) {
        try {
            IJavaElement[] elements = SelectionConverter.codeResolve(this.fEditor);
            if (elements.length != 1 || !(elements[0] instanceof IField)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            IField field = (IField)elements[0];
            if (!RefactoringAvailabilityTester.isSelfEncapsulateAvailable(field)) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)ActionMessages.SelfEncapsulateFieldAction_dialog_title, (String)ActionMessages.SelfEncapsulateFieldAction_dialog_unavailable);
                return;
            }
            this.run(field);
        }
        catch (JavaModelException exception) {
            JavaPlugin.log(exception);
            return;
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        try {
            this.setEnabled(RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection));
        }
        catch (JavaModelException e) {
            if (JavaModelUtil.isExceptionToBeLogged((CoreException)((Object)e))) {
                JavaPlugin.log(e);
            }
            this.setEnabled(false);
        }
    }

    public void run(IStructuredSelection selection) {
        try {
            if (RefactoringAvailabilityTester.isSelfEncapsulateAvailable(selection)) {
                this.run((IField)selection.getFirstElement());
            }
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.OpenRefactoringWizardAction_refactoring, RefactoringMessages.OpenRefactoringWizardAction_exception);
        }
    }

    public void run(IField field) {
        if (!ActionUtil.isEditable(this.fEditor, this.getShell(), (IJavaElement)field)) {
            return;
        }
        RefactoringExecutionStarter.startSelfEncapsulateRefactoring(field, this.getShell());
    }
}

