/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.Table;

public class LocaTable
implements Table {
    private byte[] buf = null;
    private int[] offsets = null;
    private short factor = 0;

    protected LocaTable(DirectoryEntry directoryEntry, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.seek(directoryEntry.getOffset());
        this.buf = new byte[directoryEntry.getLength()];
        randomAccessFile.read(this.buf);
    }

    public void init(int n, boolean bl) {
        if (this.buf == null) {
            return;
        }
        this.offsets = new int[n + 1];
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.buf);
        if (bl) {
            this.factor = (short)2;
            int n2 = 0;
            while (n2 <= n) {
                this.offsets[n2] = byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
                ++n2;
            }
        } else {
            this.factor = 1;
            int n3 = 0;
            while (n3 <= n) {
                this.offsets[n3] = byteArrayInputStream.read() << 24 | byteArrayInputStream.read() << 16 | byteArrayInputStream.read() << 8 | byteArrayInputStream.read();
                ++n3;
            }
        }
        this.buf = null;
    }

    public int getOffset(int n) {
        if (this.offsets == null) {
            return 0;
        }
        return this.offsets[n] * this.factor;
    }

    public int getType() {
        return 1819239265;
    }
}

