/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.editparts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;

public class GridLayer
extends FreeformLayer {
    protected int gridX = 12;
    protected int gridY = 12;
    protected Point origin = new Point();

    public GridLayer() {
        this.setForegroundColor(ColorConstants.lightGray);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return new Dimension();
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        this.paintGrid(graphics);
    }

    protected void paintGrid(Graphics g) {
        FigureUtilities.paintGrid((Graphics)g, (IFigure)this, (Point)this.origin, (int)this.gridX, (int)this.gridY);
    }

    public void setOrigin(Point p) {
        if (p == null) {
            p = new Point();
        }
        if (!this.origin.equals((Object)p)) {
            this.origin = p;
            this.repaint();
        }
    }

    public void setSpacing(Dimension spacing) {
        if (spacing == null) {
            spacing = new Dimension(12, 12);
        }
        if (!spacing.equals(this.gridX, this.gridY)) {
            this.gridX = spacing.width != 0 ? spacing.width : this.gridX;
            this.gridY = spacing.height != 0 ? spacing.height : this.gridY;
            this.repaint();
        }
    }
}

