/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import java.beans.PropertyChangeEvent;
import java.util.Iterator;
import org.eclipse.draw2d.ActionEvent;
import org.eclipse.draw2d.ActionListener;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ChangeEvent;
import org.eclipse.draw2d.ChangeListener;
import org.eclipse.draw2d.Clickable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.internal.ui.palette.editparts.RolloverArrow;
import org.eclipse.gef.internal.ui.palette.editparts.StackMenuListener;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteListener;
import org.eclipse.gef.palette.PaletteStack;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.actions.SetActivePaletteToolAction;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Menu;

public class PaletteStackEditPart
extends PaletteEditPart {
    private static final Dimension EMPTY_DIMENSION = new Dimension(0, 0);
    private ChangeListener clickableListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            if (event.getPropertyName().equals("mouseover")) {
                PaletteStackEditPart.this.arrowFigure.getModel().setMouseOver(PaletteStackEditPart.this.activeFigure.getModel().isMouseOver());
            } else if (event.getPropertyName().equals("armed")) {
                PaletteStackEditPart.this.arrowFigure.getModel().setArmed(PaletteStackEditPart.this.activeFigure.getModel().isArmed());
            }
        }
    };
    private ChangeListener clickableArrowListener = new ChangeListener(){

        public void handleStateChanged(ChangeEvent event) {
            if (event.getPropertyName().equals("mouseover")) {
                PaletteStackEditPart.this.activeFigure.getModel().setMouseOver(PaletteStackEditPart.this.arrowFigure.getModel().isMouseOver());
            }
            if (event.getPropertyName().equals("armed")) {
                PaletteStackEditPart.this.activeFigure.getModel().setArmed(PaletteStackEditPart.this.arrowFigure.getModel().isArmed());
            }
        }
    };
    private ActionListener actionListener = new ActionListener(){

        public void actionPerformed(ActionEvent event) {
            PaletteStackEditPart.this.openMenu();
        }
    };
    private PaletteListener paletteListener = new PaletteListener(){

        public void activeToolChanged(PaletteViewer palette, ToolEntry tool) {
            if (PaletteStackEditPart.this.getStack().getChildren().contains(tool)) {
                if (!PaletteStackEditPart.this.arrowFigure.getModel().isSelected()) {
                    PaletteStackEditPart.this.arrowFigure.getModel().setSelected(true);
                }
                if (!PaletteStackEditPart.this.getStack().getActiveEntry().equals(tool)) {
                    PaletteStackEditPart.this.getStack().setActiveEntry(tool);
                }
            } else {
                PaletteStackEditPart.this.arrowFigure.getModel().setSelected(false);
            }
        }
    };
    private Clickable activeFigure;
    private RolloverArrow arrowFigure;
    private Figure contentsFigure;
    private Menu menu;

    public PaletteStackEditPart(PaletteStack model) {
        super(model);
    }

    public void activate() {
        this.checkActiveEntrySync();
        this.getPaletteViewer().addPaletteListener(this.paletteListener);
        super.activate();
    }

    private void activeEntryChanged(Object oldValue, Object newValue) {
        GraphicalEditPart part = null;
        Clickable clickable = null;
        if (newValue != null) {
            part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(newValue);
            clickable = (Clickable)part.getFigure();
            clickable.setVisible(true);
            clickable.addChangeListener(this.clickableListener);
            this.activeFigure = clickable;
        }
        if (oldValue != null && (part = (GraphicalEditPart)this.getViewer().getEditPartRegistry().get(oldValue)) != null) {
            clickable = (Clickable)part.getFigure();
            clickable.setVisible(false);
            clickable.removeChangeListener(this.clickableListener);
        }
    }

    private void checkActiveEntrySync() {
        if (this.activeFigure == null) {
            this.activeEntryChanged(null, this.getStack().getActiveEntry());
        }
    }

    public IFigure createFigure() {
        Figure figure = new Figure(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                if (PaletteStackEditPart.this.getChildren().isEmpty()) {
                    return EMPTY_DIMENSION;
                }
                return super.getPreferredSize(wHint, hHint);
            }

            public void paintBorder(Graphics graphics) {
                int layoutMode = PaletteStackEditPart.this.getPreferenceSource().getLayoutSetting();
                if (layoutMode == 0 || layoutMode == 3) {
                    return;
                }
                Rectangle rect = this.getBounds().getCopy();
                graphics.translate(this.getLocation());
                graphics.setBackgroundColor(ColorConstants.listForeground);
                int[] points = new int[]{rect.width, rect.height - 5, rect.width, rect.height, rect.width - 5, rect.height};
                graphics.fillPolygon(points);
                graphics.translate(this.getLocation().getNegated());
            }
        };
        figure.setLayoutManager((LayoutManager)new BorderLayout());
        this.contentsFigure = new Figure();
        StackLayout stackLayout = new StackLayout();
        stackLayout.setObserveVisibility(true);
        this.contentsFigure.setLayoutManager((LayoutManager)stackLayout);
        figure.add((IFigure)this.contentsFigure, (Object)BorderLayout.CENTER);
        this.arrowFigure = new RolloverArrow();
        this.arrowFigure.addChangeListener(this.clickableArrowListener);
        this.arrowFigure.addActionListener(this.actionListener);
        int layoutMode = this.getPreferenceSource().getLayoutSetting();
        if (layoutMode == 0 || layoutMode == 3) {
            figure.add((IFigure)this.arrowFigure, (Object)BorderLayout.RIGHT);
        }
        return figure;
    }

    public void deactivate() {
        if (this.activeFigure != null) {
            this.activeFigure.removeChangeListener(this.clickableListener);
        }
        this.arrowFigure.removeActionListener(this.actionListener);
        this.arrowFigure.removeChangeListener(this.clickableArrowListener);
        this.getPaletteViewer().removePaletteListener(this.paletteListener);
        super.deactivate();
    }

    public void eraseTargetFeedback(Request request) {
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            PaletteEditPart part = (PaletteEditPart)children.next();
            part.eraseTargetFeedback(request);
        }
        super.eraseTargetFeedback(request);
    }

    public IFigure getContentPane() {
        return this.contentsFigure;
    }

    private PaletteStack getStack() {
        return (PaletteStack)this.getModel();
    }

    public void openMenu() {
        MenuManager menuManager = new MenuManager();
        Iterator children = this.getChildren().iterator();
        PaletteEditPart part = null;
        PaletteEntry entry = null;
        while (children.hasNext()) {
            part = (PaletteEditPart)children.next();
            entry = (PaletteEntry)part.getModel();
            menuManager.add((IAction)new SetActivePaletteToolAction(this.getPaletteViewer(), entry.getLabel(), entry.getSmallIcon(), this.getStack().getActiveEntry().equals(entry), (ToolEntry)entry));
        }
        this.menu = menuManager.createContextMenu(this.getPaletteViewer().getControl());
        Rectangle figureBounds = this.getFigure().getBounds().getCopy();
        this.getFigure().translateToAbsolute((Translatable)figureBounds);
        Point menuLocation = this.getPaletteViewer().getControl().toDisplay(figureBounds.getBottomLeft().x, figureBounds.getBottomLeft().y);
        this.arrowFigure.getModel().setMouseOver(false);
        this.eraseTargetFeedback(new Request("selection"));
        this.menu.setLocation(menuLocation);
        this.menu.addMenuListener((MenuListener)new StackMenuListener(this.menu, this.getViewer().getControl().getDisplay()));
        this.menu.setVisible(true);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("Active Entry")) {
            this.activeEntryChanged(event.getOldValue(), event.getNewValue());
        } else {
            super.propertyChange(event);
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            PaletteEditPart editPart = (PaletteEditPart)children.next();
            if (editPart.getFigure().equals(this.activeFigure)) continue;
            editPart.getFigure().setVisible(false);
        }
    }

    protected void refreshVisuals() {
        int layoutMode = this.getPreferenceSource().getLayoutSetting();
        if (layoutMode == 0 || layoutMode == 3) {
            if (!this.getFigure().getChildren().contains((Object)this.arrowFigure)) {
                this.getFigure().add((IFigure)this.arrowFigure, (Object)BorderLayout.RIGHT);
            }
        } else if (this.getFigure().getChildren().contains((Object)this.arrowFigure)) {
            this.getFigure().remove((IFigure)this.arrowFigure);
        }
    }

    public void showTargetFeedback(Request request) {
        if (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
            return;
        }
        Iterator children = this.getChildren().iterator();
        while (children.hasNext()) {
            PaletteEditPart part = (PaletteEditPart)children.next();
            part.showTargetFeedback(request);
        }
        super.showTargetFeedback(request);
    }
}

