/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.internal.ui.palette.editparts;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.internal.ui.palette.editparts.DetailedLabelFigure;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteTemplateEntry;
import org.eclipse.gef.ui.palette.editparts.PaletteEditPart;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;

public class TemplateEditPart
extends PaletteEditPart {
    private static final String SELECTION_STATE = "selection";
    private static final Border BORDER = new MarginBorder(1, 1, 1, 2);
    private static final Border COLUMNS_BORDER = new MarginBorder(2, 1, 3, 2);

    public TemplateEditPart(PaletteTemplateEntry entry) {
        super(entry);
    }

    protected AccessibleEditPart createAccessible() {
        return new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(this){

            public void getDescription(AccessibleEvent e) {
                e.result = TemplateEditPart.this.getTemplateEntry().getDescription();
            }

            public void getName(AccessibleEvent e) {
                e.result = TemplateEditPart.this.getTemplateEntry().getLabel();
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 34;
            }
        };
    }

    public IFigure createFigure() {
        DetailedLabelFigure fig = new DetailedLabelFigure(){

            public IFigure getToolTip() {
                return TemplateEditPart.this.createToolTip();
            }
        };
        fig.setRequestFocusEnabled(true);
        return fig;
    }

    public void deactivate() {
        ((DetailedLabelFigure)this.getFigure()).dispose();
        super.deactivate();
    }

    public DragTracker getDragTracker(Request request) {
        return new PaletteEditPart.SingleSelectionTracker(this){

            protected boolean handleButtonDown(int button) {
                TemplateEditPart.this.getFigure().requestFocus();
                return super.handleButtonDown(button);
            }
        };
    }

    private PaletteTemplateEntry getTemplateEntry() {
        return (PaletteTemplateEntry)this.getModel();
    }

    protected String getToolTipText() {
        String result = null;
        if (this.getPreferenceSource().getLayoutSetting() != 3) {
            result = super.getToolTipText();
        }
        return result;
    }

    protected boolean nameNeededInToolTip() {
        DetailedLabelFigure label = (DetailedLabelFigure)this.getFigure();
        return label.isNameTruncated() || super.nameNeededInToolTip();
    }

    protected void refreshVisuals() {
        DetailedLabelFigure fig = (DetailedLabelFigure)this.getFigure();
        PaletteEntry entry = this.getPaletteEntry();
        fig.setName(entry.getLabel());
        fig.setDescription(entry.getDescription());
        if (this.getPreferenceSource().useLargeIcons()) {
            this.setImageDescriptor(entry.getLargeIcon());
        } else {
            this.setImageDescriptor(entry.getSmallIcon());
        }
        int layoutMode = this.getPreferenceSource().getLayoutSetting();
        fig.setLayoutMode(layoutMode);
        if (layoutMode == 1 || layoutMode == 3) {
            fig.setBorder(COLUMNS_BORDER);
        } else {
            fig.setBorder(BORDER);
        }
        super.refreshVisuals();
    }

    public void restoreState(IMemento memento) {
        this.setSelected(memento.getInteger(SELECTION_STATE));
        super.restoreState(memento);
    }

    public void saveState(IMemento memento) {
        memento.putInteger(SELECTION_STATE, this.getSelected());
        super.saveState(memento);
    }

    protected void setImageInFigure(Image image) {
        DetailedLabelFigure fig = (DetailedLabelFigure)this.getFigure();
        fig.setImage(image);
    }

    public void setSelected(int value) {
        super.setSelected(value);
        DetailedLabelFigure label = (DetailedLabelFigure)this.getFigure();
        if (value == 2) {
            label.requestFocus();
            label.setSelected(true);
        } else {
            label.setSelected(false);
        }
    }
}

