/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.tools;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.MouseWheelHandler;
import org.eclipse.gef.RequestConstants;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackListener;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.util.FlagSupport;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Scrollable;

public abstract class AbstractTool
extends FlagSupport
implements Tool,
RequestConstants {
    public static final Object PROPERTY_UNLOAD_WHEN_FINISHED = "unloadWhenFinished";
    private static final int DRAG_THRESHOLD = 5;
    private static final int FLAG_ACTIVE = 8;
    private static final int FLAG_HOVER = 2;
    private static final int FLAG_PAST_THRESHOLD = 1;
    private static final int FLAG_UNLOAD = 4;
    protected static final int MAX_FLAG = 8;
    protected static final int MAX_STATE = 32;
    protected static final int MOUSE_BUTTON1 = 524288;
    protected static final int MOUSE_BUTTON2 = 0x100000;
    protected static final int MOUSE_BUTTON3 = 0x200000;
    protected static final int MOUSE_BUTTON_ANY = SWT.BUTTON_MASK;
    protected static final int STATE_ACCESSIBLE_DRAG = 16;
    protected static final int STATE_ACCESSIBLE_DRAG_IN_PROGRESS = 32;
    protected static final int STATE_DRAG = 2;
    protected static final int STATE_DRAG_IN_PROGRESS = 4;
    protected static final int STATE_INITIAL = 1;
    protected static final int STATE_INVALID = 8;
    protected static final int STATE_TERMINAL = 0x40000000;
    static final int MODIFIER_NO_SNAPPING = SWT.getPlatform().equals("carbon") ? 262144 : 65536;
    private long accessibleBegin;
    private int accessibleStep;
    private Command command;
    private CommandStackListener commandStackListener;
    private Input current;
    private EditPartViewer currentViewer;
    private Cursor defaultCursor;
    private Cursor disabledCursor;
    private EditDomain domain;
    private List operationSet;
    private int startX;
    private int startY;
    private int state;

    public AbstractTool() {
        this.setFlag(4, true);
        this.commandStackListener = new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                AbstractTool.this.handleCommandStackChanged();
            }
        };
    }

    boolean acceptAbort(KeyEvent e) {
        return e.character == '\u001b';
    }

    boolean acceptArrowKey(KeyEvent e) {
        int key = e.keyCode;
        if (!this.isInState(49)) {
            return false;
        }
        return key == 0x1000001 || key == 0x1000004 || key == 0x1000002 || key == 0x1000003;
    }

    boolean acceptDragCommit(KeyEvent e) {
        return this.isInState(32) && e.character == '\r';
    }

    int accGetStep() {
        return this.accessibleStep;
    }

    void accStepIncrement() {
        if (this.accessibleBegin == -1L) {
            this.accessibleBegin = new Date().getTime();
            this.accessibleStep = 1;
        } else {
            this.accessibleStep = 4;
            long elapsed = new Date().getTime() - this.accessibleBegin;
            if (elapsed > 1000L) {
                this.accessibleStep = Math.min(16, (int)(elapsed / 150L));
            }
        }
    }

    void accStepReset() {
        this.accessibleBegin = -1L;
    }

    public void activate() {
        this.resetFlags();
        this.accessibleBegin = -1L;
        this.getCurrentInput().verifyMouseButtons = true;
        this.setState(1);
        this.setFlag(8, true);
        this.getDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
    }

    protected void addFeedback(IFigure figure) {
        LayerManager lm = (LayerManager)this.getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
        if (lm == null) {
            return;
        }
        lm.getLayer("Feedback Layer").add(figure);
    }

    protected void applyProperty(Object key, Object value) {
        if (PROPERTY_UNLOAD_WHEN_FINISHED.equals(key)) {
            if (value instanceof Boolean) {
                this.setUnloadWhenFinished((Boolean)value);
            }
            return;
        }
        if (!(key instanceof String)) {
            return;
        }
        try {
            PropertyDescriptor[] descriptors = Introspector.getBeanInfo(this.getClass(), 3).getPropertyDescriptors();
            PropertyDescriptor property = null;
            int i = 0;
            while (i < descriptors.length) {
                if (descriptors[i].getName().equals(key)) {
                    property = descriptors[i];
                    break;
                }
                ++i;
            }
            if (property != null) {
                Method setter = property.getWriteMethod();
                setter.invoke((Object)this, value);
            }
        }
        catch (IntrospectionException introspectionException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SecurityException securityException) {}
    }

    protected Cursor calculateCursor() {
        if (this.isInState(0x40000000)) {
            return null;
        }
        Command command = this.getCurrentCommand();
        if (command == null || !command.canExecute()) {
            return this.getDisabledCursor();
        }
        return this.getDefaultCursor();
    }

    public void commitDrag() {
    }

    protected List createOperationSet() {
        return new ArrayList(this.getCurrentViewer().getSelectedEditParts());
    }

    public void deactivate() {
        this.setFlag(8, false);
        this.setViewer(null);
        this.setCurrentCommand(null);
        this.setState(0x40000000);
        this.operationSet = null;
        this.current = null;
        this.getDomain().getCommandStack().removeCommandStackListener(this.commandStackListener);
    }

    protected void debug(String message) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void executeCommand(Command command) {
        this.getDomain().getCommandStack().removeCommandStackListener(this.commandStackListener);
        try {
            this.getDomain().getCommandStack().execute(command);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.getDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.getDomain().getCommandStack().addCommandStackListener(this.commandStackListener);
            return;
        }
    }

    protected void executeCurrentCommand() {
        Command curCommand = this.getCurrentCommand();
        if (curCommand != null && curCommand.canExecute()) {
            this.executeCommand(curCommand);
        }
        this.setCurrentCommand(null);
    }

    public void focusGained(FocusEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.handleFocusGained();
    }

    public void focusLost(FocusEvent event, EditPartViewer viewer) {
        this.setViewer(viewer);
        this.handleFocusLost();
    }

    protected Command getCommand() {
        return UnexecutableCommand.INSTANCE;
    }

    protected abstract String getCommandName();

    protected Command getCurrentCommand() {
        return this.command;
    }

    protected Input getCurrentInput() {
        if (this.current == null) {
            this.current = new Input();
        }
        return this.current;
    }

    protected EditPartViewer getCurrentViewer() {
        return this.currentViewer;
    }

    protected String getDebugName() {
        return this.getClass().getName();
    }

    protected String getDebugNameForState(int state) {
        switch (state) {
            case 1: {
                return "Initial State";
            }
            case 2: {
                return "Drag State";
            }
            case 4: {
                return "Drag In Progress State";
            }
            case 8: {
                return "Invalid State";
            }
            case 0x40000000: {
                return "Terminal State";
            }
            case 16: {
                return "Accessible Drag";
            }
            case 32: {
                return "Accessible Drag In Progress";
            }
        }
        return "Unknown state:";
    }

    protected Cursor getDefaultCursor() {
        return this.defaultCursor;
    }

    protected Cursor getDisabledCursor() {
        if (this.disabledCursor != null) {
            return this.disabledCursor;
        }
        return this.getDefaultCursor();
    }

    protected EditDomain getDomain() {
        return this.domain;
    }

    protected Dimension getDragMoveDelta() {
        return this.getLocation().getDifference(this.getStartLocation());
    }

    protected Point getLocation() {
        return new Point(this.getCurrentInput().getMouseLocation());
    }

    protected List getOperationSet() {
        if (this.operationSet == null) {
            this.operationSet = this.createOperationSet();
        }
        return this.operationSet;
    }

    protected Point getStartLocation() {
        return new Point(this.startX, this.startY);
    }

    protected int getState() {
        return this.state;
    }

    protected boolean handleButtonDown(int button) {
        return false;
    }

    protected boolean handleButtonUp(int button) {
        return false;
    }

    protected boolean handleCommandStackChanged() {
        if (!this.isInState(1)) {
            this.setState(8);
            this.handleInvalidInput();
            return true;
        }
        return false;
    }

    protected boolean handleDoubleClick(int button) {
        return false;
    }

    protected boolean handleDrag() {
        return false;
    }

    protected boolean handleDragInProgress() {
        return false;
    }

    protected boolean handleDragStarted() {
        return false;
    }

    protected void handleFinished() {
        if (this.unloadWhenFinished()) {
            this.getDomain().loadDefaultTool();
        } else {
            this.reactivate();
        }
    }

    protected boolean handleFocusGained() {
        return false;
    }

    protected boolean handleFocusLost() {
        return false;
    }

    protected boolean handleHover() {
        return false;
    }

    protected boolean handleInvalidInput() {
        return false;
    }

    protected boolean handleKeyDown(KeyEvent e) {
        if (this.acceptAbort(e)) {
            this.getDomain().loadDefaultTool();
            return true;
        }
        return false;
    }

    protected void handleKeyTraversed(TraverseEvent event) {
    }

    protected boolean handleKeyUp(KeyEvent e) {
        return false;
    }

    protected boolean handleMove() {
        return false;
    }

    protected boolean handleNativeDragFinished(DragSourceEvent event) {
        return false;
    }

    protected boolean handleNativeDragStarted(DragSourceEvent event) {
        return false;
    }

    protected boolean handleViewerEntered() {
        return false;
    }

    protected boolean handleViewerExited() {
        return false;
    }

    protected boolean isActive() {
        return this.getFlag(8);
    }

    boolean isCurrentViewerMirrored() {
        return (this.getCurrentViewer().getControl().getStyle() & 0x8000000) != 0;
    }

    protected boolean isHoverActive() {
        return this.getFlag(2);
    }

    boolean isInDragInProgress() {
        return this.isInState(36);
    }

    private boolean isInputSynched(MouseEvent event) {
        Input input = this.getCurrentInput();
        return input.isMouseButtonDown(1) == ((event.stateMask & 0x80000) != 0) && input.isMouseButtonDown(2) == ((event.stateMask & 0x100000) != 0) && input.isMouseButtonDown(3) == ((event.stateMask & 0x200000) != 0) && input.isMouseButtonDown(4) == ((event.stateMask & 0x800000) != 0) && input.isMouseButtonDown(5) == ((event.stateMask & 0x2000000) != 0);
    }

    protected boolean isInState(int state) {
        return (this.getState() & state) != 0;
    }

    protected boolean isViewerImportant(EditPartViewer viewer) {
        return true;
    }

    public void keyDown(KeyEvent evt, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(evt);
        this.handleKeyDown(evt);
    }

    public void keyTraversed(TraverseEvent event, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput((KeyEvent)event);
        this.handleKeyTraversed(event);
    }

    public void keyUp(KeyEvent evt, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(evt);
        this.handleKeyUp(evt);
    }

    public void mouseDoubleClick(MouseEvent me, EditPartViewer viewer) {
        if (me.button > 5 || !this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(me);
        this.handleDoubleClick(me.button);
    }

    public void mouseDown(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(me);
        this.getCurrentInput().setMouseButton(me.button, true);
        this.startX = me.x;
        this.startY = me.y;
        this.handleButtonDown(me.button);
    }

    public void mouseDrag(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        boolean wasDragging = this.movedPastThreshold();
        this.getCurrentInput().setInput(me);
        this.handleDrag();
        if (this.movedPastThreshold()) {
            if (!wasDragging) {
                this.handleDragStarted();
            }
            this.handleDragInProgress();
        }
    }

    public void mouseHover(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(me);
        this.handleHover();
    }

    public void mouseMove(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        if (!this.isInputSynched(me)) {
            boolean b1 = this.getCurrentInput().isMouseButtonDown(1);
            boolean b2 = this.getCurrentInput().isMouseButtonDown(2);
            boolean b3 = this.getCurrentInput().isMouseButtonDown(3);
            boolean b4 = this.getCurrentInput().isMouseButtonDown(4);
            boolean b5 = this.getCurrentInput().isMouseButtonDown(5);
            this.getCurrentInput().verifyMouseButtons = true;
            this.getCurrentInput().setInput(me);
            if (b1) {
                this.handleButtonUp(1);
            }
            if (b2) {
                this.handleButtonUp(2);
            }
            if (b3) {
                this.handleButtonUp(3);
            }
            if (b4) {
                this.handleButtonUp(4);
            }
            if (b5) {
                this.handleButtonUp(5);
            }
            if (this.getDomain().getActiveTool() != this) {
                return;
            }
            this.setViewer(viewer);
        } else {
            this.getCurrentInput().setInput(me);
        }
        if (this.isInState(32)) {
            this.handleDragInProgress();
        } else {
            this.handleMove();
        }
    }

    public void mouseUp(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.getCurrentInput().setInput(me);
        this.getCurrentInput().setMouseButton(me.button, false);
        this.handleButtonUp(me.button);
    }

    public void mouseWheelScrolled(Event event, EditPartViewer viewer) {
        if (this.isInState(1)) {
            this.performViewerMouseWheel(event, viewer);
        }
    }

    protected boolean movedPastThreshold() {
        if (this.getFlag(1)) {
            return true;
        }
        Point start = this.getStartLocation();
        Point end = this.getLocation();
        if (Math.abs(start.x - end.x) > 5 || Math.abs(start.y - end.y) > 5) {
            this.setFlag(1, true);
            return true;
        }
        return false;
    }

    public void nativeDragFinished(DragSourceEvent event, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.handleNativeDragFinished(event);
    }

    public void nativeDragStarted(DragSourceEvent event, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.setViewer(viewer);
        this.handleNativeDragStarted(event);
    }

    protected void performViewerMouseWheel(Event event, EditPartViewer viewer) {
        MouseWheelHandler handler = (MouseWheelHandler)viewer.getProperty(MouseWheelHandler.KeyGenerator.getKey(event.stateMask));
        if (handler != null) {
            handler.handleMouseWheel(event, viewer);
        }
    }

    void placeMouseInViewer(Point p) {
        if (this.getCurrentViewer() == null) {
            return;
        }
        Control c = this.getCurrentViewer().getControl();
        Rectangle rect = c instanceof Scrollable ? ((Scrollable)c).getClientArea() : c.getBounds();
        if (p.x > rect.x + rect.width - 1) {
            p.x = rect.x + rect.width - 1;
        } else if (p.x < rect.x) {
            p.x = rect.x;
        }
        if (p.y > rect.y + rect.height - 1) {
            p.y = rect.y + rect.height - 1;
        } else if (p.y < rect.y) {
            p.y = rect.y;
        }
        org.eclipse.swt.graphics.Point swt = new org.eclipse.swt.graphics.Point(p.x, p.y);
        swt = c.toDisplay(swt);
        c.getDisplay().setCursorLocation(swt);
    }

    protected void reactivate() {
        Control c;
        EditPartViewer viewer = this.getCurrentViewer();
        this.deactivate();
        this.activate();
        if (viewer != null && (c = viewer.getControl()) != null && !c.isDisposed() && c.isFocusControl()) {
            this.setViewer(viewer);
        }
    }

    protected void refreshCursor() {
        if (this.isActive()) {
            this.setCursor(this.calculateCursor());
        }
    }

    protected void releaseToolCapture() {
        this.getCurrentViewer().setRouteEventsToEditDomain(false);
    }

    protected void removeFeedback(IFigure figure) {
        LayerManager lm = (LayerManager)this.getCurrentViewer().getEditPartRegistry().get(LayerManager.ID);
        if (lm == null) {
            return;
        }
        lm.getLayer("Feedback Layer").remove(figure);
    }

    protected void resetFlags() {
        this.setFlag(1, false);
        this.setFlag(2, false);
    }

    protected void setCurrentCommand(Command c) {
        this.command = c;
        this.refreshCursor();
    }

    protected void setCursor(Cursor cursor) {
        if (this.getCurrentViewer() != null) {
            this.getCurrentViewer().setCursor(cursor);
        }
    }

    public void setDefaultCursor(Cursor cursor) {
        if (this.defaultCursor == cursor) {
            return;
        }
        this.defaultCursor = cursor;
        this.refreshCursor();
    }

    public void setDisabledCursor(Cursor cursor) {
        if (this.disabledCursor == cursor) {
            return;
        }
        this.disabledCursor = cursor;
        this.refreshCursor();
    }

    public void setEditDomain(EditDomain domain) {
        this.domain = domain;
    }

    protected void setHoverActive(boolean value) {
        this.setFlag(2, value);
    }

    void setMouseCapture(boolean value) {
        if (this.getCurrentViewer() != null && this.getCurrentViewer().getControl() != null && !this.getCurrentViewer().getControl().isDisposed()) {
            this.getCurrentViewer().getControl().setCapture(value);
        }
    }

    public void setProperties(Map properties) {
        if (properties == null) {
            return;
        }
        Iterator entries = properties.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.applyProperty(entry.getKey(), entry.getValue());
        }
    }

    protected void setStartLocation(Point p) {
        this.startX = p.x;
        this.startY = p.y;
    }

    protected void setState(int state) {
        this.state = state;
    }

    protected void setToolCapture() {
        this.getCurrentViewer().setRouteEventsToEditDomain(true);
    }

    public void setUnloadWhenFinished(boolean value) {
        this.setFlag(4, value);
    }

    public void setViewer(EditPartViewer viewer) {
        if (viewer == this.currentViewer) {
            return;
        }
        this.setCursor(null);
        this.currentViewer = viewer;
        if (this.currentViewer != null) {
            org.eclipse.swt.graphics.Point p = this.currentViewer.getControl().toControl(Display.getCurrent().getCursorLocation());
            this.getCurrentInput().setMouseLocation(p.x, p.y);
        }
        this.refreshCursor();
    }

    protected boolean stateTransition(int start, int end) {
        if ((this.getState() & start) != 0) {
            this.setState(end);
            return true;
        }
        return false;
    }

    protected final boolean unloadWhenFinished() {
        return this.getFlag(4);
    }

    public void viewerEntered(MouseEvent me, EditPartViewer viewer) {
        if (!this.isViewerImportant(viewer)) {
            return;
        }
        this.getCurrentInput().setInput(me);
        if (this.getCurrentViewer() != null && this.getCurrentViewer() != viewer) {
            this.handleViewerExited();
        }
        this.setViewer(viewer);
        this.handleViewerEntered();
    }

    public void viewerExited(MouseEvent me, EditPartViewer viewer) {
        if (viewer == this.getCurrentViewer()) {
            this.getCurrentInput().setInput(me);
            this.handleViewerExited();
            this.setViewer(null);
        }
    }

    public static class Input
    extends FlagSupport {
        int modifiers;
        Point mouse = new Point();
        boolean verifyMouseButtons;

        protected int getModifiers() {
            return this.modifiers;
        }

        public Point getMouseLocation() {
            return this.mouse;
        }

        public boolean isAltKeyDown() {
            return (this.modifiers & 0x10000) != 0;
        }

        public boolean isAnyButtonDown() {
            return this.getFlag(62);
        }

        public boolean isControlKeyDown() {
            return (this.modifiers & 0x40000) != 0;
        }

        public boolean isModKeyDown(int mod) {
            return (this.modifiers & mod) != 0;
        }

        public boolean isMouseButtonDown(int which) {
            return this.getFlag(1 << which);
        }

        public boolean isShiftKeyDown() {
            return (this.modifiers & 0x20000) != 0;
        }

        public void setInput(KeyEvent ke) {
            this.modifiers = ke.stateMask;
        }

        public void setInput(MouseEvent me) {
            this.setMouseLocation(me.x, me.y);
            this.modifiers = me.stateMask;
            if (this.verifyMouseButtons) {
                this.setMouseButton(1, (this.modifiers & 0x80000) != 0);
                this.setMouseButton(2, (this.modifiers & 0x100000) != 0);
                this.setMouseButton(3, (this.modifiers & 0x200000) != 0);
                this.setMouseButton(4, (this.modifiers & 0x800000) != 0);
                this.setMouseButton(5, (this.modifiers & 0x2000000) != 0);
                this.verifyMouseButtons = false;
            }
        }

        public void setMouseButton(int which, boolean state) {
            this.setFlag(1 << which, state);
        }

        void setMouseLocation(int x, int y) {
            this.mouse.setLocation(x, y);
        }
    }
}

