/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IConstraintFilter;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractCategoryTreeNode
implements ICategoryTreeNode {
    private final CheckboxTreeViewer tree;
    private ICategoryTreeNode[] children;
    private final Category category;
    private final ICategoryTreeNode parent;
    private final IConstraintFilter filter;

    protected AbstractCategoryTreeNode(CheckboxTreeViewer tree, Category category, ICategoryTreeNode parent, IConstraintFilter filter) {
        this.tree = tree;
        this.category = category;
        this.parent = parent;
        this.filter = filter;
    }

    protected abstract List<ICategoryTreeNode> createChildren();

    private void initChildren() {
        if (this.children == null) {
            List<ICategoryTreeNode> childList = this.createChildren();
            this.children = childList.toArray(new ICategoryTreeNode[childList.size()]);
        }
    }

    protected boolean isRecursivelyEmpty(Category cat) {
        boolean result = AbstractCategoryTreeNode.getConstraints(cat, this.getFilter()).isEmpty();
        if (result) {
            for (Category child : cat.getChildren()) {
                result = this.isRecursivelyEmpty(child);
            }
        }
        return result;
    }

    protected static Set<IConstraintDescriptor> getConstraints(Category category, IConstraintFilter filter) {
        HashSet<IConstraintDescriptor> filteredConstraints = new HashSet<IConstraintDescriptor>();
        for (IConstraintDescriptor descriptor : category.getConstraints()) {
            if (!filter.accept(descriptor, null)) continue;
            filteredConstraints.add(descriptor);
        }
        return filteredConstraints;
    }

    protected final CheckboxTreeViewer getTree() {
        return this.tree;
    }

    @Override
    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    @Override
    public ICategoryTreeNode[] getChildren() {
        this.initChildren();
        return this.children;
    }

    @Override
    public final ICategoryTreeNode getParent() {
        return this.parent;
    }

    @Override
    public Category getCategory() {
        return this.category;
    }

    @Override
    public IConstraintNode[] getSelectedConstraints() {
        return new IConstraintNode[0];
    }

    @Override
    public void applyToPreferences() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.applyToPreferences();
            ++n2;
        }
    }

    @Override
    public void revertFromPreferences() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.revertFromPreferences();
            ++n2;
        }
    }

    @Override
    public void restoreDefaults() {
        ICategoryTreeNode[] currentChildren;
        ICategoryTreeNode[] iCategoryTreeNodeArray = currentChildren = this.getChildren();
        int n = currentChildren.length;
        int n2 = 0;
        while (n2 < n) {
            ICategoryTreeNode element = iCategoryTreeNodeArray[n2];
            element.restoreDefaults();
            ++n2;
        }
    }

    @Override
    public String getDescription() {
        return this.category.getDescription();
    }

    public String toString() {
        return this.getCategory() == null ? "" : this.getCategory().getName();
    }

    @Override
    public IConstraintFilter getFilter() {
        return this.filter;
    }
}

