/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.util.emf.workbench;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.resource.impl.URIConverterImpl;
import org.eclipse.jem.util.emf.workbench.FlexibleProjectResourceSet;
import org.eclipse.jem.util.emf.workbench.ResourceHandler;
import org.eclipse.jem.util.emf.workbench.ResourceSetWorkbenchSynchronizer;
import org.eclipse.jem.util.emf.workbench.WorkbenchResourceHelperBase;
import org.eclipse.jem.util.emf.workbench.nature.EMFNature;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.util.plugin.JEMUtilPlugin;

public class ProjectResourceSetImpl
extends ResourceSetImpl
implements FlexibleProjectResourceSet {
    private boolean isReleasing = false;
    private IProject project;
    protected List resourceHandlers = new ArrayList();
    protected ResourceSetWorkbenchSynchronizer synchronizer;

    protected ProjectResourceSetImpl() {
        this.setURIResourceMap(new HashMap(10));
        this.getLoadOptions().put("USE_PARSER_POOL", EMFNature.SHARED_PARSER_POOL);
    }

    public ProjectResourceSetImpl(IProject aProject) {
        this();
        this.setProject(aProject);
        this.initializeSharedCacheListener();
    }

    protected void initializeSharedCacheListener() {
        JEMUtilPlugin.getSharedCache().beginListening(this);
    }

    protected boolean isReleasing() {
        return this.isReleasing;
    }

    protected Resource delegatedGetResource(URI uri, boolean loadOnDemand) {
        Resource res = super.delegatedGetResource(uri, loadOnDemand);
        if (res == null) {
            res = this.getResourceFromHandlers(uri);
        }
        return res;
    }

    public Resource createResource(URI uri, String contentType) {
        Resource.Factory resourceFactory;
        if (this.isReleasing) {
            return null;
        }
        boolean isMapped = this.detectURIMapping(uri);
        boolean hasContentType = ProjectResourceSetImpl.getContentTypeName(uri) != null;
        URI converted = uri;
        if (!isMapped) {
            converted = this.getURIConverter().normalize(uri);
        } else if (hasContentType) {
            converted = this.getURIConverter().normalize(uri);
        }
        Resource result = this.createResourceFromHandlers(converted);
        if (result == null && (resourceFactory = this.getResourceFactoryRegistry().getFactory(uri)) != null) {
            result = resourceFactory.createResource(converted);
            this.getResources().add((Object)result);
        }
        return result;
    }

    public Resource createResource(URI uri) {
        return this.createResource(uri, "");
    }

    private boolean detectURIMapping(URI uri) {
        return !((URIConverterImpl.URIMap)this.getURIConverter().getURIMap()).getURI(uri).equals((Object)uri);
    }

    private IFile getPlatformFile(URI uri) {
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(uri)) {
            String fileString = URI.decode((String)uri.path());
            fileString = fileString.substring("resource".length() + 1);
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(fileString));
        }
        return null;
    }

    public Resource createResource(URI uri, Resource.Factory resourceFactory) {
        if (this.isReleasing) {
            return null;
        }
        boolean isMapped = this.detectURIMapping(uri);
        boolean hasContentType = ProjectResourceSetImpl.getContentTypeName(uri) != null;
        URI converted = uri;
        if (!isMapped) {
            converted = this.getURIConverter().normalize(uri);
        } else if (hasContentType) {
            converted = this.getURIConverter().normalize(uri);
        }
        Resource result = this.createResourceFromHandlers(converted);
        if (result == null) {
            if (resourceFactory != null) {
                result = resourceFactory.createResource(converted);
                this.getResources().add((Object)result);
                this.getURIResourceMap().put(uri, result);
                return result;
            }
            return null;
        }
        return result;
    }

    protected void demandLoad(Resource resource) throws IOException {
        if (!this.isReleasing) {
            super.demandLoad(resource);
        }
    }

    protected Resource createResourceFromHandlers(URI uri) {
        Resource resource = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            resource = handler.createResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    protected Resource getResourceFromHandlers(URI uri) {
        if (this.isReleasing) {
            return null;
        }
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            Resource resource = ((ResourceHandler)this.resourceHandlers.get(i)).getResource(this, uri);
            if (resource != null) {
                return resource;
            }
            ++i;
        }
        return null;
    }

    public void release() {
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new NotificationImpl(14, null, null, -1, false){

                public int getFeatureID(Class expectedClass) {
                    return 1000;
                }

                public Object getNotifier() {
                    return ProjectResourceSetImpl.this;
                }
            });
        }
        this.setIsReleasing(true);
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        this.synchronizer = null;
        this.removeAndUnloadAllResources();
        this.resourceHandlers = null;
        this.eAdapters().clear();
        this.setProject(null);
        JEMUtilPlugin.getSharedCache().stopListening(this);
    }

    protected void removeAndUnloadAllResources() {
        boolean caughtException = false;
        if (this.getResources().isEmpty()) {
            return;
        }
        ArrayList list = new ArrayList(this.getResources());
        this.getResources().clear();
        int size = list.size();
        int i = 0;
        while (i < size) {
            Resource res = (Resource)list.get(i);
            try {
                res.unload();
            }
            catch (RuntimeException ex) {
                Logger.getLogger().logError(ex);
                caughtException = true;
            }
            ++i;
        }
        if (caughtException) {
            throw new RuntimeException("Exception(s) unloading resources - check log files");
        }
    }

    protected void setIsReleasing(boolean aBoolean) {
        this.isReleasing = aBoolean;
    }

    public IProject getProject() {
        return this.project;
    }

    protected void setProject(IProject project) {
        this.project = project;
    }

    public EObject getEObject(URI uri, boolean loadOnDemand) {
        if (this.isReleasing) {
            return null;
        }
        Resource resource = this.getResource(uri.trimFragment(), loadOnDemand);
        EObject result = null;
        if (resource != null && resource.isLoaded()) {
            result = resource.getEObject(uri.fragment());
        }
        if (result == null) {
            result = this.getEObjectFromHandlers(uri, loadOnDemand);
        }
        return result;
    }

    protected EObject getEObjectFromHandlers(URI uri, boolean loadOnDemand) {
        EObject obj = null;
        ResourceHandler handler = null;
        int i = 0;
        while (i < this.resourceHandlers.size()) {
            handler = (ResourceHandler)this.resourceHandlers.get(i);
            obj = handler.getEObjectFailed(this, uri, loadOnDemand);
            if (obj != null) {
                return obj;
            }
            ++i;
        }
        return null;
    }

    public boolean add(ResourceHandler resourceHandler) {
        return this.resourceHandlers.add(resourceHandler);
    }

    public void addFirst(ResourceHandler resourceHandler) {
        this.resourceHandlers.add(0, resourceHandler);
    }

    public boolean remove(ResourceHandler resourceHandler) {
        return this.resourceHandlers.remove(resourceHandler);
    }

    public ResourceSetWorkbenchSynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    public void setSynchronizer(ResourceSetWorkbenchSynchronizer synchronizer) {
        this.synchronizer = synchronizer;
    }

    public void setResourceFactoryRegistry(Resource.Factory.Registry factoryReg) {
        if (this.resourceFactoryRegistry != null && factoryReg != null) {
            this.preserveEntries(factoryReg.getExtensionToFactoryMap(), this.resourceFactoryRegistry.getExtensionToFactoryMap());
            this.preserveEntries(factoryReg.getProtocolToFactoryMap(), this.resourceFactoryRegistry.getProtocolToFactoryMap());
        }
        super.setResourceFactoryRegistry(factoryReg);
    }

    protected void preserveEntries(Map map1, Map map2) {
        if (map2.isEmpty()) {
            return;
        }
        for (Map.Entry entry : map2.entrySet()) {
            if (map1.containsKey(entry.getKey())) continue;
            map1.put(entry.getKey(), entry.getValue());
        }
    }

    public Resource getResource(URI uri, boolean loadOnDemand) {
        Resource resource;
        if (this.isReleasing) {
            return null;
        }
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals((Object)normalizedURI)) continue;
            if (ProjectResourceSetImpl.getContentTypeName(uri) == null) {
                if (loadOnDemand && !resource2.isLoaded()) {
                    this.demandLoadHelper(resource2);
                }
                if (map != null) {
                    map.put(uri, resource2);
                }
                return resource2;
            }
            if (map.containsValue(resource2) && (map.get(uri) == null || !((Resource)map.get(uri)).equals(resource2)) && ProjectResourceSetImpl.getContentTypeName(this.findKey(resource2)) != null && (this.getContentTypeName(resource2) == null || !this.getContentTypeName(resource2).equals(ProjectResourceSetImpl.getContentTypeName(uri)))) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            if (map != null && map.get(uri) == null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            Resource resource3 = this.demandCreateResource(uri);
            if (resource3 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource3);
            if (map != null) {
                map.put(uri, resource3);
            }
            return resource3;
        }
        return null;
    }

    private IFile getPlatformFile(Resource res) {
        IFile file = null;
        file = this.getPlatformFile(res.getURI());
        if (file == null && res.getResourceSet() != null) {
            URIConverter converter = res.getResourceSet().getURIConverter();
            URI convertedUri = converter.normalize(res.getURI());
            if (!res.getURI().equals((Object)convertedUri)) {
                file = this.getPlatformFile(convertedUri);
            }
        }
        return file;
    }

    private String getContentTypeName(Resource resource) {
        IFile file = this.getPlatformFile(resource);
        IContentDescription desc = null;
        try {
            desc = file.getContentDescription();
        }
        catch (CoreException coreException) {}
        if (desc != null && desc.getContentType() != null) {
            return desc.getContentType().getName();
        }
        return null;
    }

    private URI findKey(Resource resource) {
        Map aMap = this.getURIResourceMap();
        Set keys = aMap.keySet();
        for (URI name : keys) {
            if (!aMap.get(name).equals(resource)) continue;
            return name;
        }
        return null;
    }

    protected static String getContentTypeName(URI uri) {
        String contentTypeIdentifier;
        if (WorkbenchResourceHelperBase.isPlatformResourceURI(uri) || !ProjectResourceSetImpl.isValidFullyQualifiedModuleURI(uri)) {
            return null;
        }
        String string = contentTypeIdentifier = uri.segmentCount() > 3 ? uri.segment(3) : null;
        if (contentTypeIdentifier != null && Platform.getContentTypeManager().getContentType(uri.segment(3)) != null) {
            return contentTypeIdentifier;
        }
        return null;
    }

    public static boolean isValidFullyQualifiedModuleURI(URI aModuleURI) {
        return aModuleURI.segmentCount() >= 3;
    }

    public Resource getResource(URI uri, boolean loadOnDemand, Resource.Factory resourceFactory) {
        Resource resource;
        if (this.isReleasing) {
            return null;
        }
        Map map = this.getURIResourceMap();
        if (map != null && (resource = (Resource)map.get(uri)) != null) {
            if (loadOnDemand && !resource.isLoaded()) {
                this.demandLoadHelper(resource);
            }
            return resource;
        }
        URIConverter theURIConverter = this.getURIConverter();
        URI normalizedURI = theURIConverter.normalize(uri);
        for (Resource resource2 : this.getResources()) {
            if (!theURIConverter.normalize(resource2.getURI()).equals((Object)normalizedURI)) continue;
            if (loadOnDemand && !resource2.isLoaded()) {
                this.demandLoadHelper(resource2);
            }
            if (map != null) {
                map.put(uri, resource2);
            }
            return resource2;
        }
        Resource delegatedResource = this.delegatedGetResource(uri, loadOnDemand);
        if (delegatedResource != null) {
            if (map != null) {
                map.put(uri, delegatedResource);
            }
            return delegatedResource;
        }
        if (loadOnDemand) {
            Resource resource3 = this.demandCreateResource(uri, resourceFactory);
            if (resource3 == null) {
                throw new RuntimeException("Cannot create a resource for '" + uri + "'; a registered resource factory is needed");
            }
            this.demandLoadHelper(resource3);
            if (map != null) {
                map.put(uri, resource3);
            }
            return resource3;
        }
        return null;
    }

    public void resetNormalizedURICache() {
        if (this.getURIResourceMap() != null) {
            this.getURIResourceMap().clear();
        }
    }

    protected Resource demandCreateResource(URI uri, Resource.Factory resourceFactory) {
        return this.createResource(uri, resourceFactory);
    }

    public static interface ModuleURI {
        public static final int SUB_PROTOCOL_INDX = 0;
        public static final int PROJECT_NAME_INDX = 1;
        public static final int MODULE_NAME_INDX = 2;
        public static final int CONTENT_TYPE_INDX = 3;
    }
}

