/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;

public class BundleResourceManager
extends ResourceManagerImpl {
    private final URL[] paths;

    public BundleResourceManager(URL ... paths) {
        assert (paths != null && paths.length > 0);
        this.paths = new URL[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.paths[i] = BundleResourceManager.fixTrailingSlash(paths[i]);
            ++i;
        }
    }

    private static URL fixTrailingSlash(URL u) {
        try {
            if (u.getPath() != null && !u.getPath().endsWith("/")) {
                return new URL(u, String.valueOf(u.getPath()) + '/');
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return u;
    }

    protected boolean shouldCache() {
        return true;
    }

    protected Reader resolve(String fullyQualifiedName, String extension) throws IOException {
        String urlPath = String.valueOf(fullyQualifiedName.replaceAll("::", "/")) + '.' + extension;
        int i = 0;
        while (i < this.paths.length) {
            try {
                return this.createReader(urlPath, this.paths[i]);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                Activator.logError(ex);
            }
            ++i;
        }
        throw new FileNotFoundException(fullyQualifiedName);
    }

    private Reader createReader(String urlPath, URL baseUrl) throws MalformedURLException, IOException {
        URL u = new URL(baseUrl, urlPath);
        InputStream is = u.openStream();
        return new InputStreamReader(is, Charset.forName("ISO-8859-1"));
    }

    protected Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
        String urlPath = String.valueOf(fullyQualifiedName.replaceAll("::", "/")) + '.' + extension;
        ArrayList<Reader> result = new ArrayList<Reader>(this.paths.length);
        int i = 0;
        while (i < this.paths.length) {
            try {
                result.add(this.createReader(urlPath, this.paths[i]));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                Activator.logError(ex);
            }
            ++i;
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException(fullyQualifiedName);
        }
        return result.toArray(new Reader[result.size()]);
    }
}

