/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.CompositeXpandResource;
import org.eclipse.gmf.internal.xpand.util.CompositeXtendResource;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.XpandResourceParser;
import org.eclipse.gmf.internal.xpand.util.XtendResourceParser;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

public abstract class ResourceManagerImpl
implements ResourceManager {
    private final Map<String, XtendResource> cachedXtend = new TreeMap<String, XtendResource>();
    private final Map<String, XpandResource> cachedXpand = new TreeMap<String, XpandResource>();
    private static final String ASPECT_PREFIX = "aspects::";

    public XtendResource loadXtendResource(String fullyQualifiedName) {
        if (this.hasCachedXtend(fullyQualifiedName)) {
            return this.cachedXtend.get(fullyQualifiedName);
        }
        try {
            XtendResource loaded = this.doLoadXtendResource(fullyQualifiedName);
            assert (loaded != null);
            if (this.shouldCache()) {
                this.cachedXtend.put(fullyQualifiedName, loaded);
            }
            return loaded;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException ex) {
            Activator.logError(ex);
        }
        catch (ParserException ex) {
            this.handleParserException(fullyQualifiedName, ex);
        }
        return null;
    }

    private XtendResource doLoadXtendResource(String fullyQualifiedName) throws IOException, ParserException {
        Reader[] rs = this.resolveMultiple(fullyQualifiedName, "ext");
        assert (rs != null && rs.length > 0);
        XtendResource[] result = new XtendResource[rs.length];
        int i = 0;
        while (i < rs.length) {
            Reader r = rs[i];
            assert (r != null);
            try {
                result[i] = this.loadXtendResource(r, fullyQualifiedName);
                assert (result[i] != null);
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (Exception exception) {}
            ++i;
        }
        if (result.length == 1) {
            return result[0];
        }
        return new CompositeXtendResource(this, result);
    }

    public XpandResource loadXpandResource(String fullyQualifiedName) {
        if (this.hasCachedXpand(fullyQualifiedName)) {
            return this.cachedXpand.get(fullyQualifiedName);
        }
        try {
            XpandResource loaded = this.doLoadXpandResource(fullyQualifiedName);
            if (this.shouldCache()) {
                this.cachedXpand.put(fullyQualifiedName, loaded);
            }
            return loaded;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(fullyQualifiedName, ex);
        }
        return null;
    }

    private XpandResource doLoadXpandResource(String fullyQualifiedName) throws IOException, ParserException {
        XpandResource[] unadvised = this.internalLoadXpandResources(fullyQualifiedName);
        XpandResource[] advices = null;
        try {
            String aspectsTemplateName = this.getAspectsTemplateName(fullyQualifiedName);
            advices = this.internalLoadXpandResources(aspectsTemplateName);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException ex) {
            Activator.logWarn(ex.getMessage());
        }
        catch (ParserException ex) {
            this.handleParserException(fullyQualifiedName, ex);
        }
        if (advices == null && unadvised.length == 1) {
            return unadvised[0];
        }
        return new CompositeXpandResource(this, unadvised, advices);
    }

    protected String getAspectsTemplateName(String fullyQualifiedName) {
        return ASPECT_PREFIX + fullyQualifiedName;
    }

    protected String getNonAspectsTemplateName(String possiblyAspectedFullyQualifiedName) {
        if (possiblyAspectedFullyQualifiedName == null) {
            return null;
        }
        if (possiblyAspectedFullyQualifiedName.startsWith(ASPECT_PREFIX)) {
            return possiblyAspectedFullyQualifiedName.substring(ASPECT_PREFIX.length());
        }
        return possiblyAspectedFullyQualifiedName;
    }

    private XpandResource[] internalLoadXpandResources(String fullyQualifiedName) throws IOException, ParserException {
        Reader[] rs = this.resolveMultiple(fullyQualifiedName, "xpt");
        assert (rs != null && rs.length > 0);
        XpandResource[] result = new XpandResource[rs.length];
        int i = 0;
        while (i < rs.length) {
            Reader r = rs[i];
            assert (r != null);
            try {
                result[i] = this.loadXpandResource(r, fullyQualifiedName);
                assert (result[i] != null);
            }
            catch (Throwable throwable) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
                throw throwable;
            }
            try {
                r.close();
            }
            catch (Exception exception) {}
            ++i;
        }
        return result;
    }

    protected void handleParserException(String name, ParserException ex) {
        Activator.logWarn(String.valueOf(name) + ":" + ex.getClass().getName());
    }

    @Deprecated
    protected abstract Reader resolve(String var1, String var2) throws IOException;

    protected Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
        return new Reader[]{this.resolve(fullyQualifiedName, extension)};
    }

    protected XtendResource loadXtendResource(Reader reader, String fullyQualifiedName) throws IOException, ParserException {
        return new XtendResourceParser().parse(reader, fullyQualifiedName);
    }

    protected XpandResource loadXpandResource(Reader reader, String fullyQualifiedName) throws IOException, ParserException {
        return new XpandResourceParser().parse(reader, fullyQualifiedName);
    }

    protected abstract boolean shouldCache();

    protected final boolean hasCachedXpand(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedXpand.containsKey(fullyQualifiedName);
    }

    protected final boolean hasCachedXtend(String fullyQualifiedName) {
        return this.shouldCache() && this.cachedXtend.containsKey(fullyQualifiedName);
    }

    protected final void forgetCachedXpand(String fullyQualifiedName) {
        this.cachedXpand.remove(fullyQualifiedName);
    }

    protected final void forgetCachedXtend(String fullyQualifiedName) {
        this.cachedXtend.remove(fullyQualifiedName);
    }

    protected final void forgetAll() {
        this.cachedXpand.clear();
        this.cachedXtend.clear();
    }
}

