/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.adapters.commands;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.wsdl.Binding;
import org.eclipse.wst.wsdl.ExtensibilityElement;
import org.eclipse.wst.wsdl.Port;
import org.eclipse.wst.wsdl.binding.http.HTTPAddress;
import org.eclipse.wst.wsdl.binding.http.HTTPBinding;
import org.eclipse.wst.wsdl.binding.http.HTTPFactory;
import org.eclipse.wst.wsdl.binding.soap.SOAPAddress;
import org.eclipse.wst.wsdl.binding.soap.SOAPBinding;
import org.eclipse.wst.wsdl.binding.soap.SOAPFactory;
import org.eclipse.wst.wsdl.ui.internal.Messages;
import org.eclipse.wst.wsdl.ui.internal.adapters.commands.W11TopLevelElementCommand;

public class W11SetBindingCommand
extends W11TopLevelElementCommand {
    private Port port;
    private Binding binding;

    public W11SetBindingCommand(Port port, Binding binding) {
        super(Messages._UI_ACTION_SET_BINDING, port.getEnclosingDefinition());
        this.port = port;
        this.binding = binding;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() {
        try {
            this.beginRecording(this.port.getElement());
            this.port.setEBinding(this.binding);
            W11SetBindingCommand.updatePortProtocol(this.port, this.binding);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.endRecording(this.port.getElement());
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.endRecording(this.port.getElement());
    }

    public static void updatePortProtocol(Port port, Binding binding) {
        String portAddress = null;
        Object bindingProtocol = W11SetBindingCommand.getBindingProtocol(binding);
        Object portProtocol = W11SetBindingCommand.getPortProtocol(port);
        if (portProtocol instanceof SOAPAddress) {
            portAddress = ((SOAPAddress)portProtocol).getLocationURI();
        } else if (portProtocol instanceof HTTPAddress) {
            portAddress = ((HTTPAddress)portProtocol).getLocationURI();
        }
        if (portAddress == null) {
            portAddress = "http://www.example.org";
        }
        if (bindingProtocol instanceof SOAPBinding && !(portProtocol instanceof SOAPAddress)) {
            SOAPAddress soap = SOAPFactory.eINSTANCE.createSOAPAddress();
            soap.setLocationURI(portAddress);
            W11SetBindingCommand.setNewProtocol(port, (ExtensibilityElement)soap);
        } else if (bindingProtocol instanceof HTTPBinding && !(portProtocol instanceof HTTPAddress)) {
            HTTPAddress http = HTTPFactory.eINSTANCE.createHTTPAddress();
            http.setLocationURI(portAddress);
            W11SetBindingCommand.setNewProtocol(port, (ExtensibilityElement)http);
        }
    }

    private static Object getBindingProtocol(Binding binding) {
        Iterator it = binding.getEExtensibilityElements().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (!(item instanceof SOAPBinding) && !(item instanceof HTTPBinding)) continue;
            return item;
        }
        return null;
    }

    private static Object getPortProtocol(Port port) {
        Iterator it = port.getEExtensibilityElements().iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item instanceof SOAPAddress) {
                return item;
            }
            if (!(item instanceof HTTPAddress)) continue;
            return item;
        }
        return null;
    }

    private static void setNewProtocol(Port port, ExtensibilityElement element) {
        EList existingElements = port.getEExtensibilityElements();
        int index = 0;
        while (index < existingElements.size()) {
            Object item = existingElements.get(index);
            if (item instanceof SOAPAddress || item instanceof HTTPAddress) {
                existingElements.remove(index);
                break;
            }
            ++index;
        }
        port.addExtensibilityElement((javax.wsdl.extensions.ExtensibilityElement)element);
    }
}

