/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.properties.sections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.eclipse.wst.common.ui.internal.search.dialogs.ComponentSpecification;
import org.eclipse.wst.wsdl.ui.internal.adapters.basic.W11EndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorCSHelpIds;
import org.eclipse.wst.wsdl.ui.internal.asd.Messages;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetExistingBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.actions.ASDSetNewBindingAction;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IBinding;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IEndPoint;
import org.eclipse.wst.wsdl.ui.internal.asd.properties.sections.ReferenceSection;
import org.eclipse.wst.wsdl.ui.internal.util.ReferenceEditManagerHelper;
import org.eclipse.wst.xsd.ui.internal.adt.edit.ComponentReferenceEditManager;

public class EndPointSection
extends ReferenceSection {
    protected Text addressText;
    protected CCombo protocolCombo;
    protected List bindingsInCombo = new ArrayList();
    protected ComponentReferenceEditManager refManager;

    public void createControls(Composite parent, TabbedPropertySheetWidgetFactory factory) {
        super.createControls(parent, factory);
        CLabel addressLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_ADDRESS) + ":");
        this.addressText = this.getWidgetFactory().createText(this.composite, "");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.addressText, -5);
        data.top = new FormAttachment((Control)this.addressText, 0, 0x1000000);
        addressLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.combo, 4);
        this.addressText.setLayoutData((Object)data);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.addressText, ASDEditorCSHelpIds.PROPERTIES_PORT_ADDRESS_TEXT);
        CLabel protocolLabel = this.getWidgetFactory().createCLabel(this.composite, String.valueOf(Messages._UI_LABEL_BINDING_PROTOCOL) + ":");
        this.protocolCombo = this.getWidgetFactory().createCCombo(this.composite);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment((Control)this.protocolCombo, -5);
        data.top = new FormAttachment((Control)this.protocolCombo, 0, 0x1000000);
        protocolLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 100);
        data.right = new FormAttachment(100, -this.rightMarginSpace - 5);
        data.top = new FormAttachment((Control)this.addressText, 4);
        this.protocolCombo.setLayoutData((Object)data);
        this.protocolCombo.addListener(24, (Listener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.protocolCombo, ASDEditorCSHelpIds.PROPERTIES_PORT_PROTOCOL_TEXT);
        this.comboLabel.setText(String.valueOf(Messages._UI_LABEL_BINDING) + ":");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.combo, ASDEditorCSHelpIds.PROPERTIES_PORT_BINDING_COMBO);
    }

    public void refresh() {
        this.removeListeners((Control)this.addressText);
        this.protocolCombo.removeListener(24, (Listener)this);
        super.refresh();
        IEndPoint endPoint = (IEndPoint)this.getModel();
        if (endPoint.getAddress() != null && !endPoint.getAddress().equals(this.addressText.getText())) {
            this.addressText.setText(endPoint.getAddress());
        }
        this.protocolCombo.removeAll();
        if (endPoint instanceof W11EndPoint) {
            String protocolValue = ((W11EndPoint)endPoint).getProtocol();
            List protocols = ((W11EndPoint)this.getModel()).getApplicableProtocol();
            Iterator it = protocols.iterator();
            while (it.hasNext()) {
                this.protocolCombo.add((String)it.next());
            }
            this.protocolCombo.setText(protocolValue);
        }
        this.setControlForegroundColor((Control)this.addressText);
        this.setControlForegroundColor((Control)this.protocolCombo);
        this.applyTextListeners((Control)this.addressText);
        this.protocolCombo.addListener(24, (Listener)this);
    }

    protected ComponentReferenceEditManager getComponentReferenceEditManager() {
        if (this.refManager != null) {
            return this.refManager;
        }
        this.refManager = ReferenceEditManagerHelper.getBindingReferenceEditManager((IASDObject)this.getModel());
        return this.refManager;
    }

    protected List getComboItems() {
        ComponentReferenceEditManager manager = this.getComponentReferenceEditManager();
        ArrayList<String> items = new ArrayList<String>();
        items.add(BROWSE_STRING);
        items.add(NEW_STRING);
        if (manager != null) {
            ComponentSpecification[] comboItems = manager.getQuickPicks();
            int index = 0;
            while (index < comboItems.length) {
                items.add((String)comboItems[index]);
                ++index;
            }
        }
        return items;
    }

    protected Object getCurrentComboItem() {
        IEndPoint endPoint = (IEndPoint)this.getModel();
        return endPoint.getBinding();
    }

    protected String getComboItemName(Object item) {
        String name = "";
        if (item instanceof ComponentSpecification) {
            name = ((ComponentSpecification)item).getName();
        } else if (item instanceof IBinding) {
            name = ((IBinding)item).getName();
        } else if (item instanceof String) {
            name = (String)item;
        }
        return name;
    }

    protected void performComboSelection(Object item) {
        ComponentSpecification spec = null;
        if (item instanceof ComponentSpecification) {
            spec = (ComponentSpecification)item;
            ComponentReferenceEditManager manager = this.getComponentReferenceEditManager();
            manager.modifyComponentReference((Object)((IEndPoint)this.getModel()), spec);
        } else if (item instanceof String) {
            if (item.equals(BROWSE_STRING)) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                ASDSetExistingBindingAction action = new ASDSetExistingBindingAction(part);
                action.setIEndPoint((IEndPoint)this.getModel());
                action.run();
            } else if (item.equals(NEW_STRING)) {
                IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart();
                ASDSetNewBindingAction action = new ASDSetNewBindingAction(part);
                action.setIEndPoint((IEndPoint)this.getModel());
                action.run();
            }
        }
        this.refresh();
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    public void doHandleEvent(Event event) {
        if (event.widget == this.addressText && !this.addressText.isDisposed()) {
            String oldAddress;
            String newAddress = this.addressText.getText();
            if (newAddress == null) {
                newAddress = "";
            }
            if ((oldAddress = this.getOldAddress()).equals(newAddress)) {
                return;
            }
            IEndPoint endPoint = (IEndPoint)this.getModel();
            Command command = endPoint.getSetAddressCommand(newAddress);
            this.executeCommand(command);
        } else if (event.widget == this.protocolCombo && !this.protocolCombo.isDisposed()) {
            String newProtocol = this.protocolCombo.getText();
            if (newProtocol != null && this.getModel() instanceof W11EndPoint) {
                W11EndPoint endPoint = (W11EndPoint)this.getModel();
                endPoint.setProtocol(newProtocol);
            }
        } else {
            super.doHandleEvent(event);
        }
    }

    private String getOldAddress() {
        String value = null;
        if (this.getModel() instanceof W11EndPoint) {
            value = ((W11EndPoint)this.getModel()).getAddress();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }
}

