/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.jpt.core.internal.AccessType;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaFileContentProvider;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaDataSource;
import org.eclipse.jpt.core.internal.JpaFile;
import org.eclipse.jpt.core.internal.NullTypeMapping;

public class JpaCoreFactory
extends EFactoryImpl {
    public static final JpaCoreFactory eINSTANCE = JpaCoreFactory.init();

    public static JpaCoreFactory init() {
        try {
            JpaCoreFactory theJpaCoreFactory = (JpaCoreFactory)EPackage.Registry.INSTANCE.getEFactory("jpt.core.xmi");
            if (theJpaCoreFactory != null) {
                return theJpaCoreFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JpaCoreFactory();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 3: {
                return this.createJpaDataSource();
            }
            case 5: {
                return this.createJpaFile();
            }
            case 13: {
                return this.createNullTypeMapping();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 16: {
                return this.createAccessTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 16: {
                return this.convertAccessTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public JpaDataSource createJpaDataSource() {
        JpaDataSource jpaDataSource = new JpaDataSource();
        return jpaDataSource;
    }

    public JpaDataSource createJpaDataSource(IJpaProject jpaProject, String connectionProfileName) {
        return new JpaDataSource(jpaProject, connectionProfileName);
    }

    public JpaFile createJpaFile() {
        JpaFile jpaFile = new JpaFile();
        return jpaFile;
    }

    public IJpaFile createJpaFile(IJpaProject jpaProject, IFile file, IJpaFileContentProvider provider) {
        return new JpaFile(jpaProject, file, provider);
    }

    public NullTypeMapping createNullTypeMapping() {
        NullTypeMapping nullTypeMapping = new NullTypeMapping();
        return nullTypeMapping;
    }

    public AccessType createAccessTypeFromString(EDataType eDataType, String initialValue) {
        AccessType result = AccessType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertAccessTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JpaCorePackage getJpaCorePackage() {
        return (JpaCorePackage)this.getEPackage();
    }

    @Deprecated
    public static JpaCorePackage getPackage() {
        return JpaCorePackage.eINSTANCE;
    }
}

