/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jpt.core.internal.IJpaDataSource;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaCorePackage;
import org.eclipse.jpt.core.internal.JpaEObject;
import org.eclipse.jpt.db.internal.ConnectionListener;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.ConnectionProfileRepository;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.db.internal.ProfileListener;
import org.eclipse.jpt.db.internal.Schema;
import org.eclipse.jpt.db.internal.Table;

public class JpaDataSource
extends JpaEObject
implements IJpaDataSource {
    private IJpaProject jpaProject;
    protected static final String CONNECTION_PROFILE_NAME_EDEFAULT = null;
    protected String connectionProfileName = CONNECTION_PROFILE_NAME_EDEFAULT;
    protected transient ConnectionProfile connectionProfile;
    protected final ProfileListener profileListener = this.buildProfileListener();
    protected final ConnectionListener connectionListener;

    protected JpaDataSource() {
        ConnectionProfileRepository.instance().addProfileListener(this.profileListener);
        this.connectionListener = this.buildConnectionListener();
    }

    protected JpaDataSource(IJpaProject jpaProject, String connectionProfileName) {
        this();
        this.jpaProject = jpaProject;
        this.connectionProfileName = connectionProfileName;
        this.connectionProfile = this.profileNamed(connectionProfileName);
        this.connectionProfile.addConnectionListener(this.connectionListener);
    }

    protected ProfileListener buildProfileListener() {
        return new LocalProfileListener();
    }

    protected ConnectionListener buildConnectionListener() {
        return new LocalConnectionListener();
    }

    protected EClass eStaticClass() {
        return JpaCorePackage.Literals.JPA_DATA_SOURCE;
    }

    public String getConnectionProfileName() {
        return this.connectionProfileName;
    }

    public void setConnectionProfileNameGen(String newConnectionProfileName) {
        String oldConnectionProfileName = this.connectionProfileName;
        this.connectionProfileName = newConnectionProfileName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldConnectionProfileName, (Object)this.connectionProfileName));
        }
    }

    public void setConnectionProfileName(String connectionProfileName) {
        if (!connectionProfileName.equals(this.connectionProfileName)) {
            this.setConnectionProfileNameGen(connectionProfileName);
            this.setConnectionProfile(this.profileNamed(connectionProfileName));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getConnectionProfileName();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setConnectionProfileName((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setConnectionProfileName(CONNECTION_PROFILE_NAME_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return CONNECTION_PROFILE_NAME_EDEFAULT == null ? this.connectionProfileName != null : !CONNECTION_PROFILE_NAME_EDEFAULT.equals(this.connectionProfileName);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (connectionProfileName: ");
        result.append(this.connectionProfileName);
        result.append(')');
        return result.toString();
    }

    public IJpaProject getProject() {
        return this.jpaProject;
    }

    public ConnectionProfile getConnectionProfile() {
        return this.connectionProfile;
    }

    private ConnectionProfile profileNamed(String name) {
        return ConnectionProfileRepository.instance().profileNamed(name);
    }

    void setConnectionProfile(ConnectionProfile profile) {
        if (this.connectionProfile != profile) {
            this.connectionProfile.removeConnectionListener(this.connectionListener);
            this.connectionProfile = profile;
            this.connectionProfile.addConnectionListener(this.connectionListener);
            this.getProject().update();
        }
    }

    public boolean isConnected() {
        return this.connectionProfile.isConnected();
    }

    public boolean hasAConnection() {
        return this.connectionProfile.isNull();
    }

    public void dispose() {
        this.connectionProfile.removeConnectionListener(this.connectionListener);
        ConnectionProfileRepository.instance().removeProfileListener(this.profileListener);
    }

    protected class LocalConnectionListener
    implements ConnectionListener {
        protected LocalConnectionListener() {
        }

        public void opened(ConnectionProfile profile) {
            JpaDataSource.this.getProject().update();
        }

        public void aboutToClose(ConnectionProfile profile) {
        }

        public boolean okToClose(ConnectionProfile profile) {
            return true;
        }

        public void closed(ConnectionProfile profile) {
            JpaDataSource.this.getProject().update();
        }

        public void modified(ConnectionProfile profile) {
        }

        public void databaseChanged(ConnectionProfile profile, Database database) {
        }

        public void schemaChanged(ConnectionProfile profile, Schema schema) {
        }

        public void tableChanged(ConnectionProfile profile, Table table) {
        }
    }

    protected class LocalProfileListener
    implements ProfileListener {
        protected LocalProfileListener() {
        }

        public void profileChanged(ConnectionProfile profile) {
            if (profile == JpaDataSource.this.connectionProfile) {
                JpaDataSource.this.setConnectionProfileName(profile.getName());
            }
        }

        public void profileReplaced(ConnectionProfile oldProfile, ConnectionProfile newProfile) {
            if (oldProfile == JpaDataSource.this.connectionProfile) {
                JpaDataSource.this.setConnectionProfile(newProfile);
            }
        }
    }
}

