/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.core.internal.content.orm.EntityMappingsInternal;
import org.eclipse.jpt.core.internal.content.orm.OrmFactory;
import org.eclipse.jpt.core.internal.content.orm.OrmResource;
import org.eclipse.jpt.core.internal.content.orm.resource.OrmArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.Persistence;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceFactory;
import org.eclipse.jpt.core.internal.content.persistence.PersistenceUnit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceArtifactEdit;
import org.eclipse.jpt.core.internal.content.persistence.resource.PersistenceResource;
import org.eclipse.jpt.utility.internal.ClassTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.model.AbstractModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaModel
extends AbstractModel
implements IJpaModel {
    private final ArrayList<IJpaProjectHolder> jpaProjectHolders = new ArrayList();
    private static final boolean DEBUG = false;

    JpaModel() throws CoreException {
        ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)new ResourceProxyVisitor(), 0);
    }

    @Override
    public synchronized IJpaProject jpaProject(IProject project) throws CoreException {
        return this.jpaProjectHolder(project).jpaProject();
    }

    @Override
    public synchronized boolean containsJpaProject(IProject project) {
        return this.jpaProjectHolder(project).holdsJpaProjectFor(project);
    }

    @Override
    public synchronized Iterator<IJpaProject> jpaProjects() throws CoreException {
        ArrayList<IJpaProject> jpaProjects = new ArrayList<IJpaProject>(this.jpaProjectHolders.size());
        for (IJpaProjectHolder holder : this.jpaProjectHolders) {
            jpaProjects.add(holder.jpaProject());
        }
        return jpaProjects.iterator();
    }

    @Override
    public synchronized int jpaProjectsSize() {
        return this.jpaProjectHolders.size();
    }

    @Override
    public synchronized IJpaFile jpaFile(IFile file) throws CoreException {
        IJpaProject jpaProject = this.jpaProject(file.getProject());
        return jpaProject == null ? null : jpaProject.jpaFile(file);
    }

    private IJpaProjectHolder jpaProjectHolder(IProject project) {
        for (IJpaProjectHolder holder : this.jpaProjectHolders) {
            if (!holder.holdsJpaProjectFor(project)) continue;
            return holder;
        }
        return NullJpaProjectHolder.instance();
    }

    private IJpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setProject(project);
        config.setJpaPlatform(JptCorePlugin.jpaPlatform(project));
        config.setConnectionProfileName(JptCorePlugin.connectionProfileName(project));
        config.setDiscoverAnnotatedClasses(JptCorePlugin.discoverAnnotatedClasses(project));
        return config;
    }

    void addJpaProject(IProject project) {
        this.addJpaProject(this.buildJpaProjectConfig(project));
    }

    private void addJpaProject(IJpaProject.Config config) {
        JpaModel.dumpStackTrace();
        this.jpaProjectHolders.add(this.jpaProjectHolder(config.project()).buildJpaProjectHolder(this, config));
    }

    private void removeJpaProject(IProject project) {
        JpaModel.dumpStackTrace();
        this.jpaProjectHolder(project).remove();
    }

    synchronized void projectPreDelete(IProject project) {
        this.removeJpaProject(project);
    }

    synchronized void synchronizeFiles(IProject project, IResourceDelta delta) throws CoreException {
        this.jpaProjectHolder(project).synchronizeJpaFiles(delta);
    }

    synchronized void checkForTransition(IProject project) {
        boolean jpaFacet = JptCorePlugin.projectHasJpaFacet(project);
        boolean jpaProject = this.containsJpaProject(project);
        if (jpaFacet) {
            if (!jpaProject) {
                this.addJpaProject(project);
            }
        } else if (jpaProject) {
            this.removeJpaProject(project);
        }
    }

    synchronized void jpaFacetedProjectPostInstall(IProjectFacetActionEvent event) {
        IProject project = event.getProject().getProject();
        IDataModel dataModel = (IDataModel)event.getActionConfig();
        this.buildPersistenceXmlJob(project).schedule();
        if (dataModel.getBooleanProperty("IJpaFacetDataModelProperties.CREATE_ORM_XML")) {
            this.buildOrmXmlJob(project).schedule();
        }
        this.addJpaProject(project);
    }

    private Job buildPersistenceXmlJob(final IProject project) {
        return new Job("Create persistence.xml"){

            protected IStatus run(IProgressMonitor monitor) {
                JpaModel.this.createPersistenceXml(project);
                return Status.OK_STATUS;
            }
        };
    }

    void createPersistenceXml(IProject project) {
        PersistenceArtifactEdit pae = PersistenceArtifactEdit.getArtifactEditForWrite(project);
        PersistenceResource resource = pae.getPersistenceResource(JptCorePlugin.persistenceXmlDeploymentURI(project));
        if (resource.getPersistence() == null) {
            Persistence persistence = PersistenceFactory.eINSTANCE.createPersistence();
            persistence.setVersion("1.0");
            PersistenceUnit pUnit = PersistenceFactory.eINSTANCE.createPersistenceUnit();
            pUnit.setName(project.getName());
            persistence.getPersistenceUnits().add((Object)pUnit);
            this.resourceContents(resource).add((Object)persistence);
            pae.save(null);
        }
        pae.dispose();
    }

    private EList<EObject> resourceContents(PersistenceResource resource) {
        return resource.getContents();
    }

    private Job buildOrmXmlJob(final IProject project) {
        return new Job("Create orm.xml"){

            protected IStatus run(IProgressMonitor monitor) {
                JpaModel.this.createOrmXml(project);
                return Status.OK_STATUS;
            }
        };
    }

    void createOrmXml(IProject project) {
        OrmArtifactEdit oae = OrmArtifactEdit.getArtifactEditForWrite(project);
        OrmResource resource = oae.getOrmResource(JptCorePlugin.ormXmlDeploymentURI(project));
        if (resource.getEntityMappings() == null) {
            EntityMappingsInternal entityMappings = OrmFactory.eINSTANCE.createEntityMappingsInternal();
            entityMappings.setVersion("1.0");
            resource.getContents().add((Object)entityMappings);
            oae.save(null);
        }
        oae.dispose();
    }

    synchronized void jpaFacetedProjectPreUninstall(IProjectFacetActionEvent event) {
        this.removeJpaProject(event.getProject().getProject());
    }

    synchronized void javaElementChanged(ElementChangedEvent event) {
        for (IJpaProjectHolder jpaProjectHolder : this.jpaProjectHolders) {
            jpaProjectHolder.javaElementChanged(event);
        }
    }

    synchronized void rebuildJpaProject(IProject project) {
        this.removeJpaProject(project);
        this.addJpaProject(project);
    }

    synchronized void dispose() {
        IJpaProjectHolder[] holders;
        IJpaProjectHolder[] iJpaProjectHolderArray = holders = this.jpaProjectHolders.toArray(new IJpaProjectHolder[this.jpaProjectHolders.size()]);
        int n = holders.length;
        int n2 = 0;
        while (n2 < n) {
            IJpaProjectHolder holder = iJpaProjectHolderArray[n2];
            holder.remove();
            ++n2;
        }
    }

    public void toString(StringBuilder sb) {
        sb.append("JPA projects size: " + this.jpaProjectsSize());
    }

    void jpaProjectBuilt(IJpaProject jpaProject) {
        this.fireItemAdded("jpaProjects", jpaProject);
    }

    void jpaProjectRemoved(IJpaProject jpaProject) {
        this.fireItemRemoved("jpaProjects", jpaProject);
    }

    void removeJpaProjectHolder(IJpaProjectHolder jpaProjectHolder) {
        this.jpaProjectHolders.remove(jpaProjectHolder);
    }

    private static void dumpStackTrace() {
    }

    private static interface IJpaProjectHolder {
        public boolean holdsJpaProjectFor(IProject var1);

        public IJpaProject jpaProject() throws CoreException;

        public void synchronizeJpaFiles(IResourceDelta var1) throws CoreException;

        public void javaElementChanged(ElementChangedEvent var1);

        public IJpaProjectHolder buildJpaProjectHolder(JpaModel var1, IJpaProject.Config var2);

        public void remove();
    }

    private static class JpaProjectHolder
    implements IJpaProjectHolder {
        private final JpaModel jpaModel;
        private final IJpaProject.Config config;
        private IJpaProject jpaProject;

        JpaProjectHolder(JpaModel jpaModel, IJpaProject.Config config) {
            this.jpaModel = jpaModel;
            this.config = config;
        }

        public boolean holdsJpaProjectFor(IProject project) {
            return this.config.project().equals((Object)project);
        }

        public IJpaProject jpaProject() throws CoreException {
            if (this.jpaProject == null) {
                this.jpaProject = this.buildJpaProject();
                this.jpaModel.jpaProjectBuilt(this.jpaProject);
            }
            return this.jpaProject;
        }

        private IJpaProject buildJpaProject() throws CoreException {
            return this.config.jpaPlatform().getJpaFactory().createJpaProject(this.config);
        }

        public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
            if (this.jpaProject != null) {
                this.jpaProject.synchronizeJpaFiles(delta);
            }
        }

        public void javaElementChanged(ElementChangedEvent event) {
            if (this.jpaProject != null) {
                this.jpaProject.javaElementChanged(event);
            }
        }

        public IJpaProjectHolder buildJpaProjectHolder(JpaModel jm, IJpaProject.Config c) {
            throw new IllegalArgumentException(c.project().getName());
        }

        public void remove() {
            this.jpaModel.removeJpaProjectHolder(this);
            if (this.jpaProject != null) {
                this.jpaModel.jpaProjectRemoved(this.jpaProject);
                this.jpaProject.dispose();
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this, (Object)this.config.project().getName());
        }
    }

    private static class NullJpaProjectHolder
    implements IJpaProjectHolder {
        private static final IJpaProjectHolder INSTANCE = new NullJpaProjectHolder();

        static IJpaProjectHolder instance() {
            return INSTANCE;
        }

        private NullJpaProjectHolder() {
        }

        public boolean holdsJpaProjectFor(IProject project) {
            return false;
        }

        public IJpaProject jpaProject() throws CoreException {
            return null;
        }

        public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
        }

        public void javaElementChanged(ElementChangedEvent event) {
        }

        public IJpaProjectHolder buildJpaProjectHolder(JpaModel jpaModel, IJpaProject.Config config) {
            return new JpaProjectHolder(jpaModel, config);
        }

        public void remove() {
        }

        public String toString() {
            return ClassTools.shortClassNameForObject((Object)this);
        }
    }

    private class ResourceProxyVisitor
    implements IResourceProxyVisitor {
        ResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resourceProxy) throws CoreException {
            switch (resourceProxy.getType()) {
                case 8: {
                    return true;
                }
                case 4: {
                    this.checkProject(resourceProxy);
                    return false;
                }
            }
            return false;
        }

        private void checkProject(IResourceProxy resourceProxy) {
            IProject project;
            if (resourceProxy.isAccessible() && JptCorePlugin.projectHasJpaFacet(project = (IProject)resourceProxy.requestResource())) {
                JpaModel.this.addJpaProject(project);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

