/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaModel;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.utility.internal.BitTools;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectEvent;
import org.eclipse.wst.common.project.facet.core.events.IFacetedProjectListener;
import org.eclipse.wst.common.project.facet.core.events.IProjectFacetActionEvent;

public class JpaModelManager {
    private JpaModel jpaModel;
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private final IFacetedProjectListener facetedProjectListener = new FacetedProjectListener();
    private final IElementChangedListener javaElementChangeListener = new JavaElementChangeListener();
    private final Preferences.IPropertyChangeListener preferencesListener = new PreferencesListener();
    private static final JpaModelManager INSTANCE = new JpaModelManager();
    private static final boolean DEBUG = false;

    public static JpaModelManager instance() {
        return INSTANCE;
    }

    private JpaModelManager() {
    }

    public synchronized void start() throws Exception {
        JpaModelManager.debug("*** START JPA model manager ***");
        try {
            this.jpaModel = new JpaModel();
            ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
            FacetedProjectFramework.addListener((IFacetedProjectListener)this.facetedProjectListener, (IFacetedProjectEvent.Type[])IFacetedProjectEvent.Type.values());
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
            JptCorePlugin.instance().getPluginPreferences().addPropertyChangeListener(this.preferencesListener);
        }
        catch (RuntimeException ex) {
            this.log(ex);
            this.stop();
        }
    }

    public synchronized void stop() throws Exception {
        JpaModelManager.debug("*** STOP JPA model manager ***");
        JptCorePlugin.instance().getPluginPreferences().removePropertyChangeListener(this.preferencesListener);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        FacetedProjectFramework.removeListener((IFacetedProjectListener)this.facetedProjectListener);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        this.jpaModel.dispose();
        this.jpaModel = null;
    }

    public IJpaModel jpaModel() {
        return this.jpaModel;
    }

    public IJpaProject jpaProject(IProject project) throws CoreException {
        return this.jpaModel.jpaProject(project);
    }

    public IJpaFile jpaFile(IFile file) throws CoreException {
        return this.jpaModel.jpaFile(file);
    }

    public void rebuildJpaProject(IProject project) {
        this.jpaModel.rebuildJpaProject(project);
    }

    public void log(IStatus status) {
        JptCorePlugin.log(status);
    }

    public void log(String msg) {
        JptCorePlugin.log(msg);
    }

    public void log(Throwable throwable) {
        JptCorePlugin.log(throwable);
    }

    void resourceChanged(IResourceChangeEvent event) {
        if (!(event.getSource() instanceof IWorkspace)) {
            return;
        }
        switch (event.getType()) {
            case 4: {
                this.resourcePreDelete(event);
                break;
            }
            case 1: {
                this.resourcePostChange(event);
                break;
            }
        }
    }

    private void resourcePreDelete(IResourceChangeEvent event) {
        JpaModelManager.debug("Resource (Project) PRE_DELETE: " + event.getResource());
        this.jpaModel.projectPreDelete((IProject)event.getResource());
    }

    private void resourcePostChange(IResourceChangeEvent event) {
        JpaModelManager.debug("Resource POST_CHANGE");
        this.synchronizeFiles(event.getDelta());
        this.checkForOpenedProjects(event.getDelta());
    }

    private void synchronizeFiles(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                this.synchronizeFiles(delta.getAffectedChildren());
                break;
            }
            case 4: {
                this.synchronizeFiles((IProject)resource, delta);
                break;
            }
        }
    }

    private void synchronizeFiles(IResourceDelta[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            this.synchronizeFiles(deltas[i]);
            ++i;
        }
    }

    private void synchronizeFiles(IProject project, IResourceDelta delta) {
        try {
            this.jpaModel.synchronizeFiles(project, delta);
        }
        catch (CoreException ex) {
            this.log(ex);
        }
    }

    private void checkForOpenedProjects(IResourceDelta delta) {
        IResource resource = delta.getResource();
        switch (resource.getType()) {
            case 8: {
                this.checkForOpenedProjects(delta.getAffectedChildren());
                break;
            }
            case 4: {
                this.checkForOpenedProject((IProject)resource, delta);
                break;
            }
        }
    }

    private void checkForOpenedProjects(IResourceDelta[] deltas) {
        int i = 0;
        while (i < deltas.length) {
            this.checkForOpenedProjects(deltas[i]);
            ++i;
        }
    }

    private void checkForOpenedProject(IProject project, IResourceDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                this.checkDeltaFlagsForOpenedProject(project, delta);
                break;
            }
        }
    }

    private void checkDeltaFlagsForOpenedProject(IProject project, IResourceDelta delta) {
        if (BitTools.flagIsSet((int)delta.getFlags(), (int)16384) && project.isOpen()) {
            JpaModelManager.debug("\tProject CHANGED - OPEN: " + project.getName());
            this.jpaModel.checkForTransition(project);
        }
    }

    void facetedProjectChanged(IFacetedProjectEvent event) {
        switch (event.getType()) {
            case POST_INSTALL: {
                this.facetedProjectPostInstall((IProjectFacetActionEvent)event);
                break;
            }
            case PRE_UNINSTALL: {
                this.facetedProjectPreUninstall((IProjectFacetActionEvent)event);
                break;
            }
            case PROJECT_MODIFIED: {
                this.facetedProjectModified(event.getProject().getProject());
                break;
            }
        }
    }

    private void facetedProjectPostInstall(IProjectFacetActionEvent event) {
        JpaModelManager.debug("Facet POST_INSTALL: " + event.getProjectFacet());
        if (event.getProjectFacet().getId().equals("jpt.jpa")) {
            this.jpaModel.jpaFacetedProjectPostInstall(event);
        }
    }

    private void facetedProjectPreUninstall(IProjectFacetActionEvent event) {
        JpaModelManager.debug("Facet PRE_UNINSTALL: " + event.getProjectFacet());
        if (event.getProjectFacet().getId().equals("jpt.jpa")) {
            this.jpaModel.jpaFacetedProjectPreUninstall(event);
        }
    }

    private void facetedProjectModified(IProject project) {
        JpaModelManager.debug("Facet PROJECT_MODIFIED: " + project.getName());
        this.jpaModel.checkForTransition(project);
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.eventIndicatesProjectAddedButNotOpen(event)) {
            return;
        }
        this.jpaModel.javaElementChanged(event);
    }

    private boolean eventIndicatesProjectAddedButNotOpen(ElementChangedEvent event) {
        IJavaElement childElement;
        IJavaElementDelta childDelta;
        IJavaElementDelta[] children;
        IJavaElementDelta delta = event.getDelta();
        return delta.getKind() == 4 && delta.getElement().getElementType() == 1 && (children = delta.getAffectedChildren()).length == 1 && (childDelta = children[0]).getKind() == 1 && (childElement = childDelta.getElement()).getElementType() == 2 && childDelta.getAffectedChildren().length == 0 && !((IOpenable)childElement).isOpen();
    }

    void preferenceChanged(Preferences.PropertyChangeEvent event) {
        if (event.getProperty() == "defaultJpaLib") {
            try {
                JavaCore.setClasspathVariable((String)"DEFAULT_JPA_LIB", (IPath)new Path((String)event.getNewValue()), null);
            }
            catch (JavaModelException ex) {
                this.log(ex);
            }
        }
    }

    private static void debug(String message) {
    }

    private class FacetedProjectListener
    implements IFacetedProjectListener {
        FacetedProjectListener() {
        }

        public void handleEvent(IFacetedProjectEvent event) {
            JpaModelManager.this.facetedProjectChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            JpaModelManager.this.javaElementChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class PreferencesListener
    implements Preferences.IPropertyChangeListener {
        PreferencesListener() {
        }

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            JpaModelManager.this.preferenceChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            JpaModelManager.this.resourceChanged(event);
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }
}

