/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.jpt.core.internal.IJpaFactory;
import org.eclipse.jpt.core.internal.IJpaNode;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.db.internal.Database;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.node.AbstractNode;
import org.eclipse.jpt.utility.internal.node.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JpaNode
extends AbstractNode
implements IJpaNode {
    private static final HashMap<Class<? extends AbstractNode>, HashSet<String>> nonDefaultAspectNameSets = new HashMap();

    protected JpaNode(IJpaNode parent) {
        super((Node)parent);
    }

    @Override
    public IResource resource() {
        return this.jpaProject().project();
    }

    @Override
    public IJpaProject jpaProject() {
        return this.root();
    }

    public String displayString() {
        return this.toString();
    }

    @Override
    public IJpaNode parent() {
        return (IJpaNode)super.parent();
    }

    @Override
    public IJpaProject root() {
        return (IJpaProject)super.root();
    }

    public Iterator<IJpaNode> jpaChildren() {
        return new TransformationIterator<Node, IJpaNode>(this.children()){

            protected IJpaNode transform(Node next) {
                return (IJpaNode)next;
            }
        };
    }

    protected IJpaPlatform jpaPlatform() {
        return this.jpaProject().jpaPlatform();
    }

    protected IJpaFactory jpaFactory() {
        return this.jpaPlatform().getJpaFactory();
    }

    protected ConnectionProfile connectionProfile() {
        return this.jpaProject().connectionProfile();
    }

    protected Database database() {
        return this.connectionProfile().getDatabase();
    }

    protected boolean isConnected() {
        return this.connectionProfile().isConnected();
    }

    protected void aspectChanged(String aspectName) {
        super.aspectChanged(aspectName);
        if (this.aspectAffectsDefaults(aspectName)) {
            this.jpaProject().update();
        }
    }

    private boolean aspectAffectsDefaults(String aspectName) {
        return !this.aspectDoesNotAffectDefaults(aspectName);
    }

    private boolean aspectDoesNotAffectDefaults(String aspectName) {
        return this.nonDefaultAspectNames().contains(aspectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Set<String> nonDefaultAspectNames() {
        HashMap<Class<? extends AbstractNode>, HashSet<String>> hashMap = nonDefaultAspectNameSets;
        synchronized (hashMap) {
            HashSet<String> nonDefaultAspectNames = nonDefaultAspectNameSets.get(this.getClass());
            if (nonDefaultAspectNames == null) {
                nonDefaultAspectNames = new HashSet();
                this.addNonDefaultAspectNamesTo(nonDefaultAspectNames);
                nonDefaultAspectNameSets.put(this.getClass(), nonDefaultAspectNames);
            }
            return nonDefaultAspectNames;
        }
    }

    protected void addNonDefaultAspectNamesTo(Set<String> nonDefaultAspectNames) {
        nonDefaultAspectNames.add("comment");
        nonDefaultAspectNames.add("dirtyBranch");
        nonDefaultAspectNames.add("branchProblems");
        nonDefaultAspectNames.add("hasBranchProblems");
    }
}

