/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.core.internal.IJpaDataSource;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaNode;
import org.eclipse.jpt.core.internal.JptCorePlugin;
import org.eclipse.jpt.core.internal.content.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.content.java.JpaCompilationUnit;
import org.eclipse.jpt.core.internal.platform.IContext;
import org.eclipse.jpt.db.internal.ConnectionProfile;
import org.eclipse.jpt.utility.internal.CommandExecutor;
import org.eclipse.jpt.utility.internal.CommandExecutorProvider;
import org.eclipse.jpt.utility.internal.iterators.CloneIterator;
import org.eclipse.jpt.utility.internal.iterators.CompositeIterator;
import org.eclipse.jpt.utility.internal.iterators.FilteringIterator;
import org.eclipse.jpt.utility.internal.iterators.TransformationIterator;
import org.eclipse.jpt.utility.internal.model.ChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.model.SimpleChangeEventDispatcher;
import org.eclipse.jpt.utility.internal.node.Node;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaProject
extends JpaNode
implements IJpaProject {
    protected final IProject project;
    protected final IJpaPlatform jpaPlatform;
    protected final IJpaDataSource dataSource;
    protected final Vector<IJpaFile> jpaFiles;
    protected boolean discoversAnnotatedClasses;
    protected final IResourceDeltaVisitor resourceDeltaVisitor;
    protected volatile ChangeEventDispatcher changeEventDispatcher;
    protected final ThreadLocal<CommandExecutor> threadLocalModifySharedDocumentCommandExecutor;
    protected final CommandExecutorProvider modifySharedDocumentCommandExecutorProvider;
    protected final UpdateJpaProjectJobScheduler updateJpaProjectJobScheduler;
    protected static final String WEB_PROJECT_ROOT_DEPLOY_LOCATION = "WEB-INF/classes";
    protected static final String JST_WEB_MODULE = "jst.web";

    public JpaProject(IJpaProject.Config config) throws CoreException {
        super(null);
        if (config.project() == null || config.jpaPlatform() == null) {
            throw new NullPointerException();
        }
        this.project = config.project();
        this.jpaPlatform = config.jpaPlatform();
        this.jpaPlatform.setProject(this);
        this.dataSource = this.jpaFactory().createDataSource(this, config.connectionProfileName());
        this.discoversAnnotatedClasses = config.discoverAnnotatedClasses();
        this.jpaFiles = this.buildJpaFiles();
        this.resourceDeltaVisitor = this.buildResourceDeltaVisitor();
        this.changeEventDispatcher = this.buildChangeEventDispatcher();
        this.threadLocalModifySharedDocumentCommandExecutor = this.buildThreadLocalModifySharedDocumentCommandExecutor();
        this.modifySharedDocumentCommandExecutorProvider = this.buildModifySharedDocumentCommandExecutorProvider();
        this.updateJpaProjectJobScheduler = this.buildUpdateJpaProjectJobScheduler();
        this.project.accept(this.buildInitialResourceProxyVisitor(), 0);
        this.update();
    }

    protected void checkParent(Node parentNode) {
        if (parentNode != null) {
            throw new IllegalArgumentException("The parent node must be null");
        }
    }

    protected Vector<IJpaFile> buildJpaFiles() {
        return new Vector<IJpaFile>();
    }

    protected IResourceDeltaVisitor buildResourceDeltaVisitor() {
        return new ResourceDeltaVisitor();
    }

    protected ChangeEventDispatcher buildChangeEventDispatcher() {
        return SimpleChangeEventDispatcher.instance();
    }

    protected ThreadLocal<CommandExecutor> buildThreadLocalModifySharedDocumentCommandExecutor() {
        return new ThreadLocal<CommandExecutor>();
    }

    protected CommandExecutorProvider buildModifySharedDocumentCommandExecutorProvider() {
        return new ModifySharedDocumentCommandExecutorProvider();
    }

    protected IResourceProxyVisitor buildInitialResourceProxyVisitor() {
        return new InitialResourceProxyVisitor();
    }

    protected UpdateJpaProjectJobScheduler buildUpdateJpaProjectJobScheduler() {
        return new UpdateJpaProjectJobScheduler(this, (ISchedulingRule)this.project);
    }

    @Override
    public IJpaProject root() {
        return this;
    }

    @Override
    public IProject project() {
        return this.project;
    }

    @Override
    public String name() {
        return this.project.getName();
    }

    @Override
    public IJavaProject javaProject() {
        return JavaCore.create((IProject)this.project);
    }

    @Override
    public IJpaPlatform jpaPlatform() {
        return this.jpaPlatform;
    }

    @Override
    public IJpaDataSource dataSource() {
        return this.dataSource;
    }

    @Override
    public ConnectionProfile connectionProfile() {
        return this.dataSource.getConnectionProfile();
    }

    public Node.Validator validator() {
        return NULL_VALIDATOR;
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name());
    }

    @Override
    public Iterator<IJpaFile> jpaFiles() {
        return new CloneIterator(this.jpaFiles);
    }

    @Override
    public int jpaFilesSize() {
        return this.jpaFiles.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJpaFile jpaFile(IFile file) {
        Vector<IJpaFile> vector = this.jpaFiles;
        synchronized (vector) {
            for (IJpaFile jpaFile : this.jpaFiles) {
                if (!jpaFile.getFile().equals((Object)file)) continue;
                return jpaFile;
            }
        }
        return null;
    }

    @Override
    public Iterator<IJpaFile> jpaFiles(final String contentTypeId) {
        return new FilteringIterator<IJpaFile>(this.jpaFiles()){

            protected boolean accept(Object o) {
                return ((IJpaFile)o).getContentId().equals(contentTypeId);
            }
        };
    }

    @Override
    public Iterator<IJpaFile> javaJpaFiles() {
        return this.jpaFiles("org.eclipse.jdt.core.javaSource");
    }

    protected void addJpaFile(IFile file) {
        IJpaFile jpaFile = this.jpaPlatform.createJpaFile(this, file);
        if (jpaFile != null) {
            this.addItemToCollection(jpaFile, this.jpaFiles, "jpaFiles");
        }
    }

    protected void removeJpaFile(IJpaFile jpaFile) {
        if (!this.removeItemFromCollection(jpaFile, this.jpaFiles, "jpaFiles")) {
            throw new IllegalArgumentException("JPA file: " + jpaFile.getFile().getName());
        }
        jpaFile.dispose();
    }

    protected boolean containsJpaFile(IFile file) {
        return this.jpaFile(file) != null;
    }

    public ChangeEventDispatcher changeEventDispatcher() {
        return this.changeEventDispatcher;
    }

    public void setChangeEventDispatcher(ChangeEventDispatcher changeEventDispatcher) {
        this.changeEventDispatcher = changeEventDispatcher;
    }

    protected Iterator<JpaCompilationUnit> jpaCompilationUnits() {
        return new TransformationIterator<IJpaFile, JpaCompilationUnit>(this.javaJpaFiles()){

            protected JpaCompilationUnit transform(IJpaFile jpaFile) {
                return (JpaCompilationUnit)jpaFile.getContent();
            }
        };
    }

    protected Iterator<Iterator<JavaPersistentType>> javaPersistentTypeIterators() {
        return new TransformationIterator<JpaCompilationUnit, Iterator<JavaPersistentType>>(this.jpaCompilationUnits()){

            protected Iterator<JavaPersistentType> transform(JpaCompilationUnit jcu) {
                return jcu.getTypes().iterator();
            }
        };
    }

    @Override
    public Iterator<JavaPersistentType> javaPersistentTypes() {
        return new CompositeIterator(this.javaPersistentTypeIterators());
    }

    @Override
    public JavaPersistentType javaPersistentType(IType type) {
        Iterator<JavaPersistentType> stream = this.javaPersistentTypes();
        while (stream.hasNext()) {
            JavaPersistentType jpt = stream.next();
            if (!jpt.getType().getJdtMember().equals(type)) continue;
            return jpt;
        }
        return null;
    }

    @Override
    public void javaElementChanged(ElementChangedEvent event) {
        Iterator<IJpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            stream.next().javaElementChanged(event);
        }
    }

    @Override
    public Iterator<IMessage> validationMessages() {
        ArrayList<IMessage> messages = new ArrayList<IMessage>();
        this.jpaPlatform.addToMessages(messages);
        return messages.iterator();
    }

    @Override
    public String rootDeployLocation() {
        return this.isWebProject() ? WEB_PROJECT_ROOT_DEPLOY_LOCATION : "";
    }

    protected boolean isWebProject() {
        return JptCorePlugin.projectHasWebFacet(this.project);
    }

    @Override
    public boolean discoversAnnotatedClasses() {
        return this.discoversAnnotatedClasses;
    }

    @Override
    public void setDiscoversAnnotatedClasses(boolean discoversAnnotatedClasses) {
        boolean old = this.discoversAnnotatedClasses;
        this.discoversAnnotatedClasses = discoversAnnotatedClasses;
        this.firePropertyChanged("discoversAnnotatedClasses", old, discoversAnnotatedClasses);
    }

    @Override
    public void dispose() {
        this.updateJpaProjectJobScheduler.dispose();
        Iterator<IJpaFile> stream = this.jpaFiles();
        while (stream.hasNext()) {
            this.removeJpaFile(stream.next());
        }
        this.dataSource.dispose();
    }

    @Override
    public void synchronizeJpaFiles(IResourceDelta delta) throws CoreException {
        delta.accept(this.resourceDeltaVisitor);
    }

    protected void synchronizeJpaFile(IFile file, int deltaKind) {
        switch (deltaKind) {
            case 1: {
                if (this.containsJpaFile(file)) break;
                this.addJpaFile(file);
                break;
            }
            case 2: {
                IJpaFile jpaFile = this.jpaFile(file);
                if (jpaFile == null) break;
                this.removeJpaFile(jpaFile);
                break;
            }
        }
    }

    protected CommandExecutor threadLocalModifySharedDocumentCommandExecutor() {
        CommandExecutor ce = this.threadLocalModifySharedDocumentCommandExecutor.get();
        return ce != null ? ce : CommandExecutor.Default.instance();
    }

    @Override
    public void setThreadLocalModifySharedDocumentCommandExecutor(CommandExecutor commandExecutor) {
        this.threadLocalModifySharedDocumentCommandExecutor.set(commandExecutor);
    }

    @Override
    public CommandExecutorProvider modifySharedDocumentCommandExecutorProvider() {
        return this.modifySharedDocumentCommandExecutorProvider;
    }

    @Override
    public IStatus update(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        try {
            IContext contextHierarchy = this.jpaPlatform.buildProjectContext();
            this.jpaPlatform.resynch(contextHierarchy, monitor);
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Throwable ex) {
            JptCorePlugin.log(ex);
        }
        return Status.OK_STATUS;
    }

    @Override
    public void update() {
        this.updateJpaProjectJobScheduler.schedule();
    }

    protected class InitialResourceProxyVisitor
    implements IResourceProxyVisitor {
        protected InitialResourceProxyVisitor() {
        }

        public boolean visit(IResourceProxy resource) throws CoreException {
            switch (resource.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    JpaProject.this.addJpaFile((IFile)resource.requestResource());
                    return false;
                }
            }
            return false;
        }
    }

    protected class ModifySharedDocumentCommandExecutorProvider
    implements CommandExecutorProvider {
        protected ModifySharedDocumentCommandExecutorProvider() {
        }

        public CommandExecutor commandExecutor() {
            return JpaProject.this.threadLocalModifySharedDocumentCommandExecutor();
        }
    }

    protected class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        protected ResourceDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource res = delta.getResource();
            switch (res.getType()) {
                case 2: 
                case 4: 
                case 8: {
                    return true;
                }
                case 1: {
                    JpaProject.this.synchronizeJpaFile((IFile)res, delta.getKind());
                    return false;
                }
            }
            return false;
        }
    }

    protected static class UpdateJpaProjectJobScheduler {
        protected Job job;

        protected UpdateJpaProjectJobScheduler(IJpaProject jpaProject, ISchedulingRule rule) {
            this.job = this.buildJob(jpaProject, rule);
        }

        protected Job buildJob(IJpaProject jpaProject, ISchedulingRule rule) {
            UpdateJpaProjectJob j = new UpdateJpaProjectJob(jpaProject);
            j.setRule(rule);
            return j;
        }

        protected synchronized void schedule() {
            if (this.job != null) {
                this.job.cancel();
                this.job.schedule();
            }
        }

        protected synchronized void scheduleAndWait() {
            if (this.job != null) {
                this.job.cancel();
                this.join();
                this.job.schedule();
                this.join();
            }
        }

        protected synchronized void dispose() {
            if (this.job != null) {
                this.job.cancel();
                this.join();
                this.job = null;
            }
        }

        protected synchronized void join() {
            try {
                this.job.join();
            }
            catch (InterruptedException interruptedException) {}
        }

        protected static class UpdateJpaProjectJob
        extends Job {
            protected final IJpaProject jpaProject;

            protected UpdateJpaProjectJob(IJpaProject jpaProject) {
                super("Update JPA project");
                this.jpaProject = jpaProject;
            }

            protected IStatus run(IProgressMonitor monitor) {
                return this.jpaProject.update(monitor);
            }
        }
    }
}

