/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jpt.core.internal.IJpaFile;
import org.eclipse.jpt.core.internal.IJpaModel;
import org.eclipse.jpt.core.internal.IJpaPlatform;
import org.eclipse.jpt.core.internal.IJpaProject;
import org.eclipse.jpt.core.internal.JpaModelManager;
import org.eclipse.jpt.core.internal.JpaPlatformRegistry;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.BackingStoreException;

public class JptCorePlugin
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.jpt.core";
    public static final String FACET_ID = "jpt.jpa";
    public static final String JPA_PLATFORM = "org.eclipse.jpt.core.platform";
    public static final String DISCOVER_ANNOTATED_CLASSES = "org.eclipse.jpt.core.discoverAnnotatedClasses";
    public static final QualifiedName DATA_SOURCE_CONNECTION_PROFILE_NAME = new QualifiedName("org.eclipse.jpt.core", "dataSource.connectionProfileName");
    public static final String VALIDATION_MARKER_ID = "org.eclipse.jpt.core.jpaProblemMarker";
    public static final String ORM_XML_CONTENT_TYPE = "org.eclipse.jpt.core.content.orm";
    public static final String PERSISTENCE_XML_CONTENT_TYPE = "org.eclipse.jpt.core.content.persistence";
    public static final String WEB_PROJECT_FACET_ID = "jst.web";
    public static final String WEB_PROJECT_DEPLOY_PREFIX = "WEB-INF/classes";
    public static final String DEFAULT_PERSISTENCE_XML_FILE_PATH = "META-INF/persistence.xml";
    public static final String DEFAULT_ORM_XML_FILE_PATH = "META-INF/orm.xml";
    private static JptCorePlugin INSTANCE;

    public static JptCorePlugin instance() {
        return INSTANCE;
    }

    public static IJpaModel jpaModel() {
        return JpaModelManager.instance().jpaModel();
    }

    public static IJpaProject jpaProject(IProject project) {
        try {
            return JpaModelManager.instance().jpaProject(project);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static IJpaFile jpaFile(IFile file) {
        try {
            return JpaModelManager.instance().jpaFile(file);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static boolean projectHasJpaFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, FACET_ID);
    }

    public static boolean projectHasWebFacet(IProject project) {
        return JptCorePlugin.projectHasFacet(project, WEB_PROJECT_FACET_ID);
    }

    private static boolean projectHasFacet(IProject project, String facetId) {
        try {
            return FacetedProjectFramework.hasProjectFacet((IProject)project, (String)facetId);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return false;
        }
    }

    public static String persistenceXmlDeploymentURI(IProject project) {
        return JptCorePlugin.deploymentURI(project, DEFAULT_PERSISTENCE_XML_FILE_PATH);
    }

    public static String ormXmlDeploymentURI(IProject project) {
        return JptCorePlugin.deploymentURI(project, DEFAULT_ORM_XML_FILE_PATH);
    }

    private static String deploymentURI(IProject project, String defaultURI) {
        return JptCorePlugin.projectHasWebFacet(project) ? "WEB-INF/classes/" + defaultURI : defaultURI;
    }

    public static IEclipsePreferences preferences(IProject project) {
        ProjectScope context = new ProjectScope(project);
        return context.getNode(PLUGIN_ID);
    }

    public static IJpaPlatform jpaPlatform(IProject project) {
        return JpaPlatformRegistry.instance().jpaPlatform(JptCorePlugin.jpaPlatformId(project));
    }

    public static String jpaPlatformId(IProject project) {
        return JptCorePlugin.preferences(project).get(JPA_PLATFORM, "generic");
    }

    public static void setJpaPlatformId(IProject project, String jpaPlatformId) {
        IEclipsePreferences prefs = JptCorePlugin.preferences(project);
        prefs.put(JPA_PLATFORM, jpaPlatformId);
        JptCorePlugin.flush(prefs);
    }

    public static boolean discoverAnnotatedClasses(IProject project) {
        return JptCorePlugin.preferences(project).getBoolean(DISCOVER_ANNOTATED_CLASSES, false);
    }

    public static void setDiscoverAnnotatedClasses(IProject project, boolean discoverAnnotatedClasses) {
        IEclipsePreferences prefs = JptCorePlugin.preferences(project);
        prefs.putBoolean(DISCOVER_ANNOTATED_CLASSES, discoverAnnotatedClasses);
        JptCorePlugin.flush(prefs);
    }

    private static void flush(IEclipsePreferences prefs) {
        try {
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static String connectionProfileName(IProject project) {
        try {
            return project.getPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
            return null;
        }
    }

    public static void setConnectionProfileName(IProject project, String connectionProfileName) {
        try {
            project.setPersistentProperty(DATA_SOURCE_CONNECTION_PROFILE_NAME, connectionProfileName);
        }
        catch (CoreException ex) {
            JptCorePlugin.log(ex);
        }
    }

    public static void log(IStatus status) {
        INSTANCE.getLog().log(status);
    }

    public static void log(String msg) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, msg, null));
    }

    public static void log(Throwable throwable) {
        JptCorePlugin.log((IStatus)new Status(4, PLUGIN_ID, 0, throwable.getLocalizedMessage(), throwable));
    }

    public JptCorePlugin() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        JpaModelManager.instance().start();
    }

    public void stop(BundleContext context) throws Exception {
        try {
            JpaModelManager.instance().stop();
        }
        finally {
            super.stop(context);
        }
    }
}

