/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntAnnotationElementAdapter {
    private final AnnotationElementAdapter<String> adapter;

    public IntAnnotationElementAdapter(AnnotationElementAdapter<String> adapter) {
        this.adapter = adapter;
    }

    public ASTNode astNode() {
        return this.adapter.astNode();
    }

    public ASTNode astNode(CompilationUnit astRoot) {
        return this.adapter.astNode(astRoot);
    }

    public int getValue() {
        return this.convertStringToInt(this.adapter.getValue());
    }

    public int getValue(CompilationUnit astRoot) {
        return this.convertStringToInt(this.adapter.getValue(astRoot));
    }

    protected int convertStringToInt(String stringValue) {
        if (stringValue == null) {
            return -1;
        }
        try {
            int intValue = Integer.parseInt(stringValue);
            return intValue >= 0 ? intValue : -1;
        }
        catch (NumberFormatException numberFormatException) {
            return -1;
        }
    }

    public void setValue(int value) {
        this.adapter.setValue(this.convertIntToValue(value));
    }

    protected String convertIntToValue(int intValue) {
        return this.convertIntToString(intValue);
    }

    protected String convertIntToString(int intValue) {
        return intValue >= 0 ? Integer.toString(intValue) : null;
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, this.adapter);
    }
}

