/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.IJavaBasic;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.BooleanAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.BooleanStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleBooleanAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.DefaultEagerFetchType;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.EnumType;
import org.eclipse.jpt.core.internal.mappings.IBasic;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBasic
extends JavaAttributeMapping
implements IJavaBasic {
    private final AnnotationElementAdapter<String> optionalAdapter;
    private final AnnotationElementAdapter<String> fetchAdapter;
    private final AnnotationAdapter temporalAnnotationAdapter;
    private final AnnotationElementAdapter<String> temporalValueAdapter;
    private final AnnotationAdapter enumeratedAnnotationAdapter;
    private final AnnotationElementAdapter<String> enumeratedValueAdapter;
    private final BooleanAnnotationAdapter lobAdapter;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Basic");
    private static final DeclarationAnnotationElementAdapter<String> OPTIONAL_ADAPTER = JavaBasic.buildOptionalAdapter();
    private static final DeclarationAnnotationElementAdapter<String> FETCH_ADAPTER = JavaBasic.buildFetchAdapter();
    public static final DeclarationAnnotationAdapter TEMPORAL_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Temporal");
    private static final DeclarationAnnotationElementAdapter<String> TEMPORAL_VALUE_ADAPTER = JavaBasic.buildTemporalValueAdapter();
    public static final DeclarationAnnotationAdapter ENUMERATED_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Enumerated");
    private static final DeclarationAnnotationElementAdapter<String> ENUMERATED_VALUE_ADAPTER = JavaBasic.buildEnumeratedValueAdapter();
    public static final DeclarationAnnotationAdapter LOB_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Lob");
    protected static final DefaultEagerFetchType FETCH_EDEFAULT = DefaultEagerFetchType.DEFAULT;
    protected DefaultEagerFetchType fetch = FETCH_EDEFAULT;
    protected static final DefaultTrueBoolean OPTIONAL_EDEFAULT = DefaultTrueBoolean.DEFAULT;
    protected DefaultTrueBoolean optional = OPTIONAL_EDEFAULT;
    protected IColumn column;
    protected static final boolean LOB_EDEFAULT = false;
    protected boolean lob = false;
    protected static final TemporalType TEMPORAL_EDEFAULT = TemporalType.NULL;
    protected TemporalType temporal = TEMPORAL_EDEFAULT;
    protected static final EnumType ENUMERATED_EDEFAULT = EnumType.DEFAULT;
    protected EnumType enumerated = ENUMERATED_EDEFAULT;

    protected JavaBasic() {
        this(null);
    }

    protected JavaBasic(Attribute attribute) {
        super(attribute);
        this.column = JavaColumn.createColumnMappingColumn(this.buildColumnOwner(), this.getAttribute());
        ((InternalEObject)this.column).eInverseAdd((InternalEObject)this, -3, null, null);
        this.optionalAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, OPTIONAL_ADAPTER);
        this.fetchAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, FETCH_ADAPTER);
        this.lobAdapter = new SimpleBooleanAnnotationAdapter(new MemberAnnotationAdapter(attribute, LOB_ADAPTER));
        this.temporalAnnotationAdapter = new MemberAnnotationAdapter(this.getAttribute(), TEMPORAL_ADAPTER);
        this.temporalValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, TEMPORAL_VALUE_ADAPTER);
        this.enumeratedAnnotationAdapter = new MemberAnnotationAdapter(this.getAttribute(), ENUMERATED_ADAPTER);
        this.enumeratedValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, ENUMERATED_VALUE_ADAPTER);
    }

    @Override
    protected DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return DECLARATION_ANNOTATION_ADAPTER;
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IBasic.class)) {
            case 0: {
                this.fetchAdapter.setValue(((DefaultEagerFetchType)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 1: {
                this.optionalAdapter.setValue(((DefaultTrueBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 3: {
                this.lobAdapter.setValue(notification.getNewBooleanValue());
                break;
            }
            case 4: {
                TemporalType newTemporal = (TemporalType)((Object)notification.getNewValue());
                if (newTemporal == TemporalType.NULL) {
                    this.temporalAnnotationAdapter.removeAnnotation();
                    break;
                }
                this.temporalValueAdapter.setValue(newTemporal.convertToJavaAnnotationValue());
                break;
            }
            case 5: {
                EnumType newEnumerated = (EnumType)((Object)notification.getNewValue());
                if (newEnumerated == EnumType.DEFAULT) {
                    this.enumeratedAnnotationAdapter.removeAnnotation();
                    break;
                }
                this.enumeratedValueAdapter.setValue(newEnumerated.convertToJavaAnnotationValue());
                break;
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_BASIC;
    }

    @Override
    public IColumn getColumn() {
        return this.column;
    }

    public NotificationChain basicSetColumn(IColumn newColumn, NotificationChain msgs) {
        IColumn oldColumn = this.column;
        this.column = newColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldColumn, (Object)newColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public DefaultEagerFetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(DefaultEagerFetchType newFetch) {
        DefaultEagerFetchType oldFetch = this.fetch;
        DefaultEagerFetchType defaultEagerFetchType = this.fetch = newFetch == null ? FETCH_EDEFAULT : newFetch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldFetch, (Object)this.fetch));
        }
    }

    @Override
    public DefaultTrueBoolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(DefaultTrueBoolean newOptional) {
        DefaultTrueBoolean oldOptional = this.optional;
        DefaultTrueBoolean defaultTrueBoolean = this.optional = newOptional == null ? OPTIONAL_EDEFAULT : newOptional;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldOptional, (Object)this.optional));
        }
    }

    @Override
    public boolean isLob() {
        return this.lob;
    }

    @Override
    public void setLob(boolean newLob) {
        boolean oldLob = this.lob;
        this.lob = newLob;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, oldLob, this.lob));
        }
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        TemporalType temporalType = this.temporal = newTemporal == null ? TEMPORAL_EDEFAULT : newTemporal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldTemporal, (Object)this.temporal));
        }
    }

    @Override
    public EnumType getEnumerated() {
        return this.enumerated;
    }

    @Override
    public void setEnumerated(EnumType newEnumerated) {
        EnumType oldEnumerated = this.enumerated;
        EnumType enumType = this.enumerated = newEnumerated == null ? ENUMERATED_EDEFAULT : newEnumerated;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldEnumerated, (Object)this.enumerated));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return this.basicSetColumn(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getFetch();
            }
            case 1: {
                return this.getOptional();
            }
            case 2: {
                return this.getColumn();
            }
            case 3: {
                return this.isLob() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return this.getTemporal();
            }
            case 5: {
                return this.getEnumerated();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setFetch((DefaultEagerFetchType)((Object)newValue));
                return;
            }
            case 1: {
                this.setOptional((DefaultTrueBoolean)((Object)newValue));
                return;
            }
            case 3: {
                this.setLob((Boolean)newValue);
                return;
            }
            case 4: {
                this.setTemporal((TemporalType)((Object)newValue));
                return;
            }
            case 5: {
                this.setEnumerated((EnumType)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setFetch(FETCH_EDEFAULT);
                return;
            }
            case 1: {
                this.setOptional(OPTIONAL_EDEFAULT);
                return;
            }
            case 3: {
                this.setLob(false);
                return;
            }
            case 4: {
                this.setTemporal(TEMPORAL_EDEFAULT);
                return;
            }
            case 5: {
                this.setEnumerated(ENUMERATED_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.fetch != FETCH_EDEFAULT;
            }
            case 1: {
                return this.optional != OPTIONAL_EDEFAULT;
            }
            case 2: {
                return this.column != null;
            }
            case 3: {
                return this.lob;
            }
            case 4: {
                return this.temporal != TEMPORAL_EDEFAULT;
            }
            case 5: {
                return this.enumerated != ENUMERATED_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IBasic.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return -1;
        }
        if (baseClass == IJavaBasic.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IBasic.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
            }
            return -1;
        }
        if (baseClass == IJavaBasic.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fetch: ");
        result.append((Object)this.fetch);
        result.append(", optional: ");
        result.append((Object)this.optional);
        result.append(", lob: ");
        result.append(this.lob);
        result.append(", temporal: ");
        result.append((Object)this.temporal);
        result.append(", enumerated: ");
        result.append((Object)this.enumerated);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getKey() {
        return "basic";
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.setOptional(DefaultTrueBoolean.fromJavaAnnotationValue(this.optionalAdapter.getValue(astRoot)));
        this.setFetch(DefaultEagerFetchType.fromJavaAnnotationValue(this.fetchAdapter.getValue(astRoot)));
        this.getJavaColumn().updateFromJava(astRoot);
        this.setLob(this.lobAdapter.getValue(astRoot));
        this.updateTemporalFromJava(astRoot);
        this.updateEnumeratedFromJava(astRoot);
    }

    private JavaColumn getJavaColumn() {
        return (JavaColumn)this.column;
    }

    private void updateTemporalFromJava(CompilationUnit astRoot) {
        if (this.temporalAnnotationAdapter.getAnnotation(astRoot) == null) {
            this.setTemporal(TemporalType.NULL);
        } else {
            this.setTemporal(TemporalType.fromJavaAnnotationValue(this.temporalValueAdapter.getValue(astRoot)));
        }
    }

    private void updateEnumeratedFromJava(CompilationUnit astRoot) {
        if (this.enumeratedAnnotationAdapter.getAnnotation(astRoot) == null) {
            this.setEnumerated(EnumType.DEFAULT);
        } else {
            this.setEnumerated(EnumType.fromJavaAnnotationValue(this.enumeratedValueAdapter.getValue(astRoot)));
        }
    }

    private static DeclarationAnnotationElementAdapter<String> buildOptionalAdapter() {
        return new ConversionDeclarationAnnotationElementAdapter<String>(DECLARATION_ANNOTATION_ADAPTER, "optional", false, BooleanStringExpressionConverter.instance());
    }

    private static DeclarationAnnotationElementAdapter<String> buildFetchAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(DECLARATION_ANNOTATION_ADAPTER, "fetch", false);
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getJavaColumn().candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static DeclarationAnnotationElementAdapter<String> buildTemporalValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(TEMPORAL_ADAPTER, "value", false);
    }

    private static DeclarationAnnotationElementAdapter<String> buildEnumeratedValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(ENUMERATED_ADAPTER, "value", false);
    }
}

