/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.IJavaId;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaGeneratedValue;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaSequenceGenerator;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaTableGenerator;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.mappings.IGeneratedValue;
import org.eclipse.jpt.core.internal.mappings.IId;
import org.eclipse.jpt.core.internal.mappings.ISequenceGenerator;
import org.eclipse.jpt.core.internal.mappings.ITableGenerator;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaId
extends JavaAttributeMapping
implements IJavaId {
    private AnnotationAdapter generatedValueAnnotationAdapter;
    private AnnotationAdapter tableGeneratorAnnotationAdapter;
    private AnnotationAdapter sequenceGeneratorAnnotationAdapter;
    private final AnnotationAdapter temporalAnnotationAdapter;
    private final AnnotationElementAdapter<String> temporalValueAdapter;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Id");
    private static final DeclarationAnnotationAdapter TEMPORAL_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Temporal");
    private static final DeclarationAnnotationElementAdapter<String> TEMPORAL_VALUE_ADAPTER = JavaId.buildTemporalValueAdapter();
    protected IColumn column;
    protected IGeneratedValue generatedValue;
    protected static final TemporalType TEMPORAL_EDEFAULT = TemporalType.NULL;
    protected TemporalType temporal = TEMPORAL_EDEFAULT;
    protected ITableGenerator tableGenerator;
    protected ISequenceGenerator sequenceGenerator;

    protected JavaId() {
        throw new UnsupportedOperationException("Use JavaId(Attribute) instead");
    }

    protected JavaId(Attribute attribute) {
        super(attribute);
        this.column = JavaColumn.createColumnMappingColumn(this.buildColumnOwner(), this.getAttribute());
        ((InternalEObject)this.column).eInverseAdd((InternalEObject)this, -1, null, null);
        this.temporalAnnotationAdapter = new MemberAnnotationAdapter(this.getAttribute(), TEMPORAL_ADAPTER);
        this.temporalValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, TEMPORAL_VALUE_ADAPTER);
        this.generatedValueAnnotationAdapter = this.buildAnnotationAdapter(JavaGeneratedValue.DECLARATION_ANNOTATION_ADAPTER);
        this.tableGeneratorAnnotationAdapter = this.buildAnnotationAdapter(JavaTableGenerator.DECLARATION_ANNOTATION_ADAPTER);
        this.sequenceGeneratorAnnotationAdapter = this.buildAnnotationAdapter(JavaSequenceGenerator.DECLARATION_ANNOTATION_ADAPTER);
    }

    @Override
    protected DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return DECLARATION_ANNOTATION_ADAPTER;
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(IId.class)) {
            case 3: {
                JavaId.attributeChanged(notification.getNewValue(), this.tableGeneratorAnnotationAdapter);
                break;
            }
            case 4: {
                JavaId.attributeChanged(notification.getNewValue(), this.sequenceGeneratorAnnotationAdapter);
                break;
            }
            case 1: {
                JavaId.attributeChanged(notification.getNewValue(), this.generatedValueAnnotationAdapter);
            }
        }
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_ID;
    }

    @Override
    public IColumn getColumn() {
        return this.column;
    }

    public NotificationChain basicSetColumn(IColumn newColumn, NotificationChain msgs) {
        IColumn oldColumn = this.column;
        this.column = newColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldColumn, (Object)newColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public IGeneratedValue getGeneratedValue() {
        return this.generatedValue;
    }

    public NotificationChain basicSetGeneratedValue(IGeneratedValue newGeneratedValue, NotificationChain msgs) {
        IGeneratedValue oldGeneratedValue = this.generatedValue;
        this.generatedValue = newGeneratedValue;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldGeneratedValue, (Object)newGeneratedValue);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setGeneratedValue(IGeneratedValue newGeneratedValue) {
        if (newGeneratedValue != this.generatedValue) {
            NotificationChain msgs = null;
            if (this.generatedValue != null) {
                msgs = ((InternalEObject)this.generatedValue).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newGeneratedValue != null) {
                msgs = ((InternalEObject)newGeneratedValue).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetGeneratedValue(newGeneratedValue, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newGeneratedValue, (Object)newGeneratedValue));
        }
    }

    private static void attributeChanged(Object value, AnnotationAdapter annotationAdapter) {
        Annotation annotation = annotationAdapter.getAnnotation();
        if (value == null) {
            if (annotation != null) {
                annotationAdapter.removeAnnotation();
            }
        } else if (annotation == null) {
            annotationAdapter.newMarkerAnnotation();
        }
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    public void setTemporalGen(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        TemporalType temporalType = this.temporal = newTemporal == null ? TEMPORAL_EDEFAULT : newTemporal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldTemporal, (Object)this.temporal));
        }
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        if (newTemporal != TemporalType.NULL) {
            if (this.temporalAnnotationAdapter.getAnnotation() == null) {
                this.temporalAnnotationAdapter.newMarkerAnnotation();
            }
            this.temporalValueAdapter.setValue(newTemporal.convertToJavaAnnotationValue());
        } else if (this.temporalAnnotationAdapter.getAnnotation() != null) {
            this.temporalAnnotationAdapter.removeAnnotation();
        }
        this.setTemporalGen(newTemporal);
    }

    @Override
    public ITableGenerator getTableGenerator() {
        return this.tableGenerator;
    }

    public NotificationChain basicSetTableGenerator(ITableGenerator newTableGenerator, NotificationChain msgs) {
        ITableGenerator oldTableGenerator = this.tableGenerator;
        this.tableGenerator = newTableGenerator;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTableGenerator, (Object)newTableGenerator);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setTableGenerator(ITableGenerator newTableGenerator) {
        if (newTableGenerator != this.tableGenerator) {
            NotificationChain msgs = null;
            if (this.tableGenerator != null) {
                msgs = ((InternalEObject)this.tableGenerator).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newTableGenerator != null) {
                msgs = ((InternalEObject)newTableGenerator).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetTableGenerator(newTableGenerator, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newTableGenerator, (Object)newTableGenerator));
        }
    }

    @Override
    public ISequenceGenerator getSequenceGenerator() {
        return this.sequenceGenerator;
    }

    public NotificationChain basicSetSequenceGenerator(ISequenceGenerator newSequenceGenerator, NotificationChain msgs) {
        ISequenceGenerator oldSequenceGenerator = this.sequenceGenerator;
        this.sequenceGenerator = newSequenceGenerator;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldSequenceGenerator, (Object)newSequenceGenerator);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setSequenceGenerator(ISequenceGenerator newSequenceGenerator) {
        if (newSequenceGenerator != this.sequenceGenerator) {
            NotificationChain msgs = null;
            if (this.sequenceGenerator != null) {
                msgs = ((InternalEObject)this.sequenceGenerator).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newSequenceGenerator != null) {
                msgs = ((InternalEObject)newSequenceGenerator).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetSequenceGenerator(newSequenceGenerator, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newSequenceGenerator, (Object)newSequenceGenerator));
        }
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetColumn(null, msgs);
            }
            case 1: {
                return this.basicSetGeneratedValue(null, msgs);
            }
            case 3: {
                return this.basicSetTableGenerator(null, msgs);
            }
            case 4: {
                return this.basicSetSequenceGenerator(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getColumn();
            }
            case 1: {
                return this.getGeneratedValue();
            }
            case 2: {
                return this.getTemporal();
            }
            case 3: {
                return this.getTableGenerator();
            }
            case 4: {
                return this.getSequenceGenerator();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setGeneratedValue((IGeneratedValue)newValue);
                return;
            }
            case 2: {
                this.setTemporal((TemporalType)((Object)newValue));
                return;
            }
            case 3: {
                this.setTableGenerator((ITableGenerator)newValue);
                return;
            }
            case 4: {
                this.setSequenceGenerator((ISequenceGenerator)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setGeneratedValue(null);
                return;
            }
            case 2: {
                this.setTemporal(TEMPORAL_EDEFAULT);
                return;
            }
            case 3: {
                this.setTableGenerator(null);
                return;
            }
            case 4: {
                this.setSequenceGenerator(null);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.column != null;
            }
            case 1: {
                return this.generatedValue != null;
            }
            case 2: {
                return this.temporal != TEMPORAL_EDEFAULT;
            }
            case 3: {
                return this.tableGenerator != null;
            }
            case 4: {
                return this.sequenceGenerator != null;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IId.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return -1;
        }
        if (baseClass == IJavaId.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IId.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
            }
            return -1;
        }
        if (baseClass == IJavaId.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (temporal: ");
        result.append((Object)this.temporal);
        result.append(')');
        return result.toString();
    }

    @Override
    public String getKey() {
        return "id";
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateTemporalFromJava(astRoot);
        this.getJavaColumn().updateFromJava(astRoot);
        this.updateGeneratedValueFromJava(astRoot);
        this.updateTableGeneratorFromJava(astRoot);
        this.updateSequenceGeneratorFromJava(astRoot);
    }

    private void updateGeneratedValueFromJava(CompilationUnit astRoot) {
        if (this.generatedValueAnnotationAdapter.getAnnotation(astRoot) == null) {
            if (this.getGeneratedValue() != null) {
                this.setGeneratedValue(null);
            }
        } else {
            if (this.getGeneratedValue() == null) {
                this.setGeneratedValue(this.createGeneratedValue());
            }
            ((JavaGeneratedValue)this.getGeneratedValue()).updateFromJava(astRoot);
        }
    }

    private void updateTableGeneratorFromJava(CompilationUnit astRoot) {
        if (this.tableGeneratorAnnotationAdapter.getAnnotation(astRoot) == null) {
            if (this.getTableGenerator() != null) {
                this.setTableGenerator(null);
            }
        } else {
            if (this.getTableGenerator() == null) {
                this.setTableGenerator(this.createTableGenerator());
            }
            ((JavaTableGenerator)this.getTableGenerator()).updateFromJava(astRoot);
        }
    }

    private void updateSequenceGeneratorFromJava(CompilationUnit astRoot) {
        if (this.sequenceGeneratorAnnotationAdapter.getAnnotation(astRoot) == null) {
            if (this.getSequenceGenerator() != null) {
                this.setSequenceGenerator(null);
            }
        } else {
            if (this.getSequenceGenerator() == null) {
                this.setSequenceGenerator(this.createSequenceGenerator());
            }
            ((JavaSequenceGenerator)this.getSequenceGenerator()).updateFromJava(astRoot);
        }
    }

    private void updateTemporalFromJava(CompilationUnit astRoot) {
        if (this.temporalAnnotationAdapter.getAnnotation(astRoot) == null) {
            this.setTemporalGen(TemporalType.NULL);
        } else {
            this.setTemporalGen(TemporalType.fromJavaAnnotationValue(this.temporalValueAdapter.getValue(astRoot)));
        }
    }

    private JavaColumn getJavaColumn() {
        return (JavaColumn)this.column;
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getJavaColumn().candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public String primaryKeyColumnName() {
        return this.getColumn().getName();
    }

    @Override
    public IGeneratedValue createGeneratedValue() {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaGeneratedValue(this.getAttribute());
    }

    @Override
    public ISequenceGenerator createSequenceGenerator() {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaSequenceGenerator(this.getAttribute());
    }

    @Override
    public ITableGenerator createTableGenerator() {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaTableGenerator(this.getAttribute());
    }

    @Override
    public boolean isOverridableAttributeMapping() {
        return true;
    }

    @Override
    public boolean isIdMapping() {
        return true;
    }

    private static DeclarationAnnotationElementAdapter<String> buildTemporalValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(TEMPORAL_ADAPTER, "value", false);
    }
}

