/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaJoinColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaRelationshipMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsFactory;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.BooleanStringExpressionConverter;
import org.eclipse.jpt.core.internal.jdtutility.ConversionDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Member;
import org.eclipse.jpt.core.internal.mappings.DefaultEagerFetchType;
import org.eclipse.jpt.core.internal.mappings.DefaultTrueBoolean;
import org.eclipse.jpt.core.internal.mappings.IJoinColumn;
import org.eclipse.jpt.core.internal.mappings.ISingleRelationshipMapping;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JavaSingleRelationshipMapping
extends JavaRelationshipMapping
implements ISingleRelationshipMapping {
    protected static final DefaultEagerFetchType FETCH_EDEFAULT = DefaultEagerFetchType.DEFAULT;
    protected DefaultEagerFetchType fetch = FETCH_EDEFAULT;
    protected EList<IJoinColumn> specifiedJoinColumns;
    protected EList<IJoinColumn> defaultJoinColumns;
    protected static final DefaultTrueBoolean OPTIONAL_EDEFAULT = DefaultTrueBoolean.DEFAULT;
    protected DefaultTrueBoolean optional = OPTIONAL_EDEFAULT;
    private AnnotationElementAdapter<String> optionalAdapter;

    protected JavaSingleRelationshipMapping() {
        throw new UnsupportedOperationException("Use JavaSingleRelationshipMapping(Attribute) instead");
    }

    protected JavaSingleRelationshipMapping(Attribute attribute) {
        super(attribute);
        this.optionalAdapter = this.buildAnnotationElementAdapter(this.optionalAdapter());
        this.getDefaultJoinColumns().add((Object)this.createJoinColumn(new ISingleRelationshipMapping.JoinColumnOwner(this), attribute));
    }

    private IJoinColumn createJoinColumn(IJoinColumn.Owner joinColumnOwner, Member member) {
        return JpaJavaMappingsFactory.eINSTANCE.createJavaJoinColumn(joinColumnOwner, member);
    }

    @Override
    protected void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        switch (notification.getFeatureID(ISingleRelationshipMapping.class)) {
            case 9: {
                this.optionalAdapter.setValue(((DefaultTrueBoolean)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
            case 7: {
                this.specifiedJoinColumnsChanged(notification);
                break;
            }
            case 5: {
                this.getFetchAdapter().setValue(((DefaultEagerFetchType)((Object)notification.getNewValue())).convertToJavaAnnotationValue());
                break;
            }
        }
    }

    void specifiedJoinColumnsChanged(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.specifiedJoinColumnAdded(notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 5: {
                this.specifiedJoinColumnsAdded(notification.getPosition(), (List)notification.getNewValue());
                break;
            }
            case 4: {
                this.specifiedJoinColumnRemoved(notification.getPosition(), (IJoinColumn)notification.getOldValue());
                break;
            }
            case 6: {
                if (notification.getPosition() == -1) {
                    this.specifiedJoinColumnsCleared((List)notification.getOldValue());
                    break;
                }
                this.specifiedJoinColumnsRemoved((int[])notification.getNewValue(), (List)notification.getOldValue());
                break;
            }
            case 1: {
                if (notification.isTouch()) break;
                this.specifiedJoinColumnSet(notification.getPosition(), (IJoinColumn)notification.getOldValue(), (IJoinColumn)notification.getNewValue());
                break;
            }
            case 7: {
                this.specifiedJoinColumnMoved(notification.getOldIntValue(), notification.getPosition(), (IJoinColumn)notification.getNewValue());
                break;
            }
        }
    }

    public void specifiedJoinColumnAdded(int index, IJoinColumn joinColumn) {
        if (((JavaJoinColumn)joinColumn).annotation(this.getAttribute().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + 1);
            ((JavaJoinColumn)joinColumn).newAnnotation();
        }
    }

    public void specifiedJoinColumnsAdded(int index, List<IJoinColumn> joinColumns) {
        if (!joinColumns.isEmpty() && ((JavaJoinColumn)joinColumns.get(0)).annotation(this.getAttribute().astRoot()) == null) {
            this.synchJoinColumnAnnotationsAfterAdd(index + joinColumns.size());
            for (JavaJoinColumn javaJoinColumn : joinColumns) {
                javaJoinColumn.newAnnotation();
            }
        }
    }

    public void specifiedJoinColumnRemoved(int index, IJoinColumn joinColumn) {
        ((JavaJoinColumn)joinColumn).removeAnnotation();
        this.synchJoinColumnAnnotationsAfterRemove(index);
    }

    public void specifiedJoinColumnsRemoved(int[] indexes, List<IJoinColumn> joinColumns) {
        for (JavaJoinColumn javaJoinColumn : joinColumns) {
            javaJoinColumn.removeAnnotation();
        }
        this.synchJoinColumnAnnotationsAfterRemove(indexes[0]);
    }

    public void specifiedJoinColumnsCleared(List<IJoinColumn> joinColumns) {
        for (JavaJoinColumn javaJoinColumn : joinColumns) {
            javaJoinColumn.removeAnnotation();
        }
    }

    public void specifiedJoinColumnSet(int index, IJoinColumn oldJoinColumn, IJoinColumn newJoinColumn) {
        ((JavaJoinColumn)newJoinColumn).newAnnotation();
    }

    public void specifiedJoinColumnMoved(int sourceIndex, int targetIndex, IJoinColumn joinColumn) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int begin = Math.min(sourceIndex, targetIndex);
        int end = Math.max(sourceIndex, targetIndex);
        int i = begin;
        while (i-- > end) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterAdd(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = joinColumns.size();
        while (i-- > index) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
        }
    }

    private void synchJoinColumnAnnotationsAfterRemove(int index) {
        EList<IJoinColumn> joinColumns = this.getSpecifiedJoinColumns();
        int i = index;
        while (i < joinColumns.size()) {
            this.synch((IJoinColumn)joinColumns.get(i), i);
            ++i;
        }
    }

    private void synch(IJoinColumn joinColumn, int index) {
        ((JavaJoinColumn)joinColumn).moveAnnotation(index);
    }

    protected abstract DeclarationAnnotationElementAdapter<String> optionalAdapter();

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_SINGLE_RELATIONSHIP_MAPPING;
    }

    @Override
    public DefaultEagerFetchType getFetch() {
        return this.fetch;
    }

    @Override
    public void setFetch(DefaultEagerFetchType newFetch) {
        DefaultEagerFetchType oldFetch = this.fetch;
        DefaultEagerFetchType defaultEagerFetchType = this.fetch = newFetch == null ? FETCH_EDEFAULT : newFetch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldFetch, (Object)this.fetch));
        }
    }

    @Override
    public EList<IJoinColumn> getJoinColumns() {
        return this.getSpecifiedJoinColumns().isEmpty() ? this.getDefaultJoinColumns() : this.getSpecifiedJoinColumns();
    }

    @Override
    public EList<IJoinColumn> getSpecifiedJoinColumns() {
        if (this.specifiedJoinColumns == null) {
            this.specifiedJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 7);
        }
        return this.specifiedJoinColumns;
    }

    @Override
    public EList<IJoinColumn> getDefaultJoinColumns() {
        if (this.defaultJoinColumns == null) {
            this.defaultJoinColumns = new EObjectContainmentEList(IJoinColumn.class, (InternalEObject)this, 8);
        }
        return this.defaultJoinColumns;
    }

    @Override
    public DefaultTrueBoolean getOptional() {
        return this.optional;
    }

    @Override
    public void setOptional(DefaultTrueBoolean newOptional) {
        DefaultTrueBoolean oldOptional = this.optional;
        DefaultTrueBoolean defaultTrueBoolean = this.optional = newOptional == null ? OPTIONAL_EDEFAULT : newOptional;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldOptional, (Object)this.optional));
        }
    }

    @Override
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 6: {
                return ((InternalEList)this.getJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 7: {
                return ((InternalEList)this.getSpecifiedJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
            case 8: {
                return ((InternalEList)this.getDefaultJoinColumns()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 5: {
                return this.getFetch();
            }
            case 6: {
                return this.getJoinColumns();
            }
            case 7: {
                return this.getSpecifiedJoinColumns();
            }
            case 8: {
                return this.getDefaultJoinColumns();
            }
            case 9: {
                return this.getOptional();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 5: {
                this.setFetch((DefaultEagerFetchType)((Object)newValue));
                return;
            }
            case 7: {
                this.getSpecifiedJoinColumns().clear();
                this.getSpecifiedJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getDefaultJoinColumns().clear();
                this.getDefaultJoinColumns().addAll((Collection)newValue);
                return;
            }
            case 9: {
                this.setOptional((DefaultTrueBoolean)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 5: {
                this.setFetch(FETCH_EDEFAULT);
                return;
            }
            case 7: {
                this.getSpecifiedJoinColumns().clear();
                return;
            }
            case 8: {
                this.getDefaultJoinColumns().clear();
                return;
            }
            case 9: {
                this.setOptional(OPTIONAL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 5: {
                return this.fetch != FETCH_EDEFAULT;
            }
            case 6: {
                return !this.getJoinColumns().isEmpty();
            }
            case 7: {
                return this.specifiedJoinColumns != null && !this.specifiedJoinColumns.isEmpty();
            }
            case 8: {
                return this.defaultJoinColumns != null && !this.defaultJoinColumns.isEmpty();
            }
            case 9: {
                return this.optional != OPTIONAL_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == ISingleRelationshipMapping.class) {
            switch (derivedFeatureID) {
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    @Override
    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == ISingleRelationshipMapping.class) {
            switch (baseFeatureID) {
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 9: {
                    return 9;
                }
            }
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (fetch: ");
        result.append((Object)this.fetch);
        result.append(", optional: ");
        result.append((Object)this.optional);
        result.append(')');
        return result.toString();
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateFetchFromJava(astRoot);
        this.updateSpecifiedJoinColumnsFromJava(astRoot);
        this.setOptional(DefaultTrueBoolean.fromJavaAnnotationValue(this.optionalAdapter.getValue(astRoot)));
    }

    /*
     * Unable to fully structure code
     */
    private void updateSpecifiedJoinColumnsFromJava(CompilationUnit astRoot) {
        block5: {
            joinColumns = this.getSpecifiedJoinColumns();
            persSize = joinColumns.size();
            javaSize = 0;
            allJavaAnnotationsFound = false;
            i = 0;
            while (i < persSize) {
                joinColumn = (JavaJoinColumn)joinColumns.get(i);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    break;
                }
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
                ++i;
            }
            if (!allJavaAnnotationsFound) ** GOTO lbl29
            while (persSize > javaSize) {
                joinColumns.remove(--persSize);
            }
            break block5;
lbl-1000:
            // 1 sources

            {
                joinColumn = this.createJavaJoinColumn(javaSize);
                if (joinColumn.annotation(astRoot) == null) {
                    allJavaAnnotationsFound = true;
                    continue;
                }
                this.getSpecifiedJoinColumns().add((Object)joinColumn);
                joinColumn.updateFromJava(astRoot);
                ++javaSize;
lbl29:
                // 3 sources

                ** while (!allJavaAnnotationsFound)
            }
        }
    }

    @Override
    protected void updateFetchFromJava(CompilationUnit astRoot) {
        this.setFetch(DefaultEagerFetchType.fromJavaAnnotationValue(this.getFetchAdapter().getValue(astRoot)));
    }

    @Override
    protected String javaDefaultTargetEntity(ITypeBinding typeBinding) {
        String typeName = super.javaDefaultTargetEntity(typeBinding);
        return JavaSingleRelationshipMapping.typeNamedIsContainer(typeName) ? null : typeName;
    }

    @Override
    public boolean containsSpecifiedJoinColumns() {
        return !this.getSpecifiedJoinColumns().isEmpty();
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        for (IJoinColumn column : this.getJoinColumns()) {
            result = ((JavaJoinColumn)column).candidateValuesFor(pos, filter, astRoot);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public IJoinColumn createJoinColumn(int index) {
        return this.createJavaJoinColumn(index);
    }

    private JavaJoinColumn createJavaJoinColumn(int index) {
        return JavaJoinColumn.createSingleRelationshipMappingJoinColumn(new ISingleRelationshipMapping.JoinColumnOwner(this), this.getAttribute(), index);
    }

    protected static DeclarationAnnotationElementAdapter<String> buildOptionalAdapter(DeclarationAnnotationAdapter annotationAdapter, String elementName) {
        return new ConversionDeclarationAnnotationElementAdapter<String>(annotationAdapter, elementName, false, BooleanStringExpressionConverter.instance());
    }
}

