/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.content.java.mappings;

import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.content.java.mappings.IJavaVersion;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaAttributeMapping;
import org.eclipse.jpt.core.internal.content.java.mappings.JavaColumn;
import org.eclipse.jpt.core.internal.content.java.mappings.JpaJavaMappingsPackage;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.AnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.Attribute;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.DeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.EnumDeclarationAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.MemberAnnotationAdapter;
import org.eclipse.jpt.core.internal.jdtutility.ShortCircuitAnnotationElementAdapter;
import org.eclipse.jpt.core.internal.jdtutility.SimpleDeclarationAnnotationAdapter;
import org.eclipse.jpt.core.internal.mappings.IColumn;
import org.eclipse.jpt.core.internal.mappings.IColumnMapping;
import org.eclipse.jpt.core.internal.mappings.IVersion;
import org.eclipse.jpt.core.internal.mappings.TemporalType;
import org.eclipse.jpt.utility.internal.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaVersion
extends JavaAttributeMapping
implements IJavaVersion {
    private final AnnotationAdapter temporalAnnotationAdapter;
    private final AnnotationElementAdapter<String> temporalValueAdapter;
    public static final DeclarationAnnotationAdapter DECLARATION_ANNOTATION_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Version");
    private static final DeclarationAnnotationAdapter TEMPORAL_ADAPTER = new SimpleDeclarationAnnotationAdapter("javax.persistence.Temporal");
    private static final DeclarationAnnotationElementAdapter<String> TEMPORAL_VALUE_ADAPTER = JavaVersion.buildTemporalValueAdapter();
    protected IColumn column;
    protected static final TemporalType TEMPORAL_EDEFAULT = TemporalType.NULL;
    protected TemporalType temporal = TEMPORAL_EDEFAULT;

    protected JavaVersion() {
        throw new UnsupportedOperationException("Use JavaVersion(Attribute) instead");
    }

    protected JavaVersion(Attribute attribute) {
        super(attribute);
        this.column = JavaColumn.createColumnMappingColumn(this.buildColumnOwner(), this.getAttribute());
        ((InternalEObject)this.column).eInverseAdd((InternalEObject)this, -1, null, null);
        this.temporalAnnotationAdapter = new MemberAnnotationAdapter(this.getAttribute(), TEMPORAL_ADAPTER);
        this.temporalValueAdapter = new ShortCircuitAnnotationElementAdapter<String>(attribute, TEMPORAL_VALUE_ADAPTER);
    }

    @Override
    protected EClass eStaticClass() {
        return JpaJavaMappingsPackage.Literals.JAVA_VERSION;
    }

    @Override
    public IColumn getColumn() {
        return this.column;
    }

    public NotificationChain basicSetColumn(IColumn newColumn, NotificationChain msgs) {
        IColumn oldColumn = this.column;
        this.column = newColumn;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldColumn, (Object)newColumn);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public TemporalType getTemporal() {
        return this.temporal;
    }

    public void setTemporalGen(TemporalType newTemporal) {
        TemporalType oldTemporal = this.temporal;
        TemporalType temporalType = this.temporal = newTemporal == null ? TEMPORAL_EDEFAULT : newTemporal;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldTemporal, (Object)this.temporal));
        }
    }

    @Override
    public void setTemporal(TemporalType newTemporal) {
        if (newTemporal != TemporalType.NULL) {
            if (this.temporalAnnotationAdapter.getAnnotation() == null) {
                this.temporalAnnotationAdapter.newMarkerAnnotation();
            }
            this.temporalValueAdapter.setValue(newTemporal.convertToJavaAnnotationValue());
        } else if (this.temporalAnnotationAdapter.getAnnotation() != null) {
            this.temporalAnnotationAdapter.removeAnnotation();
        }
        this.setTemporalGen(newTemporal);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetColumn(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getColumn();
            }
            case 1: {
                return this.getTemporal();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setTemporal((TemporalType)((Object)newValue));
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setTemporal(TEMPORAL_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.column != null;
            }
            case 1: {
                return this.temporal != TEMPORAL_EDEFAULT;
            }
        }
        return super.eIsSet(featureID);
    }

    public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IVersion.class) {
            switch (derivedFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == IJavaVersion.class) {
            return -1;
        }
        return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
    }

    public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
        if (baseClass == IColumnMapping.class) {
            return -1;
        }
        if (baseClass == IVersion.class) {
            switch (baseFeatureID) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
            }
            return -1;
        }
        if (baseClass == IJavaVersion.class) {
            return -1;
        }
        return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (temporal: ");
        result.append((Object)this.temporal);
        result.append(')');
        return result.toString();
    }

    @Override
    protected DeclarationAnnotationAdapter declarationAnnotationAdapter() {
        return DECLARATION_ANNOTATION_ADAPTER;
    }

    @Override
    public String getKey() {
        return "version";
    }

    @Override
    public void updateFromJava(CompilationUnit astRoot) {
        super.updateFromJava(astRoot);
        this.updateTemporalFromJava(astRoot);
        this.getJavaColumn().updateFromJava(astRoot);
    }

    private void updateTemporalFromJava(CompilationUnit astRoot) {
        if (this.temporalAnnotationAdapter.getAnnotation(astRoot) == null) {
            this.setTemporalGen(TemporalType.NULL);
        } else {
            this.setTemporalGen(TemporalType.fromJavaAnnotationValue(this.temporalValueAdapter.getValue(astRoot)));
        }
    }

    private JavaColumn getJavaColumn() {
        return (JavaColumn)this.column;
    }

    @Override
    public Iterator<String> candidateValuesFor(int pos, Filter<String> filter, CompilationUnit astRoot) {
        Iterator<String> result = super.candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        result = this.getJavaColumn().candidateValuesFor(pos, filter, astRoot);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static DeclarationAnnotationElementAdapter<String> buildTemporalValueAdapter() {
        return new EnumDeclarationAnnotationElementAdapter(TEMPORAL_ADAPTER, "value", false);
    }
}

